/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnweb.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.onlab.packet.IpAddress;
import org.onlab.util.ItemNotFoundException;
import org.onosproject.codec.CodecContext;
import org.onosproject.rest.AbstractWebResource;
import org.onosproject.vtnrsc.DefaultRouter;
import org.onosproject.vtnrsc.FixedIp;
import org.onosproject.vtnrsc.Router;
import org.onosproject.vtnrsc.RouterGateway;
import org.onosproject.vtnrsc.RouterId;
import org.onosproject.vtnrsc.RouterInterface;
import org.onosproject.vtnrsc.SubnetId;
import org.onosproject.vtnrsc.TenantId;
import org.onosproject.vtnrsc.TenantNetworkId;
import org.onosproject.vtnrsc.VirtualPortId;
import org.onosproject.vtnrsc.router.RouterService;
import org.onosproject.vtnrsc.routerinterface.RouterInterfaceService;
import org.onosproject.vtnweb.web.RouterCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="routers")
public class RouterWebResource
extends AbstractWebResource {
    private final Logger log = LoggerFactory.getLogger(RouterWebResource.class);
    public static final String CREATE_FAIL = "Router is failed to create!";
    public static final String UPDATE_FAIL = "Router is failed to update!";
    public static final String GET_FAIL = "Router is failed to get!";
    public static final String NOT_EXIST = "Router does not exist!";
    public static final String DELETE_SUCCESS = "Router delete success!";
    public static final String JSON_NOT_NULL = "JsonNode can not be null";
    public static final String INTFACR_ADD_SUCCESS = "Interface add success";
    public static final String INTFACR_DEL_SUCCESS = "Interface delete success";

    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response listRouters() {
        Collection routers = ((RouterService)this.get(RouterService.class)).getRouters();
        ObjectNode result = new ObjectMapper().createObjectNode();
        result.set("routers", (JsonNode)new RouterCodec().encode((Iterable)routers, (CodecContext)this));
        return RouterWebResource.ok((Object)result.toString()).build();
    }

    @GET
    @Path(value="{routerUUID}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response getRouter(@PathParam(value="routerUUID") String id, @QueryParam(value="fields") List<String> fields) {
        if (!((RouterService)this.get(RouterService.class)).exists(RouterId.valueOf((String)id))) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"The Router does not exists").build();
        }
        Router sub = (Router)this.nullIsNotFound((Object)((RouterService)this.get(RouterService.class)).getRouter(RouterId.valueOf((String)id)), "Router does not exist!");
        ObjectNode result = new ObjectMapper().createObjectNode();
        if (fields.size() > 0) {
            result.set("router", (JsonNode)new RouterCodec().extracFields(sub, (CodecContext)this, fields));
        } else {
            result.set("router", (JsonNode)new RouterCodec().encode(sub, (CodecContext)this));
        }
        return RouterWebResource.ok((Object)result.toString()).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response createRouter(InputStream input) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode subnode = mapper.readTree(input);
            Collection routers = this.createOrUpdateByInputStream(subnode);
            Boolean result = (Boolean)this.nullIsNotFound((Object)((RouterService)this.get(RouterService.class)).createRouters(routers), "Router is failed to create!");
            if (!result.booleanValue()) {
                return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"Router is failed to create!").build();
            }
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)result.toString()).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Path(value="{routerUUID}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateRouter(@PathParam(value="routerUUID") String id, InputStream input) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode subnode = mapper.readTree(input);
            Collection routers = this.changeUpdateJsonToSub(subnode, id);
            Boolean result = (Boolean)this.nullIsNotFound((Object)((RouterService)this.get(RouterService.class)).updateRouters(routers), "Router is failed to update!");
            if (!result.booleanValue()) {
                return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"Router is failed to update!").build();
            }
            return RouterWebResource.ok((Object)result.toString()).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @DELETE
    @Path(value="{routerUUID}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteSingleRouter(@PathParam(value="routerUUID") String id) throws IOException {
        try {
            RouterId routerId = RouterId.valueOf((String)id);
            HashSet routerIds = Sets.newHashSet((Object[])new RouterId[]{routerId});
            ((RouterService)this.get(RouterService.class)).removeRouters((Collection)routerIds);
            return Response.noContent().entity((Object)"Router delete success!").build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Path(value="{routerUUID}/add_router_interface")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response addRouterInterface(@PathParam(value="routerUUID") String id, InputStream input) {
        if (!((RouterService)this.get(RouterService.class)).exists(RouterId.valueOf((String)id))) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Router does not exist!").build();
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode subnode = mapper.readTree(input);
            if (!subnode.hasNonNull("id")) {
                throw new IllegalArgumentException("id should not be null");
            }
            if (subnode.get("id").asText().isEmpty()) {
                throw new IllegalArgumentException("id should not be empty");
            }
            RouterId routerId = RouterId.valueOf((String)id);
            if (!subnode.hasNonNull("subnet_id")) {
                throw new IllegalArgumentException("subnet_id should not be null");
            }
            if (subnode.get("subnet_id").asText().isEmpty()) {
                throw new IllegalArgumentException("subnet_id should not be empty");
            }
            SubnetId subnetId = SubnetId.subnetId((String)subnode.get("subnet_id").asText());
            if (!subnode.hasNonNull("tenant_id")) {
                throw new IllegalArgumentException("tenant_id should not be null");
            }
            if (subnode.get("tenant_id").asText().isEmpty()) {
                throw new IllegalArgumentException("tenant_id should not be empty");
            }
            TenantId tenentId = TenantId.tenantId((String)subnode.get("tenant_id").asText());
            if (!subnode.hasNonNull("port_id")) {
                throw new IllegalArgumentException("port_id should not be null");
            }
            if (subnode.get("port_id").asText().isEmpty()) {
                throw new IllegalArgumentException("port_id should not be empty");
            }
            VirtualPortId portId = VirtualPortId.portId((String)subnode.get("port_id").asText());
            RouterInterface routerInterface = RouterInterface.routerInterface((SubnetId)subnetId, (VirtualPortId)portId, (RouterId)routerId, (TenantId)tenentId);
            ((RouterInterfaceService)this.get(RouterInterfaceService.class)).addRouterInterface(routerInterface);
            return RouterWebResource.ok((Object)"Interface add success").build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Path(value="{routerUUID}/remove_router_interface")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response removeRouterInterface(@PathParam(value="routerUUID") String id, InputStream input) {
        if (!((RouterService)this.get(RouterService.class)).exists(RouterId.valueOf((String)id))) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Router does not exist!").build();
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode subnode = mapper.readTree(input);
            if (!subnode.hasNonNull("id")) {
                throw new IllegalArgumentException("id should not be null");
            }
            if (subnode.get("id").asText().isEmpty()) {
                throw new IllegalArgumentException("id should not be empty");
            }
            RouterId routerId = RouterId.valueOf((String)id);
            if (!subnode.hasNonNull("subnet_id")) {
                throw new IllegalArgumentException("subnet_id should not be null");
            }
            if (subnode.get("subnet_id").asText().isEmpty()) {
                throw new IllegalArgumentException("subnet_id should not be empty");
            }
            SubnetId subnetId = SubnetId.subnetId((String)subnode.get("subnet_id").asText());
            if (!subnode.hasNonNull("port_id")) {
                throw new IllegalArgumentException("port_id should not be null");
            }
            if (subnode.get("port_id").asText().isEmpty()) {
                throw new IllegalArgumentException("port_id should not be empty");
            }
            VirtualPortId portId = VirtualPortId.portId((String)subnode.get("port_id").asText());
            if (!subnode.hasNonNull("tenant_id")) {
                throw new IllegalArgumentException("tenant_id should not be null");
            }
            if (subnode.get("tenant_id").asText().isEmpty()) {
                throw new IllegalArgumentException("tenant_id should not be empty");
            }
            TenantId tenentId = TenantId.tenantId((String)subnode.get("tenant_id").asText());
            RouterInterface routerInterface = RouterInterface.routerInterface((SubnetId)subnetId, (VirtualPortId)portId, (RouterId)routerId, (TenantId)tenentId);
            ((RouterInterfaceService)this.get(RouterInterfaceService.class)).removeRouterInterface(routerInterface);
            return RouterWebResource.ok((Object)"Interface delete success").build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    private Collection<Router> createOrUpdateByInputStream(JsonNode subnode) throws Exception {
        Preconditions.checkNotNull((Object)subnode, (Object)"JsonNode can not be null");
        JsonNode routerNode = subnode.get("routers");
        if (routerNode == null) {
            routerNode = subnode.get("router");
        }
        this.log.debug("routerNode is {}", (Object)routerNode.toString());
        if (routerNode.isArray()) {
            throw new Exception("only singleton requests allowed");
        }
        return this.changeJsonToSub(routerNode);
    }

    public Collection<Router> changeJsonToSub(JsonNode routerNode) throws Exception {
        Preconditions.checkNotNull((Object)routerNode, (Object)"JsonNode can not be null");
        HashMap<RouterId, DefaultRouter> subMap = new HashMap<RouterId, DefaultRouter>();
        if (!routerNode.hasNonNull("id")) {
            new IllegalArgumentException("id should not be null");
        } else if (routerNode.get("id").asText().isEmpty()) {
            throw new IllegalArgumentException("id should not be empty");
        }
        RouterId id = RouterId.valueOf((String)routerNode.get("id").asText());
        if (!routerNode.hasNonNull("tenant_id")) {
            throw new IllegalArgumentException("tenant_id should not be null");
        }
        if (routerNode.get("tenant_id").asText().isEmpty()) {
            throw new IllegalArgumentException("tenant_id should not be empty");
        }
        TenantId tenantId = TenantId.tenantId((String)routerNode.get("tenant_id").asText());
        VirtualPortId gwPortId = null;
        if (routerNode.hasNonNull("gw_port_id")) {
            gwPortId = VirtualPortId.portId((String)routerNode.get("gw_port_id").asText());
        }
        if (!routerNode.hasNonNull("status")) {
            throw new IllegalArgumentException("status should not be null");
        }
        if (routerNode.get("status").asText().isEmpty()) {
            throw new IllegalArgumentException("status should not be empty");
        }
        Router.Status status = Router.Status.valueOf((String)routerNode.get("status").asText());
        String routerName = null;
        if (routerNode.hasNonNull("name")) {
            routerName = routerNode.get("name").asText();
        }
        boolean adminStateUp = true;
        Preconditions.checkArgument((boolean)routerNode.get("admin_state_up").isBoolean(), (Object)"admin_state_up should be boolean");
        if (routerNode.hasNonNull("admin_state_up")) {
            adminStateUp = routerNode.get("admin_state_up").asBoolean();
        }
        boolean distributed = false;
        if (routerNode.hasNonNull("distributed")) {
            distributed = routerNode.get("distributed").asBoolean();
        }
        RouterGateway gateway = null;
        if (routerNode.hasNonNull("external_gateway_info")) {
            gateway = this.jsonNodeToGateway(routerNode.get("external_gateway_info"));
        }
        ArrayList routes = new ArrayList();
        DefaultRouter routerObj = new DefaultRouter(id, routerName, adminStateUp, status, distributed, gateway, gwPortId, tenantId, routes);
        subMap.put(id, routerObj);
        return Collections.unmodifiableCollection(subMap.values());
    }

    public Collection<Router> changeUpdateJsonToSub(JsonNode subnode, String routerId) throws Exception {
        Preconditions.checkNotNull((Object)subnode, (Object)"JsonNode can not be null");
        Preconditions.checkNotNull((Object)routerId, (Object)"routerId should not be null");
        HashMap<RouterId, DefaultRouter> subMap = new HashMap<RouterId, DefaultRouter>();
        JsonNode routerNode = subnode.get("router");
        RouterId id = RouterId.valueOf((String)routerId);
        Router sub = (Router)this.nullIsNotFound((Object)((RouterService)this.get(RouterService.class)).getRouter(id), "Router does not exist!");
        TenantId tenantId = sub.tenantId();
        VirtualPortId gwPortId = null;
        if (routerNode.hasNonNull("gw_port_id")) {
            gwPortId = VirtualPortId.portId((String)routerNode.get("gw_port_id").asText());
        }
        Router.Status status = sub.status();
        String routerName = routerNode.get("name").asText();
        Preconditions.checkArgument((boolean)routerNode.get("admin_state_up").isBoolean(), (Object)"admin_state_up should be boolean");
        boolean adminStateUp = routerNode.get("admin_state_up").asBoolean();
        boolean distributed = sub.distributed();
        if (routerNode.hasNonNull("distributed")) {
            distributed = routerNode.get("distributed").asBoolean();
        }
        RouterGateway gateway = sub.externalGatewayInfo();
        if (routerNode.hasNonNull("external_gateway_info")) {
            gateway = this.jsonNodeToGateway(routerNode.get("external_gateway_info"));
        }
        ArrayList routes = new ArrayList();
        DefaultRouter routerObj = new DefaultRouter(id, routerName, adminStateUp, status, distributed, gateway, gwPortId, tenantId, routes);
        subMap.put(id, routerObj);
        return Collections.unmodifiableCollection(subMap.values());
    }

    private RouterGateway jsonNodeToGateway(JsonNode gateway) {
        Preconditions.checkNotNull((Object)gateway, (Object)"JsonNode can not be null");
        if (!gateway.hasNonNull("network_id")) {
            throw new IllegalArgumentException("network_id should not be null");
        }
        if (gateway.get("network_id").asText().isEmpty()) {
            throw new IllegalArgumentException("network_id should not be empty");
        }
        TenantNetworkId networkId = TenantNetworkId.networkId((String)gateway.get("network_id").asText());
        if (!gateway.hasNonNull("enable_snat")) {
            throw new IllegalArgumentException("enable_snat should not be null");
        }
        if (gateway.get("enable_snat").asText().isEmpty()) {
            throw new IllegalArgumentException("enable_snat should not be empty");
        }
        Preconditions.checkArgument((boolean)gateway.get("enable_snat").isBoolean(), (Object)"enable_snat should be boolean");
        boolean enableSnat = gateway.get("enable_snat").asBoolean();
        if (!gateway.hasNonNull("external_fixed_ips")) {
            throw new IllegalArgumentException("external_fixed_ips should not be null");
        }
        if (gateway.get("external_fixed_ips").isNull()) {
            throw new IllegalArgumentException("external_fixed_ips should not be empty");
        }
        Iterable fixedIpList = this.jsonNodeToFixedIp(gateway.get("external_fixed_ips"));
        RouterGateway gatewayObj = RouterGateway.routerGateway((TenantNetworkId)networkId, (boolean)enableSnat, (Set)Sets.newHashSet((Iterable)fixedIpList));
        return gatewayObj;
    }

    private Iterable<FixedIp> jsonNodeToFixedIp(JsonNode fixedIp) {
        Preconditions.checkNotNull((Object)fixedIp, (Object)"JsonNode can not be null");
        ConcurrentMap fixedIpMaps = Maps.newConcurrentMap();
        Integer i = 0;
        for (JsonNode node : fixedIp) {
            if (!node.hasNonNull("subnet_id")) {
                throw new IllegalArgumentException("subnet_id should not be null");
            }
            if (node.get("subnet_id").asText().isEmpty()) {
                throw new IllegalArgumentException("subnet_id should not be empty");
            }
            SubnetId subnetId = SubnetId.subnetId((String)node.get("subnet_id").asText());
            if (!node.hasNonNull("ip_address")) {
                throw new IllegalArgumentException("ip_address should not be null");
            }
            if (node.get("ip_address").asText().isEmpty()) {
                throw new IllegalArgumentException("ip_address should not be empty");
            }
            IpAddress ipAddress = IpAddress.valueOf((String)node.get("ip_address").asText());
            FixedIp fixedIpObj = FixedIp.fixedIp((SubnetId)subnetId, (IpAddress)ipAddress);
            fixedIpMaps.putIfAbsent(i, fixedIpObj);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return Collections.unmodifiableCollection(fixedIpMaps.values());
    }

    protected <T> T nullIsNotFound(T item, String message) {
        if (item == null) {
            throw new ItemNotFoundException(message);
        }
        return item;
    }
}

