/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnweb.web;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.vtnrsc.PortChain;
import org.onosproject.vtnrsc.PortChainId;
import org.onosproject.vtnrsc.TenantId;
import org.onosproject.vtnweb.web.SfcCodecContext;

public class PortChainCodecTest {
    SfcCodecContext context;
    JsonCodec<PortChain> portChainCodec;

    @Before
    public void setUp() {
        this.context = new SfcCodecContext();
        this.portChainCodec = this.context.codec(PortChain.class);
        MatcherAssert.assertThat(this.portChainCodec, (Matcher)Matchers.notNullValue());
    }

    private PortChain getPortChain(String resourceName) throws IOException {
        InputStream jsonStream = PortChainCodecTest.class.getResourceAsStream(resourceName);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode json = mapper.readTree(jsonStream);
        MatcherAssert.assertThat((Object)json, (Matcher)Matchers.notNullValue());
        PortChain portChain = (PortChain)this.portChainCodec.decode((ObjectNode)json, (CodecContext)this.context);
        MatcherAssert.assertThat((Object)portChain, (Matcher)Matchers.notNullValue());
        return portChain;
    }

    @Test
    public void codecPortChainTest() throws IOException {
        PortChain portChain = this.getPortChain("portChain.json");
        MatcherAssert.assertThat((Object)portChain, (Matcher)Matchers.notNullValue());
        PortChainId portChainId = PortChainId.of((String)"1278dcd4-459f-62ed-754b-87fc5e4a6751");
        TenantId tenantId = TenantId.tenantId((String)"d382007aa9904763a801f68ecf065cf5");
        MatcherAssert.assertThat((Object)portChain.portChainId().toString(), (Matcher)Matchers.is((Object)portChainId.toString()));
        MatcherAssert.assertThat((Object)portChain.name(), (Matcher)Matchers.is((Object)"PC2"));
        MatcherAssert.assertThat((Object)portChain.tenantId().toString(), (Matcher)Matchers.is((Object)tenantId.toString()));
        MatcherAssert.assertThat((Object)portChain.description(), (Matcher)Matchers.is((Object)"Two flows and two port-pair-groups"));
        MatcherAssert.assertThat((Object)portChain.flowClassifiers(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)portChain.portPairGroups(), (Matcher)Matchers.notNullValue());
    }
}

