/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.xosclient.api;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onosproject.xosclient.api.VtnPortId;
import org.onosproject.xosclient.api.VtnServiceId;

public final class VtnPort {
    private final VtnPortId id;
    private final String name;
    private final VtnServiceId serviceId;
    private final MacAddress mac;
    private final IpAddress ip;
    private final Map<IpAddress, MacAddress> addressPairs;

    private VtnPort(VtnPortId id, String name, VtnServiceId serviceId, MacAddress mac, IpAddress ip, Map<IpAddress, MacAddress> addressPairs) {
        this.id = id;
        this.name = name;
        this.serviceId = serviceId;
        this.mac = mac;
        this.ip = ip;
        this.addressPairs = addressPairs;
    }

    public VtnPortId id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public VtnServiceId serviceId() {
        return this.serviceId;
    }

    public MacAddress mac() {
        return this.mac;
    }

    public IpAddress ip() {
        return this.ip;
    }

    public Map<IpAddress, MacAddress> addressPairs() {
        return this.addressPairs;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VtnPort)) {
            return false;
        }
        VtnPort other = (VtnPort)obj;
        return Objects.equals((Object)this.id, (Object)other.id);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("name", (Object)this.name).add("serviceId", (Object)this.serviceId).add("mac", (Object)this.mac).add("ip", (Object)this.ip).add("addressPairs", this.addressPairs).toString();
    }

    public static final Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private VtnPortId id;
        private String name;
        private VtnServiceId serviceId;
        private MacAddress mac;
        private IpAddress ip;
        private Map<IpAddress, MacAddress> addressPairs;

        private Builder() {
        }

        public VtnPort build() {
            Preconditions.checkNotNull((Object)((Object)this.id), (Object)"VTN port ID cannot be null");
            Preconditions.checkNotNull((Object)((Object)this.serviceId), (Object)"VTN port service ID cannot be null");
            Preconditions.checkNotNull((Object)this.mac, (Object)"VTN port MAC address cannot be null");
            Preconditions.checkNotNull((Object)this.ip, (Object)"VTN port IP address cannot be null");
            this.addressPairs = this.addressPairs == null ? ImmutableMap.of() : this.addressPairs;
            return new VtnPort(this.id, this.name, this.serviceId, this.mac, this.ip, this.addressPairs);
        }

        public Builder id(VtnPortId id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder serviceId(VtnServiceId serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public Builder mac(MacAddress mac) {
            if (mac == null) {
                String msg = "VTN port MAC address cannot be null";
                throw new IllegalArgumentException("VTN port MAC address cannot be null");
            }
            this.mac = mac;
            return this;
        }

        public Builder mac(String mac) {
            try {
                return this.mac(MacAddress.valueOf((String)mac));
            }
            catch (IllegalArgumentException | NullPointerException e) {
                String msg = "Malformed MAC address string " + mac + " for VTN port MAC address";
                throw new IllegalArgumentException(msg);
            }
        }

        public Builder ip(IpAddress ip) {
            if (ip == null) {
                String msg = "VTN port IP address cannot be null";
                throw new IllegalArgumentException("VTN port IP address cannot be null");
            }
            this.ip = ip;
            return this;
        }

        public Builder ip(String ip) {
            try {
                return this.ip(IpAddress.valueOf((String)ip));
            }
            catch (IllegalArgumentException | NullPointerException e) {
                String msg = "Malformed IP address string " + ip + " for VTN port IP address";
                throw new IllegalArgumentException(msg);
            }
        }

        public Builder addressPairs(Map<IpAddress, MacAddress> addressPairs) {
            if (addressPairs == null) {
                String msg = "VTN address pairs cannot be null";
                throw new IllegalArgumentException("VTN address pairs cannot be null");
            }
            this.addressPairs = addressPairs;
            return this;
        }
    }
}

