/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.xosclient.api;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class XosAccess {
    private final String endpoint;
    private final String username;
    private final String password;

    public XosAccess(String endpoint, String adminUser, String adminPassword) {
        this.endpoint = (String)Preconditions.checkNotNull((Object)endpoint);
        this.username = (String)Preconditions.checkNotNull((Object)adminUser);
        this.password = (String)Preconditions.checkNotNull((Object)adminPassword);
    }

    public String endpoint() {
        return this.endpoint;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public int hashCode() {
        return Objects.hash(this.endpoint, this.username, this.password);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof XosAccess) {
            XosAccess that = (XosAccess)obj;
            if (Objects.equals(this.endpoint, that.endpoint) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("endpoint", (Object)this.endpoint).add("username", (Object)this.username).add("password", (Object)this.password).toString();
    }
}

