/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.xosclient.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.onosproject.xosclient.api.OpenStackAccess;
import org.onosproject.xosclient.api.VtnService;
import org.onosproject.xosclient.api.VtnServiceApi;
import org.onosproject.xosclient.api.VtnServiceId;
import org.onosproject.xosclient.api.XosAccess;
import org.onosproject.xosclient.impl.XosApi;
import org.openstack4j.api.OSClient;
import org.openstack4j.api.client.IOSClientBuilder;
import org.openstack4j.api.exceptions.AuthenticationException;
import org.openstack4j.model.network.Network;
import org.openstack4j.model.network.Subnet;
import org.openstack4j.openstack.OSFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultVtnServiceApi
extends XosApi
implements VtnServiceApi {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public DefaultVtnServiceApi(String baseUrl, XosAccess access) {
        super(baseUrl, access);
    }

    @Override
    public Set<VtnServiceId> services() {
        String response = this.restGet("");
        this.log.trace("Get services {}", (Object)response);
        ObjectMapper mapper = new ObjectMapper();
        HashSet services = Sets.newHashSet();
        try {
            JsonNode nodes = mapper.readTree(response);
            nodes.fieldNames().forEachRemaining(id -> services.add(VtnServiceId.of(id)));
        }
        catch (IOException e) {
            this.log.warn("Failed to get service list");
        }
        return services;
    }

    @Override
    public VtnService service(VtnServiceId serviceId) {
        return null;
    }

    @Override
    public Set<VtnServiceId> providerServices(VtnServiceId tServiceId) {
        Preconditions.checkNotNull((Object)((Object)tServiceId));
        String response = this.restGet((String)tServiceId.id());
        this.log.trace("Get provider services {}", (Object)response);
        ObjectMapper mapper = new ObjectMapper();
        HashSet pServices = Sets.newHashSet();
        try {
            JsonNode nodes = mapper.readTree(response);
            nodes.forEach(node -> pServices.add(VtnServiceId.of(node.asText())));
        }
        catch (IOException e) {
            this.log.warn("Failed to get service dependency");
        }
        return pServices;
    }

    @Override
    public Set<VtnServiceId> tenantServices(VtnServiceId tServiceId) {
        Preconditions.checkNotNull((Object)((Object)tServiceId));
        String response = this.restGet("");
        this.log.trace("Get tenant services {}", (Object)response);
        ObjectMapper mapper = new ObjectMapper();
        HashSet tServices = Sets.newHashSet();
        try {
            JsonNode nodes = mapper.readTree(response);
            nodes.fields().forEachRemaining(entry -> ((JsonNode)entry.getValue()).forEach(pService -> {
                if (pService.asText().equals(tServiceId.id())) {
                    tServices.add(VtnServiceId.of((String)entry.getKey()));
                }
            }));
        }
        catch (IOException e) {
            this.log.warn("Failed to get service list");
        }
        return tServices;
    }

    @Override
    public VtnService service(VtnServiceId serviceId, OpenStackAccess osAccess) {
        Preconditions.checkNotNull((Object)osAccess);
        OSClient osClient = this.getOpenStackClient(osAccess);
        Network osNet = osClient.networking().network().get((String)serviceId.id());
        if (osNet == null) {
            this.log.warn("Failed to get OpenStack network {}", (Object)serviceId);
            return null;
        }
        Subnet osSubnet = osNet.getNeutronSubnets().stream().findFirst().orElse(null);
        if (osSubnet == null) {
            this.log.warn("Failed to get OpenStack subnet of network {}", (Object)serviceId);
            return null;
        }
        return VtnService.build().id(serviceId).name(osNet.getName()).serviceType(this.serviceType(osNet.getName())).networkType(this.networkType(osNet.getName())).vni(osNet.getProviderSegID()).subnet(osSubnet.getCidr()).serviceIp(osSubnet.getGateway()).providerServices(this.providerServices(serviceId)).tenantServices(this.tenantServices(serviceId)).build();
    }

    private OSClient getOpenStackClient(OpenStackAccess osAccess) {
        Preconditions.checkNotNull((Object)osAccess);
        try {
            return (OSClient)((IOSClientBuilder.V2)((IOSClientBuilder.V2)OSFactory.builder().endpoint(osAccess.endpoint())).credentials(osAccess.user(), osAccess.password())).tenantName(osAccess.tenant()).authenticate();
        }
        catch (AuthenticationException e) {
            this.log.warn("Failed to authenticate OpenStack API with {}", (Object)osAccess);
            return null;
        }
    }

    private VtnServiceApi.NetworkType networkType(String netName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)netName) ? 1 : 0) != 0, (Object)"VTN network name cannot be null");
        String name = netName.toUpperCase();
        if (name.contains(VtnServiceApi.NetworkType.PUBLIC.name())) {
            return VtnServiceApi.NetworkType.PUBLIC;
        }
        if (name.contains(VtnServiceApi.NetworkType.MANAGEMENT_HOSTS.name())) {
            return VtnServiceApi.NetworkType.MANAGEMENT_HOSTS;
        }
        if (name.contains("MANAGEMENT")) {
            return VtnServiceApi.NetworkType.MANAGEMENT_LOCAL;
        }
        return VtnServiceApi.NetworkType.PRIVATE;
    }

    private VtnServiceApi.ServiceType serviceType(String netName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)netName) ? 1 : 0) != 0, (Object)"VTN network name cannot be null");
        String name = netName.toUpperCase();
        if (name.contains(VtnServiceApi.ServiceType.VSG.name())) {
            return VtnServiceApi.ServiceType.VSG;
        }
        if (name.contains(VtnServiceApi.ServiceType.ACCESS_AGENT.name())) {
            return VtnServiceApi.ServiceType.ACCESS_AGENT;
        }
        if (name.contains(VtnServiceApi.ServiceType.MANAGEMENT.name())) {
            return VtnServiceApi.ServiceType.MANAGEMENT;
        }
        return VtnServiceApi.ServiceType.DEFAULT;
    }
}

