/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.xosclient.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Set;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onosproject.xosclient.api.OpenStackAccess;
import org.onosproject.xosclient.api.VtnPort;
import org.onosproject.xosclient.api.VtnPortApi;
import org.onosproject.xosclient.api.VtnPortId;
import org.onosproject.xosclient.api.VtnServiceId;
import org.onosproject.xosclient.api.XosAccess;
import org.onosproject.xosclient.impl.XosApi;
import org.openstack4j.api.OSClient;
import org.openstack4j.api.client.IOSClientBuilder;
import org.openstack4j.api.exceptions.AuthenticationException;
import org.openstack4j.model.network.IP;
import org.openstack4j.model.network.Port;
import org.openstack4j.openstack.OSFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultVtnPortApi
extends XosApi
implements VtnPortApi {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public DefaultVtnPortApi(String baseUrl, XosAccess access) {
        super(baseUrl, access);
    }

    @Override
    public Set<VtnPort> vtnPorts() {
        return null;
    }

    @Override
    public Set<VtnPort> vtnPorts(VtnServiceId serviceId) {
        return null;
    }

    @Override
    public VtnPort vtnPort(VtnPortId portId) {
        return null;
    }

    @Override
    public VtnPort vtnPort(String portName, OpenStackAccess osAccess) {
        Preconditions.checkNotNull((Object)osAccess);
        OSClient osClient = this.getOpenStackClient(osAccess);
        Port osPort = osClient.networking().port().list().stream().filter(p -> p.getId().contains(portName.substring(3))).findFirst().orElse(null);
        if (osPort == null) {
            this.log.warn("Failed to get OpenStack port for {}", (Object)portName);
            return null;
        }
        return this.getVtnPort(osPort);
    }

    @Override
    public VtnPort vtnPort(VtnPortId portId, OpenStackAccess osAccess) {
        Preconditions.checkNotNull((Object)osAccess);
        OSClient osClient = this.getOpenStackClient(osAccess);
        Port osPort = osClient.networking().port().get((String)portId.id());
        if (osPort == null) {
            this.log.warn("Failed to get OpenStack port {}", (Object)portId);
            return null;
        }
        return this.getVtnPort(osPort);
    }

    private VtnPort getVtnPort(Port osPort) {
        Preconditions.checkNotNull((Object)osPort);
        IP ipAddr = osPort.getFixedIps().stream().findFirst().orElse(null);
        if (ipAddr == null) {
            this.log.warn("Failed to get IP address for {}", (Object)osPort);
            return null;
        }
        HashMap addressPairs = Maps.newHashMap();
        osPort.getAllowedAddressPairs().forEach(pair -> addressPairs.put(IpAddress.valueOf((String)pair.getIpAddress()), MacAddress.valueOf((String)pair.getMacAddress())));
        return VtnPort.builder().id(VtnPortId.of(osPort.getId())).name(osPort.getName()).serviceId(VtnServiceId.of(osPort.getNetworkId())).mac(osPort.getMacAddress()).ip(ipAddr.getIpAddress()).addressPairs(addressPairs).build();
    }

    private OSClient getOpenStackClient(OpenStackAccess osAccess) {
        Preconditions.checkNotNull((Object)osAccess);
        try {
            return (OSClient)((IOSClientBuilder.V2)((IOSClientBuilder.V2)OSFactory.builder().endpoint(osAccess.endpoint())).credentials(osAccess.user(), osAccess.password())).tenantName(osAccess.tenant()).authenticate();
        }
        catch (AuthenticationException e) {
            this.log.warn("Failed to authenticate OpenStack API with {}", (Object)osAccess);
            return null;
        }
    }
}

