/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.xosclient.impl;

import com.google.common.net.MediaType;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.onosproject.xosclient.api.XosAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XosApi {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected static final String EMPTY_STRING = "";
    protected static final String EMPTY_JSON_STRING = "{}";
    protected final String baseUrl;
    protected final XosAccess access;
    protected final Client client;
    private static final int DEFAULT_TIMEOUT_MS = 2000;

    public XosApi(String baseUrl, XosAccess xosAccess) {
        this.baseUrl = baseUrl;
        this.access = xosAccess;
        this.client = ClientBuilder.newClient();
        this.client.property("jersey.config.client.connectTimeout", (Object)2000);
        this.client.property("jersey.config.client.readTimeout", (Object)2000);
    }

    public XosAccess access() {
        return this.access;
    }

    public String baseUrl() {
        return this.baseUrl;
    }

    public String restGet(String path) {
        WebTarget wt = this.client.target(this.access.endpoint() + this.baseUrl).path(path);
        Invocation.Builder builder = wt.request(new String[]{MediaType.JSON_UTF_8.toString()});
        try {
            Response response = builder.get();
            if (response.getStatus() != 200) {
                this.log.warn("Failed to get resource {}", (Object)(this.access.endpoint() + this.baseUrl + path));
                return EMPTY_JSON_STRING;
            }
        }
        catch (ProcessingException e) {
            return EMPTY_JSON_STRING;
        }
        return (String)builder.get(String.class);
    }
}

