/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.xosclient.api;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onosproject.xosclient.api.VtnServiceApi;
import org.onosproject.xosclient.api.VtnServiceId;

public final class VtnService {
    private final VtnServiceId id;
    private final String name;
    private final VtnServiceApi.ServiceType serviceType;
    private final VtnServiceApi.NetworkType networkType;
    private final long vni;
    private final IpPrefix subnet;
    private final IpAddress serviceIp;
    private final Set<VtnServiceId> providerServices;
    private final Set<VtnServiceId> tenantServices;

    private VtnService(VtnServiceId id, String name, VtnServiceApi.ServiceType serviceType, VtnServiceApi.NetworkType networkType, long vni, IpPrefix subnet, IpAddress serviceIp, Set<VtnServiceId> providerServices, Set<VtnServiceId> tenantServices) {
        this.id = id;
        this.name = name;
        this.serviceType = serviceType;
        this.networkType = networkType;
        this.vni = vni;
        this.subnet = subnet;
        this.serviceIp = serviceIp;
        this.providerServices = providerServices;
        this.tenantServices = tenantServices;
    }

    public VtnServiceId id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public VtnServiceApi.ServiceType serviceType() {
        return this.serviceType;
    }

    public long vni() {
        return this.vni;
    }

    public VtnServiceApi.NetworkType networkType() {
        return this.networkType;
    }

    public IpPrefix subnet() {
        return this.subnet;
    }

    public IpAddress serviceIp() {
        return this.serviceIp;
    }

    public Set<VtnServiceId> providerServices() {
        return this.providerServices;
    }

    public Set<VtnServiceId> tenantServices() {
        return this.tenantServices;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VtnService)) {
            return false;
        }
        VtnService other = (VtnService)obj;
        return Objects.equals((Object)this.id, (Object)other.id);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("name", (Object)this.name).add("serviceType", (Object)this.serviceType).add("networkType", (Object)this.networkType).add("vni", this.vni).add("subnet", (Object)this.subnet).add("serviceIp", (Object)this.serviceIp).add("providerServices", this.providerServices).add("tenantServices", this.tenantServices).toString();
    }

    public static final Builder build() {
        return new Builder();
    }

    public static final class Builder {
        private VtnServiceId id;
        private String name;
        private VtnServiceApi.ServiceType serviceType;
        private VtnServiceApi.NetworkType networkType;
        private long vni = -1L;
        private IpPrefix subnet;
        private IpAddress serviceIp;
        private Set<VtnServiceId> providerServices;
        private Set<VtnServiceId> tenantServices;

        private Builder() {
        }

        public VtnService build() {
            Preconditions.checkNotNull((Object)((Object)this.id), (Object)"VTN service ID cannot be null");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.name) ? 1 : 0) != 0, (Object)"VTN service name cannot be null");
            Preconditions.checkNotNull((Object)((Object)this.serviceType), (Object)"VTN service type cannot be null");
            Preconditions.checkNotNull((Object)((Object)this.networkType), (Object)"VTN network type cannot be null");
            Preconditions.checkArgument((this.vni > 0L ? 1 : 0) != 0, (Object)"VTN network VNI is not set");
            Preconditions.checkNotNull((Object)this.subnet, (Object)"VTN subnet cannot be null");
            Preconditions.checkNotNull((Object)this.serviceIp, (Object)"VTN service IP cannot be null");
            this.providerServices = this.providerServices == null ? ImmutableSet.of() : this.providerServices;
            this.tenantServices = this.tenantServices == null ? ImmutableSet.of() : this.tenantServices;
            return new VtnService(this.id, this.name, this.serviceType, this.networkType, this.vni, this.subnet, this.serviceIp, this.providerServices, this.tenantServices);
        }

        public Builder id(VtnServiceId id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            if (Strings.isNullOrEmpty((String)name)) {
                String msg = "VTN service name cannot be null";
                throw new IllegalArgumentException("VTN service name cannot be null");
            }
            this.name = name;
            return this;
        }

        public Builder serviceType(VtnServiceApi.ServiceType serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        public Builder networkType(VtnServiceApi.NetworkType networkType) {
            this.networkType = networkType;
            return this;
        }

        public Builder vni(long vni) {
            if (vni < 0L || vni > 0xFFFFFFL) {
                String msg = "VNI " + vni + " is out of range";
                throw new IllegalArgumentException(msg);
            }
            this.vni = vni;
            return this;
        }

        public Builder vni(String vni) {
            try {
                return this.vni(Long.parseLong(vni));
            }
            catch (NullPointerException | NumberFormatException e) {
                String msg = "Malformed number string " + vni + " for VTN network VNI";
                throw new IllegalArgumentException(msg);
            }
        }

        public Builder subnet(IpPrefix subnet) {
            if (subnet == null) {
                String msg = "VTN service subnet is null";
                throw new IllegalArgumentException("VTN service subnet is null");
            }
            this.subnet = subnet;
            return this;
        }

        public Builder subnet(String subnet) {
            try {
                return this.subnet(IpPrefix.valueOf((String)subnet));
            }
            catch (IllegalArgumentException | NullPointerException e) {
                String msg = "Malformed IP prefix string " + subnet + " for VTN service subnet";
                throw new IllegalArgumentException(msg);
            }
        }

        public Builder serviceIp(IpAddress serviceIp) {
            if (serviceIp == null) {
                String msg = "VTN service IP cannot be null";
                throw new IllegalArgumentException("VTN service IP cannot be null");
            }
            this.serviceIp = serviceIp;
            return this;
        }

        public Builder serviceIp(String serviceIp) {
            try {
                return this.serviceIp(IpAddress.valueOf((String)serviceIp));
            }
            catch (IllegalArgumentException | NullPointerException e) {
                String msg = "Malformed IP address string " + serviceIp + " for VTN service IP address";
                throw new IllegalArgumentException(msg);
            }
        }

        public Builder providerServices(Set<VtnServiceId> pServices) {
            if (pServices == null) {
                String msg = "Provider services cannot be null";
                throw new IllegalArgumentException("Provider services cannot be null");
            }
            this.providerServices = pServices;
            return this;
        }

        public Builder tenantServices(Set<VtnServiceId> tServices) {
            if (tServices == null) {
                String msg = "Tenant services cannot be null";
                throw new IllegalArgumentException("Tenant services cannot be null");
            }
            this.tenantServices = tServices;
            return this;
        }
    }
}

