/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.xosclient.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Dictionary;
import java.util.Objects;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.basics.SubjectFactories;
import org.onosproject.xosclient.api.VtnPortApi;
import org.onosproject.xosclient.api.VtnServiceApi;
import org.onosproject.xosclient.api.XosAccess;
import org.onosproject.xosclient.api.XosAccessConfig;
import org.onosproject.xosclient.api.XosClientService;
import org.onosproject.xosclient.impl.DefaultVtnPortApi;
import org.onosproject.xosclient.impl.DefaultVtnServiceApi;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class XosClient
implements XosClientService {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String VTN_SERVICE_URL = "vtnServiceBaseUrl";
    private static final String DEFAULT_VTN_SERVICE_URL = "/api/service/vtn/services/";
    private static final String VTN_PORT_URL = "vtnPortBaseUrl";
    private static final String DEFAULT_VTN_PORT_URL = "/api/service/vtn/ports/";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService componentConfigService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigRegistry configRegistry;
    @Property(name="vtnServiceBaseUrl", value={"/api/service/vtn/services/"}, label="XOS VTN service API base url")
    private String vtnServiceUrl = "/api/service/vtn/services/";
    @Property(name="vtnPortBaseUrl", value={"/api/service/vtn/ports/"}, label="XOS VTN port API base url")
    private String vtnPortUrl = "/api/service/vtn/ports/";
    private final ConfigFactory configFactory = new ConfigFactory(SubjectFactories.APP_SUBJECT_FACTORY, XosAccessConfig.class, "xosclient"){

        public XosAccessConfig createConfig() {
            return new XosAccessConfig();
        }
    };
    private final NetworkConfigListener configListener = new InternalConfigListener();
    private ApplicationId appId;
    private XosAccess access = null;
    private VtnServiceApi vtnServiceApi = null;
    private VtnPortApi vtnPortApi = null;

    @Activate
    protected void activate(ComponentContext context) {
        this.appId = this.coreService.registerApplication("org.onosproject.xosclient");
        this.componentConfigService.registerProperties(this.getClass());
        this.modified(context);
        this.configRegistry.registerConfigFactory(this.configFactory);
        this.configRegistry.addListener((EventListener)this.configListener);
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.configRegistry.unregisterConfigFactory(this.configFactory);
        this.configRegistry.removeListener((EventListener)this.configListener);
        this.log.info("Stopped");
    }

    @Modified
    protected void modified(ComponentContext context) {
        Dictionary properties = context.getProperties();
        String updatedUrl = Tools.get((Dictionary)properties, (String)VTN_SERVICE_URL);
        if (!Strings.isNullOrEmpty((String)updatedUrl) && !updatedUrl.equals(this.vtnServiceUrl)) {
            this.vtnServiceUrl = updatedUrl;
            this.vtnServiceApi = new DefaultVtnServiceApi(this.vtnServiceUrl, this.access);
        }
        if (!Strings.isNullOrEmpty((String)(updatedUrl = Tools.get((Dictionary)properties, (String)VTN_PORT_URL))) && !updatedUrl.equals(this.vtnPortUrl)) {
            this.vtnPortUrl = updatedUrl;
            this.vtnPortApi = new DefaultVtnPortApi(this.vtnPortUrl, this.access);
        }
        this.log.info("Modified");
    }

    @Override
    public XosAccess access() {
        return this.access;
    }

    @Override
    public synchronized XosClient getClient(XosAccess access) {
        Preconditions.checkNotNull((Object)access);
        if (!Objects.equals(this.access, access)) {
            this.access = access;
            this.vtnServiceApi = new DefaultVtnServiceApi(this.vtnServiceUrl, access);
            this.vtnPortApi = new DefaultVtnPortApi(this.vtnPortUrl, access);
        }
        return this;
    }

    @Override
    public VtnServiceApi vtnService() {
        Preconditions.checkNotNull((Object)this.vtnServiceApi, (Object)"VtnServiceApi is null");
        return this.vtnServiceApi;
    }

    @Override
    public VtnPortApi vtnPort() {
        Preconditions.checkNotNull((Object)this.vtnPortApi, (Object)"VtnPortApi is null");
        return this.vtnPortApi;
    }

    private void readConfiguration() {
        XosAccessConfig config = (XosAccessConfig)this.configRegistry.getConfig((Object)this.appId, XosAccessConfig.class);
        if (config == null) {
            this.log.debug("No configuration found");
            return;
        }
        this.getClient(config.xosAccess());
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindComponentConfigService(ComponentConfigService componentConfigService) {
        this.componentConfigService = componentConfigService;
    }

    protected void unbindComponentConfigService(ComponentConfigService componentConfigService) {
        if (this.componentConfigService == componentConfigService) {
            this.componentConfigService = null;
        }
    }

    protected void bindConfigRegistry(NetworkConfigRegistry networkConfigRegistry) {
        this.configRegistry = networkConfigRegistry;
    }

    protected void unbindConfigRegistry(NetworkConfigRegistry networkConfigRegistry) {
        if (this.configRegistry == networkConfigRegistry) {
            this.configRegistry = null;
        }
    }

    private class InternalConfigListener
    implements NetworkConfigListener {
        private InternalConfigListener() {
        }

        public void event(NetworkConfigEvent event) {
            if (!event.configClass().equals(XosAccessConfig.class)) {
                return;
            }
            switch ((NetworkConfigEvent.Type)event.type()) {
                case CONFIG_ADDED: 
                case CONFIG_UPDATED: {
                    XosClient.this.log.info("Network configuration changed");
                    XosClient.this.readConfiguration();
                    break;
                }
            }
        }
    }
}

