/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yms.app.ydt;

import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.onosproject.yangutils.datamodel.YangSchemaNode;
import org.onosproject.yms.app.ydt.YdtConstants;
import org.onosproject.yms.app.ydt.YdtNode;
import org.onosproject.yms.app.ydt.exceptions.YdtException;
import org.onosproject.yms.ydt.YdtType;

class YdtMultiInstanceLeafNode
extends YdtNode {
    private static final String FMT_DUP_ENTRY = "Duplicate entry found under %s leaf-list node.";
    private final Set<String> valueSet = new LinkedHashSet<String>();

    YdtMultiInstanceLeafNode(YangSchemaNode node) {
        super(YdtType.MULTI_INSTANCE_LEAF_VALUE_NODE, node);
    }

    @Override
    public Set<String> getValueSet() {
        return ImmutableSet.copyOf(this.valueSet);
    }

    @Override
    public void addValue(String value) throws YdtException {
        this.addValueToValueSet(value);
    }

    private void addValueToValueSet(String value) throws YdtException {
        if (!this.valueSet.add(value)) {
            throw new YdtException(YdtConstants.errorMsg(FMT_DUP_ENTRY, this.getName()));
        }
    }

    public void addValueSet(Set valueSet) throws YdtException {
        for (Object aValueSet : valueSet) {
            String value = String.valueOf(aValueSet);
            this.addValueToValueSet(value);
        }
    }

    @Override
    public void addValueWithoutValidation(String value, boolean isKeyLeaf) {
        this.valueSet.add(value);
    }

    public void addValueSetWithoutValidation(Set valueSet) {
        this.valueSet.clear();
        this.valueSet.addAll(valueSet);
    }
}

