/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yms.app.ydt;

import org.onosproject.yangutils.datamodel.YangAugment;
import org.onosproject.yangutils.datamodel.YangNamespace;
import org.onosproject.yangutils.datamodel.YangSchemaNode;
import org.onosproject.yangutils.datamodel.YangSchemaNodeContextInfo;
import org.onosproject.yangutils.datamodel.YangSchemaNodeIdentifier;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yms.app.ydt.NameSpace;
import org.onosproject.yms.app.ydt.YdtAppNodeOperationType;
import org.onosproject.yms.app.ydt.YdtConstants;
import org.onosproject.yms.app.ydt.YdtLogicalNode;
import org.onosproject.yms.app.ydt.YdtNode;
import org.onosproject.yms.app.ydt.exceptions.YdtException;
import org.onosproject.yms.ydt.YdtContextOperationType;

final class YdtUtils {
    private static final String E_CREATE_OP = "Create request is not allowed under delete operation.";
    private static final String E_DELETE_OP = "Delete request is not allowed under create operation.";
    private static final String FMT_TOO_FEW = "Too few key parameters in %s. Expected %d; actual %d.";
    private static final String FMT_TOO_MANY = "Too many key parameters in %s. Expected %d; actual %d.";

    private YdtUtils() {
    }

    static YdtAppNodeOperationType getAppOpTypeFromYdtOpType(YdtContextOperationType opType) {
        switch (opType) {
            case CREATE: 
            case MERGE: 
            case REPLACE: {
                return YdtAppNodeOperationType.OTHER_EDIT;
            }
            case DELETE: 
            case REMOVE: {
                return YdtAppNodeOperationType.DELETE_ONLY;
            }
        }
        return null;
    }

    private static void validateOperationType(YdtContextOperationType parentOpType, YdtContextOperationType childOpType) throws YdtException {
        switch (parentOpType) {
            case CREATE: {
                if (childOpType != YdtContextOperationType.DELETE) break;
                throw new YdtException(E_CREATE_OP);
            }
            case DELETE: {
                if (childOpType != YdtContextOperationType.CREATE) break;
                throw new YdtException(E_DELETE_OP);
            }
        }
    }

    private static YdtContextOperationType getOperationType(YdtContextOperationType type, YdtContextOperationType defType) {
        return type != null ? type : (defType != null ? defType : YdtContextOperationType.MERGE);
    }

    static YangSchemaNodeIdentifier getNodeIdentifier(String name, String namespace) {
        YangSchemaNodeIdentifier id = new YangSchemaNodeIdentifier();
        id.setName(name);
        id.setNameSpace((YangNamespace)new NameSpace(namespace));
        return id;
    }

    static void checkElementCount(String name, int expected, int actual) throws YdtException {
        if (expected < actual) {
            throw new YdtException(YdtConstants.errorMsg(FMT_TOO_MANY, name, expected, actual));
        }
        if (expected > actual) {
            throw new YdtException(YdtConstants.errorMsg(FMT_TOO_FEW, name, expected, actual));
        }
    }

    static YdtContextOperationType getValidOpType(YdtContextOperationType opType, YdtContextOperationType defOpType, YdtNode newNode, YdtNode parentNode) throws YdtException {
        switch (newNode.getYdtType()) {
            case SINGLE_INSTANCE_NODE: 
            case MULTI_INSTANCE_NODE: {
                YdtContextOperationType parentOpType = parentNode.getYdtContextOperationType();
                if (opType == null) {
                    opType = YdtUtils.getOperationType(parentOpType, defOpType);
                } else if (parentOpType != null) {
                    YdtUtils.validateOperationType(parentOpType, opType);
                }
                return opType;
            }
        }
        return null;
    }

    public static YangSchemaNode getAugmentingSchemaNode(YangSchemaNodeIdentifier id, YangSchemaNodeContextInfo contextInfo) throws YdtException {
        YangSchemaNode lastAugMod = null;
        YangSchemaNode switchedNode = contextInfo.getContextSwitchedNode();
        while (switchedNode != null) {
            if (switchedNode instanceof YangAugment) {
                lastAugMod = switchedNode;
            }
            try {
                switchedNode = switchedNode.getChildSchema(id).getContextSwitchedNode();
            }
            catch (DataModelException e) {
                throw new YdtException(e.getMessage());
            }
        }
        return lastAugMod;
    }

    public static void freeRestResources(YdtNode rootNode) {
        YdtNode currentNode = rootNode;
        block0: while (currentNode != null) {
            YdtNode nextNode = currentNode.getFirstChild();
            if (nextNode != null) {
                currentNode = nextNode;
                continue;
            }
            while (currentNode != null) {
                YdtNode lastSibling = currentNode;
                nextNode = currentNode.getNextSibling();
                YdtUtils.free(lastSibling);
                lastSibling.getNamespace();
                if (nextNode != null) {
                    currentNode = nextNode;
                    continue block0;
                }
                if (currentNode.equals(rootNode)) {
                    currentNode = null;
                    continue;
                }
                currentNode = currentNode.getParent();
                lastSibling.setParent(null);
            }
        }
    }

    private static void free(YdtNode node) {
        if (node.getParent() != null) {
            YdtNode parent = node.getParent();
            parent.setChild(null);
            parent.setLastChild(null);
            if (node.getNextSibling() != null) {
                parent.setChild(node.getNextSibling());
            }
        }
        YdtNode parentRef = node.getParent();
        node = new YdtLogicalNode(null, null);
        node.setParent(parentRef);
    }
}

