/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yms.app.ynh;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.onlab.util.Tools;
import org.onosproject.event.Event;
import org.onosproject.event.EventListener;
import org.onosproject.event.ListenerRegistry;
import org.onosproject.event.ListenerService;
import org.onosproject.yms.app.ydt.YdtExtendedContext;
import org.onosproject.yms.app.ynh.YangNotificationExtendedService;
import org.onosproject.yms.app.ysr.YangSchemaRegistry;
import org.onosproject.yms.app.ytb.DefaultYangTreeBuilder;
import org.onosproject.yms.ydt.YdtContext;
import org.onosproject.yms.ynh.YangNotification;
import org.onosproject.yms.ynh.YangNotificationEvent;
import org.onosproject.yms.ynh.YangNotificationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YangNotificationManager
extends ListenerRegistry<YangNotificationEvent, YangNotificationListener>
implements YangNotificationExtendedService {
    private static final String YANG_NOTIFICATION = "yangnotification";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ExecutorService executor;
    private YnhAbstractListener listener = new YnhAbstractListener();
    private YangSchemaRegistry schemaRegistry;

    public YangNotificationManager(YangSchemaRegistry registry) {
        this.executor = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)"onos/yms", (String)"event-handler-%d", (Logger)this.log));
        this.schemaRegistry = registry;
    }

    @Override
    public void registerAsListener(ListenerService manager) {
        manager.addListener((EventListener)this.listener);
    }

    public YangNotification getFilteredSubject(YangNotification subject, YangNotification filter) {
        return null;
    }

    private class YnhAbstractListener<E extends Event>
    implements EventListener<E> {
        private YnhAbstractListener() {
        }

        public void event(Event event) {
            YangNotificationManager.this.executor.execute(() -> {
                try {
                    YangNotificationManager.this.log.info("Event received in ynh " + event.type());
                    DefaultYangTreeBuilder builder = new DefaultYangTreeBuilder();
                    YdtExtendedContext context = builder.getYdtForNotification(event, YangNotificationManager.YANG_NOTIFICATION, YangNotificationManager.this.schemaRegistry);
                    YangNotification notification = new YangNotification((YdtContext)context);
                    YangNotificationManager.this.process((Event)new YangNotificationEvent(notification));
                }
                catch (Exception e) {
                    YangNotificationManager.this.log.warn("Failed to process {}", (Object)event, (Object)e);
                }
            });
        }
    }
}

