/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yms.app.yob;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Base64;
import org.onosproject.yangutils.datamodel.RpcNotificationContainer;
import org.onosproject.yangutils.datamodel.YangDerivedInfo;
import org.onosproject.yangutils.datamodel.YangIdentity;
import org.onosproject.yangutils.datamodel.YangIdentityRef;
import org.onosproject.yangutils.datamodel.YangLeaf;
import org.onosproject.yangutils.datamodel.YangLeafList;
import org.onosproject.yangutils.datamodel.YangLeafRef;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangSchemaNode;
import org.onosproject.yangutils.datamodel.YangSchemaNodeContextInfo;
import org.onosproject.yangutils.datamodel.YangSchemaNodeType;
import org.onosproject.yangutils.datamodel.YangType;
import org.onosproject.yangutils.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yangutils.translator.tojava.utils.JavaIdentifierSyntax;
import org.onosproject.yms.app.ydt.AppType;
import org.onosproject.yms.app.ydt.YdtExtendedContext;
import org.onosproject.yms.app.yob.YobWorkBench;
import org.onosproject.yms.app.yob.exception.YobException;
import org.onosproject.yms.app.ysr.YangSchemaRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class YobUtils {
    private static final Logger log = LoggerFactory.getLogger(YobUtils.class);

    private YobUtils() {
    }

    static void setDataFromStringValue(YangDataTypes type, String leafValue, Method parentSetterMethod, Object parentBuilderObject, YdtExtendedContext ydtExtendedContext) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        switch (type) {
            case INT8: {
                parentSetterMethod.invoke(parentBuilderObject, Byte.parseByte(leafValue));
                break;
            }
            case UINT8: 
            case INT16: {
                parentSetterMethod.invoke(parentBuilderObject, Short.parseShort(leafValue));
                break;
            }
            case UINT16: 
            case INT32: {
                parentSetterMethod.invoke(parentBuilderObject, Integer.parseInt(leafValue));
                break;
            }
            case UINT32: 
            case INT64: {
                parentSetterMethod.invoke(parentBuilderObject, Long.parseLong(leafValue));
                break;
            }
            case UINT64: {
                parentSetterMethod.invoke(parentBuilderObject, new BigInteger(leafValue));
                break;
            }
            case EMPTY: {
                if (leafValue == null || leafValue.equals("")) {
                    parentSetterMethod.invoke(parentBuilderObject, true);
                    break;
                }
                log.info("Value for empty data type is invalid");
                break;
            }
            case BOOLEAN: {
                parentSetterMethod.invoke(parentBuilderObject, Boolean.parseBoolean(leafValue));
                break;
            }
            case STRING: {
                parentSetterMethod.invoke(parentBuilderObject, leafValue);
                break;
            }
            case BINARY: {
                byte[] value = Base64.getDecoder().decode(leafValue);
                parentSetterMethod.invoke(parentBuilderObject, new Object[]{value});
                break;
            }
            case BITS: {
                YobUtils.parseBitSetTypeInfo(ydtExtendedContext, parentSetterMethod, parentBuilderObject, leafValue);
                break;
            }
            case DECIMAL64: {
                parentSetterMethod.invoke(parentBuilderObject, new BigDecimal(leafValue));
                break;
            }
            case DERIVED: {
                YobUtils.parseDerivedTypeInfo(ydtExtendedContext, parentSetterMethod, parentBuilderObject, leafValue, false);
                break;
            }
            case IDENTITYREF: {
                YobUtils.parseIdentityRefInfo(ydtExtendedContext, parentSetterMethod, parentBuilderObject, leafValue);
                break;
            }
            case UNION: {
                YobUtils.parseDerivedTypeInfo(ydtExtendedContext, parentSetterMethod, parentBuilderObject, leafValue, false);
                break;
            }
            case LEAFREF: {
                YobUtils.parseLeafRefTypeInfo(ydtExtendedContext, parentSetterMethod, parentBuilderObject, leafValue);
                break;
            }
            case ENUMERATION: {
                YobUtils.parseDerivedTypeInfo(ydtExtendedContext, parentSetterMethod, parentBuilderObject, leafValue, true);
                break;
            }
            default: {
                log.error("Given data type is not supported.");
            }
        }
    }

    static void setSelectLeaf(Class builderClass, YdtExtendedContext leafNode, YangSchemaRegistry schemaRegistry, Object builderObject) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?>[] innerClasses;
        YangSchemaNode parentSchema = ((YdtExtendedContext)leafNode.getParent()).getYangSchemaNode();
        while (parentSchema.getReferredSchema() != null) {
            parentSchema = parentSchema.getReferredSchema();
        }
        while (((YangNode)parentSchema).getParent() != null) {
            parentSchema = ((YangNode)parentSchema).getParent();
        }
        String qualName = YobUtils.getQualifiedinterface(parentSchema);
        Class<?> regClass = schemaRegistry.getRegisteredClass(parentSchema);
        if (regClass == null) {
            throw new YobException("Failed to load class for class: " + qualName);
        }
        Class<?> interfaceClass = null;
        try {
            interfaceClass = regClass.getClassLoader().loadClass(qualName);
        }
        catch (ClassNotFoundException e) {
            log.info("Failed to load class for class: ", (Object)qualName);
        }
        for (Class<?> innerEnumClass : innerClasses = interfaceClass.getClasses()) {
            if (!innerEnumClass.getSimpleName().equals("LeafIdentifier")) continue;
            Method valueOfMethod = innerEnumClass.getDeclaredMethod("valueOf", String.class);
            String leafName = leafNode.getYangSchemaNode().getJavaAttributeName().toUpperCase();
            Object obj = valueOfMethod.invoke(null, leafName);
            Method selectLeafMethod = builderClass.getDeclaredMethod("selectLeaf", innerEnumClass);
            selectLeafMethod.invoke(builderObject, obj);
            break;
        }
    }

    private static void parseDerivedTypeInfo(YdtExtendedContext ydtExtendedContext, Method parentSetterMethod, Object parentBuilderObject, String leafValue, boolean isEnum) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Class<?> childSetClass = null;
        Constructor<?> childConstructor = null;
        Object childValue = null;
        Object childObject = null;
        Method childMethod = null;
        YangSchemaNode yangJavaModule = ydtExtendedContext.getYangSchemaNode();
        while (yangJavaModule.getReferredSchema() != null) {
            yangJavaModule = yangJavaModule.getReferredSchema();
        }
        String qualifiedClassName = yangJavaModule.getJavaPackage() + "." + YobUtils.getCapitalCase(yangJavaModule.getJavaClassNameOrBuiltInType());
        ClassLoader classLoader = YobUtils.getClassLoader(null, qualifiedClassName, ydtExtendedContext, null);
        try {
            childSetClass = classLoader.loadClass(qualifiedClassName);
        }
        catch (ClassNotFoundException e) {
            log.error("Failed to load class for class: {}", (Object)qualifiedClassName);
        }
        if (!isEnum) {
            if (childSetClass != null) {
                childConstructor = childSetClass.getDeclaredConstructor(new Class[0]);
            }
            if (childConstructor != null) {
                childConstructor.setAccessible(true);
            }
            try {
                if (childConstructor != null) {
                    childObject = childConstructor.newInstance(new Object[0]);
                }
            }
            catch (InstantiationException e) {
                log.error("Failed to load constructor for class: {}", (Object)qualifiedClassName);
            }
            if (childSetClass != null) {
                childMethod = childSetClass.getDeclaredMethod("fromString", String.class);
            }
        } else if (childSetClass != null) {
            childMethod = childSetClass.getDeclaredMethod("of", String.class);
        }
        if (childMethod != null) {
            childValue = childMethod.invoke(childObject, leafValue);
        }
        parentSetterMethod.invoke(parentBuilderObject, childValue);
    }

    private static void parseBitSetTypeInfo(YdtExtendedContext ydtExtendedContext, Method parentSetterMethod, Object parentBuilderObject, String leafValue) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Class<?> childSetClass = null;
        Object childValue = null;
        Object childObject = null;
        Method childMethod = null;
        YangSchemaNode schemaNode = ydtExtendedContext.getYangSchemaNode();
        while (schemaNode.getReferredSchema() != null) {
            schemaNode = schemaNode.getReferredSchema();
        }
        YangSchemaNode parentSchema = ((YdtExtendedContext)ydtExtendedContext.getParent()).getYangSchemaNode();
        String qualifiedClassName = parentSchema.getJavaPackage() + "." + parentSchema.getJavaAttributeName().toLowerCase() + "." + YobUtils.getCapitalCase(schemaNode.getJavaAttributeName());
        ClassLoader classLoader = YobUtils.getClassLoader(null, qualifiedClassName, ydtExtendedContext, null);
        try {
            childSetClass = classLoader.loadClass(qualifiedClassName);
        }
        catch (ClassNotFoundException e) {
            log.error("Failed to load class for class: {}", (Object)qualifiedClassName);
        }
        if (childSetClass != null) {
            childMethod = childSetClass.getDeclaredMethod("fromString", String.class);
        }
        if (childMethod != null) {
            childValue = childMethod.invoke(childObject, leafValue);
        }
        parentSetterMethod.invoke(parentBuilderObject, childValue);
    }

    private static void parseLeafRefTypeInfo(YdtExtendedContext ydtExtendedContext, Method parentSetterMethod, Object parentBuilderObject, String leafValue) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        YangSchemaNode schemaNode = ydtExtendedContext.getYangSchemaNode();
        while (schemaNode.getReferredSchema() != null) {
            schemaNode = schemaNode.getReferredSchema();
        }
        YangLeafRef leafRef = schemaNode instanceof YangLeaf ? (YangLeafRef)((YangLeaf)schemaNode).getDataType().getDataTypeExtendedInfo() : (YangLeafRef)((YangLeafList)schemaNode).getDataType().getDataTypeExtendedInfo();
        YangType type = leafRef.getEffectiveDataType();
        if (type.getDataType() == YangDataTypes.DERIVED && schemaNode.getJavaPackage().equals("java.lang")) {
            YangDerivedInfo derivedInfo = (YangDerivedInfo)leafRef.getEffectiveDataType().getDataTypeExtendedInfo();
            YobUtils.setDataFromStringValue(derivedInfo.getEffectiveBuiltInType(), leafValue, parentSetterMethod, parentBuilderObject, ydtExtendedContext);
        } else {
            YobUtils.setDataFromStringValue(type.getDataType(), leafValue, parentSetterMethod, parentBuilderObject, ydtExtendedContext);
        }
    }

    static ClassLoader getClassLoader(YangSchemaRegistry registry, String qualifiedClassName, YdtExtendedContext curNode, YdtExtendedContext rootNode) {
        if (rootNode != null && curNode == rootNode) {
            YangSchemaNode curSchemaNode = curNode.getYangSchemaNode();
            while (!(curSchemaNode instanceof RpcNotificationContainer)) {
                if ((curNode = (YdtExtendedContext)curNode.getParent()) == null) {
                    throw new YobException("YANG tree does not have a application root");
                }
                curSchemaNode = curNode.getYangSchemaNode();
            }
            Class<?> regClass = registry.getRegisteredClass(curSchemaNode);
            return regClass.getClassLoader();
        }
        YdtExtendedContext parent = (YdtExtendedContext)curNode.getParent();
        YobWorkBench parentBuilderContainer = (YobWorkBench)parent.getAppInfo(AppType.YOB);
        Object parentObj = parentBuilderContainer.getParentBuilder(curNode, registry);
        return parentObj.getClass().getClassLoader();
    }

    static ClassLoader getTargetClassLoader(ClassLoader curLoader, YangSchemaNodeContextInfo context, YangSchemaRegistry registry) {
        YangSchemaNode augmentSchemaNode = context.getContextSwitchedNode();
        if (augmentSchemaNode.getYangSchemaNodeType() == YangSchemaNodeType.YANG_AUGMENT_NODE) {
            YangNode moduleNode = ((YangNode)augmentSchemaNode).getParent();
            Class<?> moduleClass = registry.getRegisteredClass((YangSchemaNode)moduleNode);
            if (moduleClass == null) {
                throw new YobException("Failed to load class for class: " + moduleNode.getJavaClassNameOrBuiltInType());
            }
            return moduleClass.getClassLoader();
        }
        return curLoader;
    }

    public static Class<?> getModuleInterface(YangSchemaNode schemaNode, YangSchemaRegistry schemaRegistry) {
        YangNode yangNode = (YangNode)schemaNode;
        while (yangNode.getReferredSchema() != null) {
            yangNode = (YangNode)yangNode.getReferredSchema();
        }
        while (yangNode.getParent() != null) {
            yangNode = yangNode.getParent();
        }
        String qualName = YobUtils.getQualifiedinterface((YangSchemaNode)yangNode);
        Class<?> regClass = schemaRegistry.getRegisteredClass((YangSchemaNode)yangNode);
        if (regClass == null) {
            throw new YobException("Failed to load class for class: " + qualName);
        }
        try {
            return regClass.getClassLoader().loadClass(qualName);
        }
        catch (ClassNotFoundException e) {
            log.error("Failed to load class for class: {}", (Object)qualName);
            return null;
        }
    }

    static String getQualifiedDefaultClass(YangSchemaNode schemaNode) {
        String packageName = schemaNode.getJavaPackage();
        String className = YobUtils.getCapitalCase(schemaNode.getJavaClassNameOrBuiltInType());
        if (schemaNode instanceof RpcNotificationContainer) {
            return packageName + "." + className + "OpParam";
        }
        return packageName + "." + "Default" + className;
    }

    static String getQualifiedinterface(YangSchemaNode schemaNode) {
        String packageName = schemaNode.getJavaPackage();
        String className = YobUtils.getCapitalCase(schemaNode.getJavaClassNameOrBuiltInType());
        return packageName + "." + className;
    }

    public static String getCapitalCase(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private static void parseIdentityRefInfo(YdtExtendedContext ydtExtendedContext, Method parentSetterMethod, Object parentBuilderObject, String leafValue) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Class<?> childSetClass = null;
        Object childValue = null;
        Method childMethod = null;
        YangSchemaNode yangJavaModule = ydtExtendedContext.getYangSchemaNode();
        while (yangJavaModule.getReferredSchema() != null) {
            yangJavaModule = yangJavaModule.getReferredSchema();
        }
        String qualifiedClassName = null;
        YangType type = yangJavaModule instanceof YangLeaf ? ((YangLeaf)yangJavaModule).getDataType() : ((YangLeafList)yangJavaModule).getDataType();
        if (type.getDataType() == YangDataTypes.LEAFREF && yangJavaModule.getJavaPackage().equals("java.lang")) {
            YangLeafRef leafref = (YangLeafRef)type.getDataTypeExtendedInfo();
            YangType effectiveType = leafref.getEffectiveDataType();
            if (effectiveType.getDataType() == YangDataTypes.IDENTITYREF) {
                YangIdentityRef identityref = (YangIdentityRef)effectiveType.getDataTypeExtendedInfo();
                YangIdentity identity = identityref.getReferredIdentity();
                qualifiedClassName = identity.getJavaPackage() + "." + YobUtils.getCapitalCase(identity.getJavaClassNameOrBuiltInType());
            }
        } else {
            qualifiedClassName = yangJavaModule.getJavaPackage() + "." + YobUtils.getCapitalCase(yangJavaModule.getJavaClassNameOrBuiltInType());
        }
        ClassLoader classLoader = YobUtils.getClassLoader(null, qualifiedClassName, ydtExtendedContext, null);
        try {
            childSetClass = classLoader.loadClass(qualifiedClassName);
        }
        catch (ClassNotFoundException e) {
            log.error("Failed to load class for class: {}", (Object)qualifiedClassName);
        }
        if (childSetClass != null) {
            childMethod = childSetClass.getDeclaredMethod("fromString", String.class);
        }
        if (childMethod != null) {
            childValue = childMethod.invoke(null, leafValue);
        }
        parentSetterMethod.invoke(parentBuilderObject, childValue);
    }

    public static Object createAndSetInEventSubjectInstance(Object defaultObj, YdtExtendedContext curNode, YangSchemaRegistry registry) {
        Object eventSubObj;
        YangSchemaNode childSchema = ((YdtExtendedContext)curNode.getFirstChild()).getYangSchemaNode();
        String packageName = childSchema.getJavaPackage();
        String className = YobUtils.getCapitalCase(curNode.getYangSchemaNode().getJavaClassNameOrBuiltInType());
        String qualName = packageName + "." + className + "EventSubject";
        ClassLoader classLoader = YobUtils.getClassLoader(registry, qualName, curNode, curNode);
        Class<?> eventSubjectClass = null;
        try {
            eventSubjectClass = classLoader.loadClass(qualName);
            eventSubObj = eventSubjectClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            log.error("Failed to load class for class: ", (Object)className);
            throw new YobException("Failed to load class for class: " + eventSubjectClass.getName());
        }
        catch (InstantiationException e) {
            log.error("Failed to create an object for class: ", (Object)className);
            throw new YobException("Failed to create an object for class: " + eventSubjectClass.getName());
        }
        catch (IllegalAccessException e) {
            log.error("Failed to invoke method for class: {}", (Object)className);
            throw new YobException("Failed to invoke method for class: " + eventSubjectClass.getName());
        }
        YobUtils.setInEventSubject((YdtExtendedContext)curNode.getFirstChild(), eventSubObj, defaultObj);
        return eventSubObj;
    }

    public static void setInEventSubject(YdtExtendedContext ydtNode, Object eventSubObj, Object defaultObj) {
        Class<?> eventSubjectClass = eventSubObj.getClass();
        String className = eventSubjectClass.getName();
        String setter = ydtNode.getYangSchemaNode().getJavaAttributeName();
        try {
            Class<?> type = null;
            Field fieldName = eventSubjectClass.getDeclaredField(setter);
            if (fieldName != null) {
                type = fieldName.getType();
            }
            Method method = eventSubjectClass.getDeclaredMethod(setter, type);
            method.invoke(eventSubObj, defaultObj);
        }
        catch (NoSuchFieldException e) {
            log.error("Failed to get field for class: {}", (Object)className);
            throw new YobException("Failed to get field for class: " + className);
        }
        catch (NoSuchMethodException e) {
            log.error("Failed to get method for class: {}", (Object)className);
            throw new YobException("Failed to get method for class: " + className);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("Failed to invoke method for class: {}", (Object)className);
            throw new YobException("Failed to invoke method for class: " + className);
        }
    }

    public static Object createAndSetInEventInstance(Object eventSubObj, YdtExtendedContext curNode, YangSchemaRegistry registry) {
        YangSchemaNode childSchema = ((YdtExtendedContext)curNode.getFirstChild()).getYangSchemaNode();
        String packageName = childSchema.getJavaPackage();
        String className = YobUtils.getCapitalCase(curNode.getYangSchemaNode().getJavaClassNameOrBuiltInType());
        String qualName = packageName + "." + className + "Event";
        try {
            ClassLoader classLoader = YobUtils.getClassLoader(registry, qualName, curNode, curNode);
            Class<?> eventClass = classLoader.loadClass(qualName);
            Class<?>[] innerClasses = eventClass.getClasses();
            Object typeObj = null;
            for (Class<?> innerEnumClass : innerClasses) {
                if (!innerEnumClass.getSimpleName().equals("Type")) continue;
                Method valueOfMethod = innerEnumClass.getDeclaredMethod("valueOf", String.class);
                String eventType = JavaIdentifierSyntax.getEnumJavaAttribute((String)childSchema.getName()).toUpperCase();
                typeObj = valueOfMethod.invoke(null, eventType);
                break;
            }
            Constructor<?> constructor = eventClass.getDeclaredConstructor(typeObj.getClass(), eventSubObj.getClass());
            constructor.setAccessible(true);
            return constructor.newInstance(typeObj, eventSubObj);
        }
        catch (ClassNotFoundException e) {
            log.error("Failed to invoke method for class: {}", (Object)className);
            throw new YobException("Failed to invoke method for class: " + className);
        }
        catch (InstantiationException e) {
            log.error("Failed to create an object for class: ", (Object)className);
            throw new YobException("Failed to create an object for class: " + className);
        }
        catch (NoSuchMethodException e) {
            log.error("Failed to get method for class: {}", (Object)className);
            throw new YobException("Failed to get method for class: " + className);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("Failed to invoke method for class: {}", (Object)className);
            throw new YobException("Failed to invoke method for class: " + className);
        }
    }
}

