/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yms.app.ytb;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.onosproject.yangutils.datamodel.YangAugment;
import org.onosproject.yangutils.datamodel.YangAugmentableNode;
import org.onosproject.yangutils.datamodel.YangCase;
import org.onosproject.yangutils.datamodel.YangChoice;
import org.onosproject.yangutils.datamodel.YangDerivedInfo;
import org.onosproject.yangutils.datamodel.YangLeaf;
import org.onosproject.yangutils.datamodel.YangLeafList;
import org.onosproject.yangutils.datamodel.YangLeafRef;
import org.onosproject.yangutils.datamodel.YangLeavesHolder;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangSchemaNode;
import org.onosproject.yangutils.datamodel.YangSchemaNodeIdentifier;
import org.onosproject.yangutils.datamodel.YangType;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yangutils.utils.io.impl.YangIoUtils;
import org.onosproject.yms.app.utils.TraversalType;
import org.onosproject.yms.app.ydt.AppType;
import org.onosproject.yms.app.ydt.YdtExtendedBuilder;
import org.onosproject.yms.app.ydt.YdtExtendedContext;
import org.onosproject.yms.app.ysr.YangSchemaRegistry;
import org.onosproject.yms.app.ytb.YtbException;
import org.onosproject.yms.app.ytb.YtbNodeInfo;
import org.onosproject.yms.app.ytb.YtbTraversalInfo;
import org.onosproject.yms.app.ytb.YtbUtil;
import org.onosproject.yms.ydt.YdtContextOperationType;

public class YdtBuilderFromYo {
    private static final String STR_TYPE = "type";
    private static final String STR_SUBJECT = "subject";
    private static final String TRUE = "true";
    private static final String IS_LEAF_VALUE_SET_METHOD = "isLeafValueSet";
    private static final String IS_SELECT_LEAF_SET_METHOD = "isSelectLeaf";
    private static final String OUTPUT = "output";
    private static final String YANG_AUGMENTED_INFO_MAP = "yangAugmentedInfoMap";
    private static final String FALSE = "false";
    private final YangSchemaRegistry registry;
    private final YdtExtendedBuilder extBuilder;
    private Object rootObj;
    private YangSchemaNode rootSchema;

    public YdtBuilderFromYo(YdtExtendedBuilder rootBuilder, Object rootObj, YangSchemaRegistry registry) {
        this.extBuilder = rootBuilder;
        this.rootObj = rootObj;
        this.registry = registry;
    }

    public void getModuleNodeFromYsr(Object object) {
        Class<?> interfaceClass = YtbUtil.getInterfaceClassFromImplClass(object);
        this.rootSchema = this.registry.getYangSchemaNodeUsingGeneratedRootNodeInterfaceFileName(interfaceClass.getName());
    }

    public void getRootNodeWithNotificationFromYsr(Object object) {
        this.rootSchema = this.registry.getRootYangSchemaNodeForNotification(object.getClass().getName());
    }

    public void createModuleInYdt() {
        this.extBuilder.addChild(YdtContextOperationType.NONE, this.rootSchema);
        this.rootSchema = this.getSchemaNodeOfNotification();
        this.rootObj = this.getObjOfNotification();
    }

    public void createModuleAndRpcInYdt(YdtExtendedContext rootNode) {
        YdtExtendedContext moduleNode = (YdtExtendedContext)rootNode.getFirstChild();
        this.extBuilder.addChild(YdtContextOperationType.NONE, moduleNode.getYangSchemaNode());
        YdtExtendedContext rpcNode = (YdtExtendedContext)moduleNode.getFirstChild();
        YangSchemaNode rpcSchemaNode = rpcNode.getYangSchemaNode();
        this.extBuilder.addChild(YdtContextOperationType.NONE, rpcSchemaNode);
        YangSchemaNodeIdentifier schemaId = new YangSchemaNodeIdentifier();
        schemaId.setName(OUTPUT);
        schemaId.setNameSpace(rpcSchemaNode.getNameSpace());
        try {
            this.rootSchema = rpcSchemaNode.getChildSchema(schemaId).getSchemaNode();
        }
        catch (DataModelException e) {
            throw new YtbException(e);
        }
    }

    public void createYdtFromRootObject() {
        YangNode curNode = (YangNode)this.rootSchema;
        TraversalType curTraversal = TraversalType.ROOT;
        YtbNodeInfo listNodeInfo = null;
        YtbNodeInfo augmentNodeInfo = null;
        while (curNode != null) {
            YtbTraversalInfo traverseInfo;
            YangNode augmentNode;
            if (curTraversal != TraversalType.PARENT || YtbUtil.isMultiInstanceNode(curNode)) {
                if (curTraversal == TraversalType.PARENT && YtbUtil.isMultiInstanceNode(curNode)) {
                    listNodeInfo = this.getCurNodeInfoAndTraverseBack();
                }
                if (curTraversal == TraversalType.ROOT && !YtbUtil.isAugmentNode(curNode)) {
                    this.processApplicationRootNode();
                } else {
                    Object processedObject = this.processCurSchemaNodeAndAddToYdt(curNode, listNodeInfo);
                    listNodeInfo = null;
                    if (processedObject == null && !YtbUtil.isAugmentNode(curNode)) {
                        YtbTraversalInfo traverseInfo2 = this.getProcessableInfo(curNode);
                        curNode = traverseInfo2.getYangNode();
                        curTraversal = traverseInfo2.getTraverseType();
                        continue;
                    }
                    if (processedObject == null && YtbUtil.isAugmentNode(curNode)) {
                        curTraversal = TraversalType.PARENT;
                    } else if (curTraversal == TraversalType.PARENT && YtbUtil.isMultiInstanceNode(curNode)) {
                        curTraversal = TraversalType.CHILD;
                    }
                }
            }
            if (curTraversal == TraversalType.PARENT && YtbUtil.isAugmentNode(curNode)) {
                curNode = ((YangAugment)curNode).getAugmentedNode();
                augmentNodeInfo = this.getParentYtbInfo();
                curTraversal = TraversalType.CHILD;
            }
            if (curTraversal != TraversalType.PARENT && curNode instanceof YangAugmentableNode && (augmentNode = this.getAugmentInsideSchemaNode(curNode, augmentNodeInfo)) != null) {
                curNode = augmentNode;
                continue;
            }
            if (curTraversal != TraversalType.PARENT && curNode.getChild() != null) {
                augmentNodeInfo = null;
                listNodeInfo = null;
                curTraversal = TraversalType.CHILD;
                if (!YtbUtil.isNonProcessableNode(curNode = curNode.getChild())) continue;
                traverseInfo = this.getProcessableInfo(curNode);
                curNode = traverseInfo.getYangNode();
                curTraversal = traverseInfo.getTraverseType();
                continue;
            }
            if (curNode.getNextSibling() != null) {
                if (YtbUtil.isNodeProcessCompleted(curNode, curTraversal)) break;
                if (YtbUtil.isMultiInstanceNode(curNode)) {
                    listNodeInfo = this.getCurNodeInfoAndTraverseBack();
                    augmentNodeInfo = null;
                    continue;
                }
                curTraversal = TraversalType.SIBLING;
                augmentNodeInfo = null;
                this.traverseToParent(curNode);
                if (!YtbUtil.isNonProcessableNode(curNode = curNode.getNextSibling())) continue;
                traverseInfo = this.getProcessableInfo(curNode);
                curNode = traverseInfo.getYangNode();
                curTraversal = traverseInfo.getTraverseType();
                continue;
            }
            if (YtbUtil.isNodeProcessCompleted(curNode, curTraversal)) break;
            if (YtbUtil.isMultiInstanceNode(curNode)) {
                listNodeInfo = this.getCurNodeInfoAndTraverseBack();
                augmentNodeInfo = null;
                continue;
            }
            curTraversal = TraversalType.PARENT;
            this.traverseToParent(curNode);
            curNode = curNode.getParent();
        }
    }

    private void processApplicationRootNode() {
        YtbNodeInfo nodeInfo = new YtbNodeInfo();
        YangNode rootYang = (YangNode)this.rootSchema;
        this.addChildNodeInYdt(this.rootObj, rootYang, nodeInfo);
        this.processLeaves(rootYang);
        this.processLeavesList(rootYang);
    }

    private void traverseToParent(YangNode curNode) {
        if (curNode instanceof YangCase || curNode instanceof YangChoice) {
            return;
        }
        this.extBuilder.traverseToParentWithoutValidation();
    }

    private YtbNodeInfo getCurNodeInfoAndTraverseBack() {
        YtbNodeInfo appInfo = this.getParentYtbInfo();
        this.extBuilder.traverseToParentWithoutValidation();
        return appInfo;
    }

    private YangNode getAugmentInsideSchemaNode(YangNode curNode, YtbNodeInfo augmentNodeInfo) {
        if (augmentNodeInfo == null) {
            List augmentList = ((YangAugmentableNode)curNode).getAugmentedInfoList();
            if (YtbUtil.nonEmpty(augmentList)) {
                YtbNodeInfo parentNodeInfo = this.getParentYtbInfo();
                ListIterator<YangAugment> augmentItr = augmentList.listIterator();
                parentNodeInfo.setAugmentIterator(augmentItr);
                return (YangNode)augmentItr.next();
            }
        } else if (augmentNodeInfo.getAugmentIterator() != null && augmentNodeInfo.getAugmentIterator().hasNext()) {
            return (YangNode)augmentNodeInfo.getAugmentIterator().next();
        }
        return null;
    }

    private Object processCurSchemaNodeAndAddToYdt(YangNode curNode, YtbNodeInfo listNodeInfo) {
        YtbNodeInfo curNodeInfo = new YtbNodeInfo();
        Object nodeObj = null;
        YtbNodeInfo parentNodeInfo = this.getParentYtbInfo();
        switch (curNode.getYangSchemaNodeType()) {
            case YANG_SINGLE_INSTANCE_NODE: {
                nodeObj = this.processSingleInstanceNode(curNode, curNodeInfo, parentNodeInfo);
                break;
            }
            case YANG_MULTI_INSTANCE_NODE: {
                nodeObj = this.processMultiInstanceNode(curNode, curNodeInfo, listNodeInfo, parentNodeInfo);
                break;
            }
            case YANG_CHOICE_NODE: {
                nodeObj = this.processChoiceNode(curNode, parentNodeInfo);
                break;
            }
            case YANG_NON_DATA_NODE: {
                if (!(curNode instanceof YangCase)) break;
                nodeObj = this.processCaseNode(curNode, parentNodeInfo);
                break;
            }
            case YANG_AUGMENT_NODE: {
                nodeObj = this.processAugmentNode(curNode, parentNodeInfo);
                break;
            }
            default: {
                throw new YtbException("Non processable schema node has arrived for adding it in YDT tree");
            }
        }
        if (nodeObj != null) {
            this.processLeaves(curNode);
            this.processLeavesList(curNode);
        }
        return nodeObj;
    }

    private Object processSingleInstanceNode(YangNode curNode, YtbNodeInfo curNodeInfo, YtbNodeInfo parentNodeInfo) {
        Object childObj = this.getChildObject(curNode, parentNodeInfo);
        if (childObj != null) {
            this.addChildNodeInYdt(childObj, curNode, curNodeInfo);
        }
        return childObj;
    }

    private Object processMultiInstanceNode(YangNode curNode, YtbNodeInfo curNodeInfo, YtbNodeInfo listNodeInfo, YtbNodeInfo parentNodeInfo) {
        Object childObj = null;
        if (listNodeInfo == null) {
            List childObjList = (List)this.getChildObject(curNode, parentNodeInfo);
            if (YtbUtil.nonEmpty(childObjList)) {
                Iterator<Object> listItr = childObjList.iterator();
                if (!listItr.hasNext()) {
                    return null;
                }
                childObj = listItr.next();
                curNodeInfo.setListIterator(listItr);
            }
        } else {
            curNodeInfo.setListIterator(listNodeInfo.getListIterator());
            if (listNodeInfo.getListIterator().hasNext()) {
                childObj = listNodeInfo.getListIterator().next();
            }
        }
        if (childObj != null) {
            this.addChildNodeInYdt(childObj, curNode, curNodeInfo);
        }
        return childObj;
    }

    private Object processChoiceNode(YangNode curNode, YtbNodeInfo parentNodeInfo) {
        Object childObj = this.getChildObject(curNode, parentNodeInfo);
        if (childObj != null) {
            Map<String, Object> choiceCaseMap = parentNodeInfo.getChoiceCaseMap();
            if (choiceCaseMap == null) {
                choiceCaseMap = new HashMap<String, Object>();
                parentNodeInfo.setChoiceCaseMap(choiceCaseMap);
            }
            choiceCaseMap.put(curNode.getName(), childObj);
        }
        return childObj;
    }

    private Object processCaseNode(YangNode curNode, YtbNodeInfo parentNodeInfo) {
        Object childObj = null;
        if (parentNodeInfo.getChoiceCaseMap() != null) {
            childObj = this.getCaseObjectFromChoice(parentNodeInfo, (YangSchemaNode)curNode);
        }
        if (childObj != null) {
            parentNodeInfo.setCaseObject(childObj);
        }
        return childObj;
    }

    private Object processAugmentNode(YangNode curNode, YtbNodeInfo parentNodeInfo) {
        String className = curNode.getJavaClassNameOrBuiltInType();
        String pkgName = curNode.getJavaPackage();
        Object parentObj = YtbUtil.getParentObjectOfNode(parentNodeInfo, curNode.getParent());
        try {
            Map augmentMap = (Map)YtbUtil.getAttributeOfObject(parentObj, YANG_AUGMENTED_INFO_MAP);
            Class<?> moduleClass = YtbUtil.getClassLoaderForAugment(curNode, this.registry);
            if (moduleClass == null) {
                return null;
            }
            Class<?> augmentClass = moduleClass.getClassLoader().loadClass(pkgName + "." + className);
            Object childObj = augmentMap.get(augmentClass);
            parentNodeInfo.setAugmentObject(childObj);
            return childObj;
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new YtbException(e);
        }
    }

    private YtbNodeInfo getParentYtbInfo() {
        YdtExtendedContext parentExtContext = this.extBuilder.getCurNode();
        return (YtbNodeInfo)parentExtContext.getAppInfo(AppType.YTB);
    }

    private Object getChildObject(YangNode curNode, YtbNodeInfo parentNodeInfo) {
        String nodeJavaName = curNode.getJavaAttributeName();
        Object parentObj = YtbUtil.getParentObjectOfNode(parentNodeInfo, curNode.getParent());
        try {
            return YtbUtil.getAttributeOfObject(parentObj, nodeJavaName);
        }
        catch (NoSuchMethodException e) {
            throw new YtbException(e);
        }
    }

    private void addChildNodeInYdt(Object childObj, YangNode curNode, YtbNodeInfo curNodeInfo) {
        YdtContextOperationType opType = YtbUtil.getNodeOpType(childObj, YtbUtil.getOpTypeName(curNode));
        this.extBuilder.addChild(opType, (YangSchemaNode)curNode);
        YdtExtendedContext curExtContext = this.extBuilder.getCurNode();
        curNodeInfo.setYangObject(childObj);
        curExtContext.addAppInfo(AppType.YTB, curNodeInfo);
    }

    private void processLeaves(YangNode yangNode) {
        List leavesList;
        if (yangNode instanceof YangLeavesHolder && (leavesList = ((YangLeavesHolder)yangNode).getListOfLeaf()) != null) {
            for (YangLeaf yangLeaf : leavesList) {
                Object leafType;
                YtbNodeInfo parentYtbInfo = this.getParentYtbInfo();
                Object parentObj = YtbUtil.getParentObjectOfNode(parentYtbInfo, yangNode);
                try {
                    leafType = YtbUtil.getAttributeOfObject(parentObj, YtbUtil.getJavaName(yangLeaf));
                }
                catch (NoSuchMethodException e) {
                    throw new YtbException(e);
                }
                this.addLeafWithValue((YangSchemaNode)yangNode, yangLeaf, parentObj, leafType);
                this.addLeafWithoutValue((YangSchemaNode)yangNode, yangLeaf, parentObj);
            }
        }
    }

    private void processLeavesList(YangNode yangNode) {
        List listOfLeafList;
        if (yangNode instanceof YangLeavesHolder && (listOfLeafList = ((YangLeavesHolder)yangNode).getListOfLeafList()) != null) {
            for (YangLeafList yangLeafList : listOfLeafList) {
                this.addToBuilder(yangNode, yangLeafList);
            }
        }
    }

    private void addToBuilder(YangNode yangNode, YangLeafList leafList) {
        List obj;
        YtbNodeInfo ytbNodeInfo = this.getParentYtbInfo();
        Object parentObj = YtbUtil.getParentObjectOfNode(ytbNodeInfo, yangNode);
        try {
            obj = (List)YtbUtil.getAttributeOfObject(parentObj, YtbUtil.getJavaName(leafList));
        }
        catch (NoSuchMethodException e) {
            throw new YtbException(e);
        }
        if (obj != null) {
            this.addLeafListValue(yangNode, parentObj, leafList, obj);
        }
    }

    private void addLeafListValue(YangNode yangNode, Object parentObj, YangLeafList leafList, List<Object> obj) {
        LinkedHashSet<String> leafListVal = new LinkedHashSet<String>();
        boolean isEmpty = false;
        for (Object object : obj) {
            String val = YtbUtil.getStringFromType((YangSchemaNode)yangNode, parentObj, YtbUtil.getJavaName(leafList), object, leafList.getDataType());
            isEmpty = this.isTypeEmpty(val, leafList.getDataType());
            if (isEmpty) {
                if (!val.equals(TRUE)) break;
                this.addLeafList(leafListVal, leafList);
                break;
            }
            if (val.equals("")) continue;
            leafListVal.add(val);
        }
        if (!isEmpty && !leafListVal.isEmpty()) {
            this.addLeafList(leafListVal, leafList);
        }
    }

    private void addLeafList(Set<String> leafListVal, YangLeafList leafList) {
        this.extBuilder.addLeafList(leafListVal, (YangSchemaNode)leafList);
        this.extBuilder.traverseToParentWithoutValidation();
    }

    private YangSchemaNode getSchemaNodeOfNotification() {
        Object eventObjType = YtbUtil.getAttributeFromInheritance(this.rootObj, STR_TYPE);
        String opTypeValue = String.valueOf(eventObjType);
        if (opTypeValue.equals("null") || opTypeValue.isEmpty()) {
            throw new YtbException("There is no notification present for the event. Invalid input for notification.");
        }
        try {
            return this.rootSchema.getNotificationSchemaNode(opTypeValue);
        }
        catch (DataModelException e) {
            throw new YtbException(e);
        }
    }

    private Object getObjOfNotification() {
        Object eventSubjectObj = YtbUtil.getAttributeFromInheritance(this.rootObj, STR_SUBJECT);
        String notificationName = this.rootSchema.getJavaAttributeName();
        try {
            return YtbUtil.getAttributeOfObject(eventSubjectObj, notificationName);
        }
        catch (NoSuchMethodException e) {
            throw new YtbException(e);
        }
    }

    private Object getCaseObjectFromChoice(YtbNodeInfo parentNodeInfo, YangSchemaNode caseNode) {
        String javaName = YangIoUtils.getCapitalCase((String)caseNode.getJavaClassNameOrBuiltInType());
        String choiceName = ((YangNode)caseNode).getParent().getName();
        Map<String, Object> mapObj = parentNodeInfo.getChoiceCaseMap();
        Object caseObj = mapObj.get(choiceName);
        Class<?> interfaceClass = YtbUtil.getInterfaceClassFromImplClass(caseObj);
        return interfaceClass.getSimpleName().equals(javaName) ? caseObj : null;
    }

    private void addLeafWithValue(YangSchemaNode holder, YangLeaf yangLeaf, Object parentObj, Object leafType) {
        String fieldValue = null;
        if (YtbUtil.isTypePrimitive(yangLeaf.getDataType())) {
            fieldValue = this.getLeafValueFromValueSetFlag(holder, parentObj, yangLeaf, leafType);
        } else if (leafType != null) {
            fieldValue = YtbUtil.getStringFromType(holder, parentObj, YtbUtil.getJavaName(yangLeaf), leafType, yangLeaf.getDataType());
        }
        if (YtbUtil.nonEmpty(fieldValue)) {
            boolean isEmpty = this.isTypeEmpty(fieldValue, yangLeaf.getDataType());
            if (isEmpty) {
                if (!fieldValue.equals(TRUE)) {
                    return;
                }
                fieldValue = null;
            }
            this.extBuilder.addLeaf(fieldValue, (YangSchemaNode)yangLeaf);
            this.extBuilder.traverseToParentWithoutValidation();
        }
    }

    private boolean isTypeEmpty(String fieldValue, YangType<?> dataType) {
        if (fieldValue.equals(TRUE) || fieldValue.equals(FALSE)) {
            switch (dataType.getDataType()) {
                case EMPTY: {
                    return true;
                }
                case LEAFREF: {
                    YangLeafRef leafRef = (YangLeafRef)dataType.getDataTypeExtendedInfo();
                    return this.isTypeEmpty(fieldValue, leafRef.getEffectiveDataType());
                }
                case DERIVED: {
                    YangDerivedInfo info = (YangDerivedInfo)dataType.getDataTypeExtendedInfo();
                    YangDataTypes type = info.getEffectiveBuiltInType();
                    return type == YangDataTypes.EMPTY;
                }
            }
            return false;
        }
        return false;
    }

    private void addLeafWithoutValue(YangSchemaNode holder, YangLeaf yangLeaf, Object parentObj) {
        String selectLeaf;
        try {
            selectLeaf = YtbUtil.isValueOrSelectLeafSet(holder, parentObj, YtbUtil.getJavaName(yangLeaf), IS_SELECT_LEAF_SET_METHOD);
        }
        catch (NoSuchMethodException e) {
            selectLeaf = FALSE;
        }
        if (selectLeaf.equals(TRUE)) {
            this.extBuilder.addLeaf(null, (YangSchemaNode)yangLeaf);
            this.extBuilder.traverseToParentWithoutValidation();
        }
    }

    private String getLeafValueFromValueSetFlag(YangSchemaNode holder, Object parentObj, YangLeaf yangLeaf, Object leafType) {
        String valueOfLeaf;
        try {
            valueOfLeaf = YtbUtil.isValueOrSelectLeafSet(holder, parentObj, YtbUtil.getJavaName(yangLeaf), IS_LEAF_VALUE_SET_METHOD);
        }
        catch (NoSuchMethodException e) {
            throw new YtbException(e);
        }
        if (valueOfLeaf.equals(TRUE)) {
            return YtbUtil.getStringFromType(holder, parentObj, YtbUtil.getJavaName(yangLeaf), leafType, yangLeaf.getDataType());
        }
        return null;
    }

    private YtbTraversalInfo getProcessableInfo(YangNode curNode) {
        if (curNode.getNextSibling() != null) {
            YangNode sibling = curNode.getNextSibling();
            while (YtbUtil.isNonProcessableNode(sibling)) {
                sibling = sibling.getNextSibling();
            }
            if (sibling != null) {
                return new YtbTraversalInfo(sibling, TraversalType.SIBLING);
            }
        }
        return new YtbTraversalInfo(curNode.getParent(), TraversalType.PARENT);
    }
}

