/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yms.app.yob;

import org.onosproject.yms.app.yob.YobWorkBench;
import org.onosproject.yms.app.yob.exception.YobException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class YobBuilderOrBuiltObject {
    private static final Logger log = LoggerFactory.getLogger(YobWorkBench.class);
    private boolean isBuilt;
    private Object builderOrBuiltObject;
    Class<?> yangBuilderClass;
    Class<?> yangDefaultClass;

    YobBuilderOrBuiltObject(String qualifiedClassName, ClassLoader registeredAppClassLoader) {
        try {
            this.yangDefaultClass = registeredAppClassLoader.loadClass(qualifiedClassName);
            this.yangBuilderClass = this.yangDefaultClass.getDeclaredClasses()[0];
            this.setBuilderObject(this.yangBuilderClass.newInstance());
        }
        catch (ClassNotFoundException e) {
            log.error("Failed to load class for class: {}", (Object)qualifiedClassName);
            throw new YobException("Failed to load class for class: " + qualifiedClassName);
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error("Failed to create an object for class: {}", (Object)qualifiedClassName);
            throw new YobException("Failed to create an object for class: " + qualifiedClassName);
        }
        catch (NullPointerException e) {
            log.error("Reflection failed to create an object for class: {}", (Object)qualifiedClassName);
            throw new YobException("Reflection failed to create an object for class: " + qualifiedClassName);
        }
    }

    Object getBuilderObject() {
        if (this.isBuilt) {
            throw new YobException("Object is already built, cannot fetch builder");
        }
        if (this.builderOrBuiltObject == null) {
            throw new YobException("Builder is not yet set, cannot fetch it");
        }
        return this.builderOrBuiltObject;
    }

    private void setBuilderObject(Object builderObject) {
        if (this.isBuilt) {
            throw new YobException("Object is already built, cannot set builder");
        }
        if (this.builderOrBuiltObject != null) {
            throw new YobException("Builder is not already set");
        }
        this.builderOrBuiltObject = builderObject;
    }

    Object getBuiltObject() {
        if (!this.isBuilt) {
            throw new YobException("Builder is not yet set, cannot fetch it");
        }
        if (this.builderOrBuiltObject == null) {
            throw new YobException("Built object is not set");
        }
        return this.builderOrBuiltObject;
    }

    void setBuiltObject(Object builtObject) {
        if (this.isBuilt) {
            throw new YobException("Object is already built, cannot build again");
        }
        if (this.builderOrBuiltObject == null) {
            throw new YobException("Object building without builder");
        }
        this.isBuilt = true;
        this.builderOrBuiltObject = builtObject;
    }
}

