/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yms.app.ysr;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.onosproject.yangutils.datamodel.YangNamespace;
import org.onosproject.yms.ysr.YangModuleIdentifier;
import org.onosproject.yms.ysr.YangModuleInformation;

class DefaultYangModuleInformation
implements YangModuleInformation {
    private final YangModuleIdentifier moduleIdentifier;
    private final YangNamespace nameSpace;
    private final List<String> features;
    private final List<YangModuleIdentifier> subModuleIdentifiers;

    DefaultYangModuleInformation(YangModuleIdentifier moduleIdentifier, YangNamespace nameSpace) {
        this.moduleIdentifier = moduleIdentifier;
        this.nameSpace = nameSpace;
        this.subModuleIdentifiers = new ArrayList<YangModuleIdentifier>();
        this.features = new ArrayList<String>();
    }

    public YangModuleIdentifier moduleIdentifier() {
        return this.moduleIdentifier;
    }

    public YangNamespace namespace() {
        return this.nameSpace;
    }

    public List<String> featureList() {
        return ImmutableList.copyOf(this.features);
    }

    public List<YangModuleIdentifier> subModuleIdentifiers() {
        return ImmutableList.copyOf(this.subModuleIdentifiers);
    }

    void addSubModuleIdentifiers(YangModuleIdentifier subModuleIdentifier) {
        this.subModuleIdentifiers.add(subModuleIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.moduleIdentifier, this.subModuleIdentifiers, this.nameSpace, this.features);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultYangModuleInformation) {
            DefaultYangModuleInformation that = (DefaultYangModuleInformation)obj;
            return Objects.equals(this.moduleIdentifier, that.moduleIdentifier) && Objects.equals(this.nameSpace, that.nameSpace) && Objects.equals(this.features, that.features) && Objects.equals(this.subModuleIdentifiers, that.subModuleIdentifiers);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("yangModuleIdentifier", (Object)this.moduleIdentifier).add("nameSpace", (Object)this.nameSpace).add("features", this.features).add("yangModuleIdentifiers", this.subModuleIdentifiers).toString();
    }
}

