/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yms.app.ych.defaultcodecs;

import java.util.HashMap;
import java.util.Map;
import org.onosproject.yms.app.ych.YchException;
import org.onosproject.yms.app.ych.defaultcodecs.xml.XmlCodecHandler;
import org.onosproject.yms.app.ych.defaultcodecs.xml.XmlCodecMultiInstanceHandler;
import org.onosproject.yms.app.ych.defaultcodecs.xml.XmlCodecMultiInstanceLeafHandler;
import org.onosproject.yms.app.ych.defaultcodecs.xml.XmlCodecSingleInstanceHandler;
import org.onosproject.yms.app.ych.defaultcodecs.xml.XmlCodecSingleInstanceLeafHandler;
import org.onosproject.yms.ych.YangProtocolEncodingFormat;
import org.onosproject.yms.ydt.YdtContext;
import org.onosproject.yms.ydt.YdtType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CodecHandlerFactory {
    private static final Logger log = LoggerFactory.getLogger(CodecHandlerFactory.class);
    private static final String YDT_TYPE_ERROR = "YDT type is not supported.";
    private final Map<YdtType, XmlCodecHandler> handlerMap = new HashMap<YdtType, XmlCodecHandler>();

    private CodecHandlerFactory() {
        this.handlerMap.put(YdtType.SINGLE_INSTANCE_NODE, new XmlCodecSingleInstanceHandler());
        this.handlerMap.put(YdtType.MULTI_INSTANCE_NODE, new XmlCodecMultiInstanceHandler());
        this.handlerMap.put(YdtType.SINGLE_INSTANCE_LEAF_VALUE_NODE, new XmlCodecSingleInstanceLeafHandler());
        this.handlerMap.put(YdtType.MULTI_INSTANCE_LEAF_VALUE_NODE, new XmlCodecMultiInstanceLeafHandler());
    }

    public XmlCodecHandler getCodecHandlerForContext(YdtContext node, YangProtocolEncodingFormat format) {
        if (format == YangProtocolEncodingFormat.XML) {
            XmlCodecHandler handler = this.handlerMap.get(node.getYdtType());
            if (handler == null) {
                throw new YchException(YDT_TYPE_ERROR + node.getYdtType());
            }
            return handler;
        }
        log.error("{} data format is not supported.", (Object)format);
        return null;
    }

    public static CodecHandlerFactory instance() {
        return LazyHolder.INSTANCE;
    }

    private static class LazyHolder {
        private static final CodecHandlerFactory INSTANCE = new CodecHandlerFactory();

        private LazyHolder() {
        }
    }
}

