/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yms.app.ych.defaultcodecs.netconf;

import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import java.util.Set;
import org.dom4j.Element;
import org.onosproject.yms.app.ych.YchException;
import org.onosproject.yms.ydt.YmsOperationType;

public class NetconfCodec {
    private static final String PROTO_OPER_ERROR = "Received protocol operation is not same as in the XML string: ";
    private static final Set<String> ALLOWABLE_NAMES = ImmutableSet.of((Object)"config", (Object)"data", (Object)"filter");

    private void validateOpType(String elementName, YmsOperationType opType) {
        switch (elementName) {
            case "edit-config": {
                if (opType == YmsOperationType.EDIT_CONFIG_REQUEST) break;
                throw new YchException(PROTO_OPER_ERROR + opType);
            }
            case "get-config": {
                if (opType == YmsOperationType.QUERY_CONFIG_REQUEST) break;
                throw new YchException(PROTO_OPER_ERROR + opType);
            }
            case "get": {
                if (opType == YmsOperationType.QUERY_REQUEST) break;
                throw new YchException(PROTO_OPER_ERROR + opType);
            }
        }
    }

    public Element getDataRootElement(Element rootElement, YmsOperationType opType) {
        Element retElement = null;
        String elementName = rootElement.getName();
        try {
            this.validateOpType(elementName, opType);
            if ("data".equals(elementName) || "config".equals(elementName) || "filter".equals(elementName)) {
                return rootElement;
            }
            if (rootElement.hasContent() && !rootElement.isTextOnly()) {
                Iterator i = rootElement.elementIterator();
                while (i.hasNext()) {
                    Element childElement = (Element)i.next();
                    retElement = this.getDataRootElement(childElement, opType);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retElement;
    }
}

