/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yms.app.ydt;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.onosproject.yangutils.datamodel.YangList;
import org.onosproject.yangutils.datamodel.YangNamespace;
import org.onosproject.yangutils.datamodel.YangSchemaNode;
import org.onosproject.yangutils.datamodel.YangSchemaNodeIdentifier;
import org.onosproject.yms.app.ydt.NameSpace;
import org.onosproject.yms.app.ydt.YdtConstants;
import org.onosproject.yms.app.ydt.YdtNode;
import org.onosproject.yms.app.ydt.exceptions.YdtException;
import org.onosproject.yms.ydt.YdtContext;
import org.onosproject.yms.ydt.YdtType;

public class YdtMultiInstanceNode
extends YdtNode {
    private static final String FMT_MISSING_KEY = "%s is missing some of the keys of %s.";
    private static final String FMT_UNI_KEY = "Some of the key elements are not unique in %s.";
    private static final String FMT_MANY_INS = "Too many instances of %s. Expected maximum instances %d.";
    private static final String FMT_FEW_INS = "Too few instances of %s. Expected minimum instances %d.";
    private List<YdtContext> keyNodeList = new ArrayList<YdtContext>();
    private String compositeKey;

    YdtMultiInstanceNode(YangSchemaNode node) {
        super(YdtType.MULTI_INSTANCE_NODE, node);
    }

    private String getCompositeKey() {
        return this.compositeKey;
    }

    public List<YdtContext> getKeyNodeList() {
        return ImmutableList.copyOf(this.keyNodeList);
    }

    @Override
    public void createKeyNodeList() throws YdtException {
        YangList yangListHolder = (YangList)this.getYangSchemaNode();
        List schemaKeyList = yangListHolder.getKeyList();
        if (schemaKeyList == null || !yangListHolder.isConfig()) {
            return;
        }
        StringBuilder ksb = new StringBuilder();
        Iterator sklItr = schemaKeyList.iterator();
        ArrayList<YdtContext> nodeList = new ArrayList<YdtContext>();
        YangSchemaNodeIdentifier id = new YangSchemaNodeIdentifier();
        id.setNameSpace((YangNamespace)new NameSpace(this.getNamespace()));
        while (sklItr.hasNext()) {
            String name = (String)sklItr.next();
            id.setName(name);
            YdtNode collidingChild = (YdtNode)this.ydtNodeMap.get(id);
            if (collidingChild == null) {
                throw new YdtException(YdtConstants.errorMsg(FMT_MISSING_KEY, yangListHolder.getParent().getName(), yangListHolder.getName()));
            }
            ksb.append(collidingChild.getValue());
            nodeList.add(collidingChild);
        }
        this.keyNodeList = nodeList;
        this.compositeKey = ksb.toString();
    }

    public void validateInstances(Set keyStringSet, List list) throws YdtException {
        keyStringSet.clear();
        int instanceCount = list.size();
        YangList listSchema = (YangList)((YdtMultiInstanceNode)list.get(0)).getYangSchemaNode();
        this.validateInstanceCount(instanceCount, listSchema);
        if (listSchema.isConfig() && instanceCount > 1) {
            for (YdtNode ydtNode : list) {
                if (keyStringSet.add(((YdtMultiInstanceNode)ydtNode).getCompositeKey())) continue;
                throw new YdtException(YdtConstants.errorMsg(FMT_UNI_KEY, ydtNode.getName()));
            }
        }
    }

    private void validateInstanceCount(int instanceCount, YangList list) throws YdtException {
        int maxElement;
        int minElement;
        if (list.getMinElements() != null && instanceCount < (minElement = list.getMinElements().getMinElement())) {
            throw new YdtException(YdtConstants.errorMsg(FMT_FEW_INS, list.getName(), minElement));
        }
        if (list.getMaxElements() != null && instanceCount > (maxElement = list.getMaxElements().getMaxElement())) {
            throw new YdtException(YdtConstants.errorMsg(FMT_MANY_INS, list.getName(), maxElement));
        }
    }
}

