/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yms.app.ydt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onosproject.yangutils.datamodel.YangSchemaNode;
import org.onosproject.yangutils.datamodel.YangSchemaNodeContextInfo;
import org.onosproject.yangutils.datamodel.YangSchemaNodeIdentifier;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yms.app.ydt.AppType;
import org.onosproject.yms.app.ydt.YdtConstants;
import org.onosproject.yms.app.ydt.YdtExtendedContext;
import org.onosproject.yms.app.ydt.YdtMultiInstanceNode;
import org.onosproject.yms.app.ydt.exceptions.YdtException;
import org.onosproject.yms.ydt.YdtContext;
import org.onosproject.yms.ydt.YdtContextOperationType;
import org.onosproject.yms.ydt.YdtExtendedInfoType;
import org.onosproject.yms.ydt.YdtType;

public abstract class YdtNode<T>
implements YdtExtendedContext,
Cloneable {
    private static final String FMT_NON_LIST_STR = "List of key cannot be created for leaf and leaf-list %s node.";
    private static final String FMT_VAL_N = "Value cannot be set in non leaf %s node.";
    private static final String FMT_VAL_NS = "ValueSet cannot be set in non leaf-list %s node.";
    private static final String FMT_VAL_IN = "Value cannot be invoke from non leaf %s node.";
    private static final String FMT_VAL_INS = "ValueSet cannot be invoke from non leaf-list %s node";
    private static final String E_EXIST = "Node is already part of a tree";
    private static final String E_ATOMIC = "Child to be added is not atomic, it already has a child";
    private static final String E_SIB = "Child to be added is not atomic, it already has a next sibling";
    private static final String E_PRE = "Child to be added is not atomic, it already has a previous sibling";
    private static final String E_SUPPORT = "Requested node type not supported";
    private YdtNode parent;
    private YdtNode child;
    private YdtNode nextSibling;
    private YdtNode previousSibling;
    private YdtNode lastChild;
    private final YdtType ydtType;
    private boolean isContextSwitch;
    private T ydtExtendedInfo;
    private YdtExtendedInfoType ydtExtendedInfoType;
    final Map<YangSchemaNodeIdentifier, YdtNode<T>> ydtNodeMap = new HashMap<YangSchemaNodeIdentifier, YdtNode<T>>();
    private final Map<YangSchemaNodeIdentifier, List<YdtNode<YdtMultiInstanceNode>>> ydtMultiInsMap = new HashMap<YangSchemaNodeIdentifier, List<YdtNode<YdtMultiInstanceNode>>>();
    private YangSchemaNode yangSchemaNode;
    private YdtContextOperationType ydtContextOperationType;
    private final Map<AppType, Object> ydtAppInfoMap = new HashMap<AppType, Object>();
    private YdtContext clonedNode;

    YdtNode(YdtType type, YangSchemaNode node) {
        this.ydtType = type;
        this.yangSchemaNode = node;
    }

    YdtNode(YdtType type) {
        this.ydtType = type;
    }

    public YdtContext getClonedNode() {
        return this.clonedNode;
    }

    public void setClonedNode(YdtContext clonedNode) {
        this.clonedNode = clonedNode;
    }

    public String getName() {
        return this.yangSchemaNode.getName();
    }

    public String getNamespace() {
        return this.yangSchemaNode.getNameSpace().getModuleNamespace();
    }

    public String getModuleNameAsNameSpace() {
        return this.yangSchemaNode.getNameSpace().getModuleName();
    }

    public <T> T getYdtContextExtendedInfo() {
        return this.ydtExtendedInfo;
    }

    public YdtExtendedInfoType getYdtExtendedInfoType() {
        return this.ydtExtendedInfoType;
    }

    public YdtType getYdtType() {
        return this.ydtType;
    }

    public YdtNode getParent() {
        return this.parent;
    }

    public YdtNode getFirstChild() {
        return this.child;
    }

    public YdtNode getNextSibling() {
        return this.nextSibling;
    }

    @Override
    public YangSchemaNode getYangSchemaNode() {
        return this.yangSchemaNode;
    }

    public YdtNode getLastChild() {
        return this.lastChild;
    }

    @Override
    public Object getAppInfo(AppType appType) {
        return this.ydtAppInfoMap.get((Object)appType);
    }

    @Override
    public void addAppInfo(AppType appType, Object object) {
        this.ydtAppInfoMap.put(appType, object);
    }

    public YangSchemaNodeContextInfo getSchemaNodeContextInfo(YangSchemaNodeIdentifier id) throws YdtException {
        try {
            return this.getYangSchemaNode().getChildSchema(id);
        }
        catch (DataModelException e) {
            throw new YdtException(e.getLocalizedMessage());
        }
    }

    public void addValue(String value) throws YdtException {
        throw new YdtException(YdtConstants.errorMsg(FMT_VAL_N, this.getName()));
    }

    public void createKeyNodeList() throws YdtException {
        throw new YdtException(YdtConstants.errorMsg(FMT_NON_LIST_STR, this.getName()));
    }

    public void addValueWithoutValidation(String value, boolean isKeyLeaf) throws YdtException {
        throw new YdtException(YdtConstants.errorMsg(FMT_VAL_N, this.getName()));
    }

    public void addValueSet(Set<String> valueSet) throws YdtException {
        throw new YdtException(YdtConstants.errorMsg(FMT_VAL_NS, this.getName()));
    }

    public void addValueSetWithoutValidation(Set<String> valueSet) throws YdtException {
        throw new YdtException(YdtConstants.errorMsg(FMT_VAL_NS, this.getName()));
    }

    void validDuplicateEntryProcessing() throws YdtException {
    }

    public YdtNode getCollidingChild(YangSchemaNodeIdentifier id) throws YdtException {
        YdtNode<T> collidingChild = this.ydtNodeMap.get(id);
        if (collidingChild != null) {
            collidingChild.validDuplicateEntryProcessing();
            return collidingChild;
        }
        return null;
    }

    public void setParent(YdtNode parent) {
        this.parent = parent;
    }

    public void setChild(YdtNode child) {
        this.child = child;
    }

    public void setNextSibling(YdtNode sibling) {
        this.nextSibling = sibling;
    }

    public YdtNode getPreviousSibling() {
        return this.previousSibling;
    }

    public void setPreviousSibling(YdtNode previousSibling) {
        this.previousSibling = previousSibling;
    }

    public String getValue() throws YdtException {
        throw new YdtException(YdtConstants.errorMsg(FMT_VAL_IN, this.getName()));
    }

    public Set<String> getValueSet() throws YdtException {
        throw new YdtException(YdtConstants.errorMsg(FMT_VAL_INS, this.getName()));
    }

    public void setYangSchemaNode(YangSchemaNode yangSchemaNode) {
        this.yangSchemaNode = yangSchemaNode;
    }

    public void setLastChild(YdtNode child) {
        this.lastChild = child;
    }

    public void addChild(YdtContext newChild, boolean isAtomic) throws YdtException {
        if (!(newChild instanceof YdtNode)) {
            throw new YdtException(YdtConstants.errorMsg(E_SUPPORT, new Object[0]));
        }
        YdtNode node = (YdtNode)newChild;
        if (node.getParent() == null) {
            node.setParent(this);
        } else if (!node.getParent().equals(this)) {
            throw new YdtException(E_EXIST);
        }
        if (node.getFirstChild() != null && isAtomic) {
            throw new YdtException(E_ATOMIC);
        }
        if (node.getNextSibling() != null) {
            throw new YdtException(E_SIB);
        }
        if (node.getPreviousSibling() != null) {
            throw new YdtException(E_PRE);
        }
        if (this.getFirstChild() == null) {
            this.setChild(node);
            this.setLastChild(node);
            return;
        }
        YdtNode curNode = this.getLastChild();
        curNode.setNextSibling(node);
        node.setPreviousSibling(curNode);
        this.setLastChild(node);
    }

    @Override
    public YdtContextOperationType getYdtContextOperationType() {
        return this.ydtContextOperationType;
    }

    public void setYdtContextOperationType(YdtContextOperationType opType) {
        this.ydtContextOperationType = opType;
    }

    void updateYdtMap(YdtNode node) {
        YangSchemaNodeIdentifier id = node.getYangSchemaNode().getYangSchemaNodeIdentifier();
        if (node.getYdtType() == YdtType.MULTI_INSTANCE_NODE) {
            this.updateMultiInsMap(id, node);
        }
        this.ydtNodeMap.put(id, node);
    }

    private void updateMultiInsMap(YangSchemaNodeIdentifier id, YdtNode node) {
        List<YdtNode<YdtMultiInstanceNode>> list = this.ydtMultiInsMap.get(id);
        if (list == null) {
            list = new ArrayList<YdtNode<YdtMultiInstanceNode>>();
            this.ydtMultiInsMap.put(id, list);
        }
        list.add(node);
    }

    public boolean getAppContextSwitch() {
        return this.isContextSwitch;
    }

    public void setAppContextSwitch() {
        this.isContextSwitch = true;
    }

    public void validateMultiInstanceNode() throws YdtException {
        HashSet<String> keyStringSet = new HashSet<String>();
        if (this.ydtMultiInsMap.size() != 0) {
            for (List<YdtNode<YdtMultiInstanceNode>> ydtNodeList : this.ydtMultiInsMap.values()) {
                try {
                    ydtNodeList.get(0).validateInstances(keyStringSet, ydtNodeList);
                }
                catch (YdtException e) {
                    throw new YdtException(e.getLocalizedMessage());
                }
            }
        }
    }

    void validateInstances(Set<String> keyStringSet, List<YdtNode<YdtMultiInstanceNode>> ydtNodeList) throws YdtException {
    }

    public YdtNode clone() throws CloneNotSupportedException {
        YdtNode clonedNode = (YdtNode)super.clone();
        clonedNode.setPreviousSibling(null);
        clonedNode.setNextSibling(null);
        clonedNode.setParent(null);
        clonedNode.setChild(null);
        clonedNode.setLastChild(null);
        return clonedNode;
    }
}

