/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yms.app.ydt;

import org.onosproject.yangutils.datamodel.YangSchemaNode;
import org.onosproject.yangutils.datamodel.YangSchemaNodeType;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yms.app.ydt.RequestedCallType;
import org.onosproject.yms.app.ydt.RequestedCardinality;
import org.onosproject.yms.app.ydt.YdtConstants;
import org.onosproject.yms.app.ydt.YdtMultiInstanceLeafNode;
import org.onosproject.yms.app.ydt.YdtMultiInstanceNode;
import org.onosproject.yms.app.ydt.YdtNode;
import org.onosproject.yms.app.ydt.YdtSingleInstanceLeafNode;
import org.onosproject.yms.app.ydt.YdtSingleInstanceNode;
import org.onosproject.yms.app.ydt.exceptions.YdtException;

final class YdtNodeFactory {
    private static final String FMT_NOT_EXIST = "Schema node with name %s doesn't exist.";
    private static final String E_MULTI_INS = "Requested interface adds an instance of type list or leaf-list node only.";

    private YdtNodeFactory() {
    }

    static YdtNode getNode(YangSchemaNode node, RequestedCardinality cardinality, RequestedCallType callType) throws YdtException {
        YdtNode newNode;
        YangSchemaNodeType type = node.getYangSchemaNodeType();
        try {
            switch (cardinality) {
                case UNKNOWN: {
                    newNode = YdtNodeFactory.getYangSchemaNodeTypeSpecificContext(node, type, callType);
                    break;
                }
                case SINGLE_INSTANCE: {
                    YdtNodeFactory.validateNodeType(node, type, YangSchemaNodeType.YANG_SINGLE_INSTANCE_NODE);
                    newNode = new YdtSingleInstanceNode(node);
                    break;
                }
                case MULTI_INSTANCE: {
                    YdtNodeFactory.validateNodeType(node, type, YangSchemaNodeType.YANG_MULTI_INSTANCE_NODE);
                    newNode = new YdtMultiInstanceNode(node);
                    break;
                }
                case SINGLE_INSTANCE_LEAF: {
                    YdtNodeFactory.validateNodeType(node, type, YangSchemaNodeType.YANG_SINGLE_INSTANCE_LEAF_NODE);
                    newNode = new YdtSingleInstanceLeafNode(node);
                    break;
                }
                case MULTI_INSTANCE_LEAF: {
                    YdtNodeFactory.validateNodeType(node, type, YangSchemaNodeType.YANG_MULTI_INSTANCE_LEAF_NODE);
                    newNode = new YdtMultiInstanceLeafNode(node);
                    break;
                }
                default: {
                    newNode = null;
                    break;
                }
            }
        }
        catch (DataModelException | YdtException e) {
            throw new YdtException(e.getLocalizedMessage());
        }
        if (newNode == null) {
            throw new YdtException(YdtConstants.errorMsg(FMT_NOT_EXIST, node.getName()));
        }
        return newNode;
    }

    private static void validateNodeType(YangSchemaNode node, YangSchemaNodeType nodeType, YangSchemaNodeType requestedType) throws YdtException {
        if (nodeType != requestedType) {
            throw new YdtException(YdtConstants.errorMsg(FMT_NOT_EXIST, node.getName()));
        }
    }

    private static YdtNode getYangSchemaNodeTypeSpecificContext(YangSchemaNode node, YangSchemaNodeType nodeType, RequestedCallType callType) throws YdtException, DataModelException {
        switch (callType) {
            case LEAF: {
                switch (nodeType) {
                    case YANG_SINGLE_INSTANCE_LEAF_NODE: {
                        return new YdtSingleInstanceLeafNode(node);
                    }
                    case YANG_MULTI_INSTANCE_LEAF_NODE: {
                        return new YdtMultiInstanceLeafNode(node);
                    }
                }
                return null;
            }
            case NON_LEAF: {
                switch (nodeType) {
                    case YANG_SINGLE_INSTANCE_NODE: {
                        return new YdtSingleInstanceNode(node);
                    }
                    case YANG_MULTI_INSTANCE_NODE: {
                        return new YdtMultiInstanceNode(node);
                    }
                }
                return null;
            }
            case MULTI_INSTANCE: {
                switch (nodeType) {
                    case YANG_MULTI_INSTANCE_LEAF_NODE: {
                        return new YdtMultiInstanceLeafNode(node);
                    }
                    case YANG_MULTI_INSTANCE_NODE: {
                        return new YdtMultiInstanceNode(node);
                    }
                }
                throw new YdtException(E_MULTI_INS);
            }
        }
        return null;
    }

    static YdtNode getYangSchemaNodeTypeSpecificContext(YangSchemaNode node) throws YdtException {
        switch (node.getYangSchemaNodeType()) {
            case YANG_SINGLE_INSTANCE_LEAF_NODE: {
                return new YdtSingleInstanceLeafNode(node);
            }
            case YANG_MULTI_INSTANCE_LEAF_NODE: {
                return new YdtMultiInstanceLeafNode(node);
            }
            case YANG_SINGLE_INSTANCE_NODE: {
                return new YdtSingleInstanceNode(node);
            }
            case YANG_MULTI_INSTANCE_NODE: {
                return new YdtMultiInstanceNode(node);
            }
        }
        throw new YdtException(YdtConstants.errorMsg(FMT_NOT_EXIST, node.getName()));
    }
}

