/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yms.app.yob;

import java.util.HashMap;
import java.util.Map;
import org.onosproject.yms.app.ydt.YdtExtendedContext;
import org.onosproject.yms.app.yob.YobHandler;
import org.onosproject.yms.app.yob.YobMultiInstanceHandler;
import org.onosproject.yms.app.yob.YobMultiInstanceLeafHandler;
import org.onosproject.yms.app.yob.YobSingleInstanceHandler;
import org.onosproject.yms.app.yob.YobSingleInstanceLeafHandler;
import org.onosproject.yms.app.yob.exception.YobException;
import org.onosproject.yms.ydt.YdtType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class YobHandlerFactory {
    private static final Logger log = LoggerFactory.getLogger(YobHandlerFactory.class);
    private static final Map<YdtType, YobHandler> HANDLER_MAP = new HashMap<YdtType, YobHandler>();

    private YobHandlerFactory() {
        HANDLER_MAP.put(YdtType.SINGLE_INSTANCE_NODE, new YobSingleInstanceHandler());
        HANDLER_MAP.put(YdtType.MULTI_INSTANCE_NODE, new YobMultiInstanceHandler());
        HANDLER_MAP.put(YdtType.SINGLE_INSTANCE_LEAF_VALUE_NODE, new YobSingleInstanceLeafHandler());
        HANDLER_MAP.put(YdtType.MULTI_INSTANCE_LEAF_VALUE_NODE, new YobMultiInstanceLeafHandler());
    }

    YobHandler getYobHandlerForContext(YdtExtendedContext currentNode) {
        YobHandler yobHandler = HANDLER_MAP.get(currentNode.getYdtType());
        if (yobHandler == null) {
            log.error("Given YDT type is not supported.");
            throw new YobException("Given YDT type is not supported.");
        }
        return yobHandler;
    }

    public static YobHandlerFactory instance() {
        return LazyHolder.INSTANCE;
    }

    private static class LazyHolder {
        private static final YobHandlerFactory INSTANCE = new YobHandlerFactory();

        private LazyHolder() {
        }
    }
}

