/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yms.app.ypm;

import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.yms.ydt.YdtContext;
import org.onosproject.yms.ypm.DefaultYpmNode;
import org.onosproject.yms.ypm.YpmContext;
import org.onosproject.yms.ypm.YpmService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(immediate=true)
public class YpmManager
implements YpmService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private YpmContext rootYpmNode;

    @Activate
    public void activate() {
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    public YpmContext getProtocolData(YdtContext rootYdtNode) {
        DefaultYpmNode rootRetYpmNode;
        if (rootYdtNode == null) {
            this.log.debug("Input data is null. So, will not proceed.");
            return null;
        }
        if (this.rootYpmNode == null) {
            this.log.debug("YPM tree has no data.");
            return null;
        }
        YdtContext currentYdtNode = rootYdtNode;
        YpmContext currentYpmNode = this.rootYpmNode;
        DefaultYpmNode currRetYpmNode = rootRetYpmNode = new DefaultYpmNode(currentYdtNode.getName());
        block0: while (currentYdtNode != null) {
            YdtContext nextNode = currentYdtNode.getFirstChild();
            if (nextNode != null) {
                YpmContext ypmChild = currentYpmNode.getChild(nextNode.getName());
                if (ypmChild == null) {
                    return rootRetYpmNode;
                }
                currRetYpmNode.addChild(ypmChild.getName());
                currentYdtNode = nextNode;
                currentYpmNode = currentYpmNode.getChild(nextNode.getName());
                currRetYpmNode = currRetYpmNode.getChild(nextNode.getName());
                currRetYpmNode.setMetaData(currentYpmNode.getMetaData());
                continue;
            }
            while (currentYdtNode != null) {
                nextNode = currentYdtNode.getNextSibling();
                if (nextNode != null) {
                    YpmContext ypmSibling = currentYpmNode.getSibling(nextNode.getName());
                    if (ypmSibling == null) {
                        return rootRetYpmNode;
                    }
                    currRetYpmNode.addSibling(ypmSibling.getName());
                    currentYdtNode = nextNode;
                    currentYpmNode = currentYpmNode.getSibling(nextNode.getName());
                    currRetYpmNode = currRetYpmNode.getSibling(nextNode.getName());
                    currRetYpmNode.setMetaData(currentYpmNode.getMetaData());
                    continue block0;
                }
                if (currentYdtNode == rootYdtNode) {
                    currentYdtNode = null;
                    continue;
                }
                currentYdtNode = currentYdtNode.getParent();
                currentYpmNode = currentYpmNode.getParent();
                currRetYpmNode = currRetYpmNode.getParent();
            }
        }
        return rootRetYpmNode;
    }

    public void setProtocolData(YdtContext rootYdtNode, Object data) {
        if (rootYdtNode == null || data == null) {
            this.log.debug("Input data is null. So, will not proceed.");
            return;
        }
        YdtContext currentYdtNode = rootYdtNode;
        YpmContext currentYpmNode = this.rootYpmNode;
        block0: while (currentYdtNode != null) {
            YdtContext nextNode;
            if (this.rootYpmNode == null) {
                currentYpmNode = this.rootYpmNode = new DefaultYpmNode(currentYdtNode.getName());
            }
            if ((nextNode = currentYdtNode.getFirstChild()) != null) {
                if (currentYpmNode.getChild(nextNode.getName()) == null) {
                    currentYpmNode.addChild(nextNode.getName());
                }
                currentYpmNode = currentYpmNode.getChild(nextNode.getName());
                currentYpmNode.setMetaData(data);
                currentYdtNode = nextNode;
                continue;
            }
            while (currentYdtNode != null) {
                nextNode = currentYdtNode.getNextSibling();
                if (nextNode != null) {
                    if (currentYpmNode.getSibling(nextNode.getName()) == null) {
                        currentYpmNode.addSibling(nextNode.getName());
                    }
                    currentYpmNode = currentYpmNode.getSibling(nextNode.getName());
                    currentYpmNode.setMetaData(data);
                    currentYdtNode = nextNode;
                    continue block0;
                }
                if (currentYdtNode == rootYdtNode) {
                    currentYdtNode = null;
                    continue;
                }
                currentYdtNode = currentYdtNode.getParent();
                currentYpmNode = currentYpmNode.getParent();
            }
        }
    }
}

