/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yms.app.ysr;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.onosproject.yms.ysr.YangModuleInformation;
import org.onosproject.yms.ysr.YangModuleLibrary;

public class DefaultYangModuleLibrary
implements YangModuleLibrary {
    private final String moduleSetId;
    private final List<YangModuleInformation> moduleInformation;

    public DefaultYangModuleLibrary(String moduleSetId) {
        this.moduleSetId = moduleSetId;
        this.moduleInformation = new ArrayList<YangModuleInformation>();
    }

    public String moduleSetId() {
        return this.moduleSetId;
    }

    public List<YangModuleInformation> yangModuleList() {
        return ImmutableList.copyOf(this.moduleInformation);
    }

    void addModuleInformation(YangModuleInformation information) {
        this.moduleInformation.add(information);
    }

    public int hashCode() {
        return Objects.hash(this.moduleInformation, this.moduleSetId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultYangModuleLibrary) {
            DefaultYangModuleLibrary that = (DefaultYangModuleLibrary)obj;
            return Objects.equals(this.moduleInformation, that.moduleInformation) && Objects.equals(this.moduleSetId, that.moduleSetId);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("moduleInformation", this.moduleInformation).add("moduleId", (Object)this.moduleSetId).toString();
    }
}

