/*
 * Copyright 2016-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.onosproject.yms.ynh;

import org.onosproject.event.AbstractEvent;

/**
 * Represents YANG notification event.
 *
 * YANG notification handler listens for the notification from the application.
 * It convert the received notification in YANG notification events.
 *
 * YangNotificationEvent represents event generated by YANG management system
 * in response to the YANG defined application notification. The applications
 * notification information is in abstract YANG data tree.
 */
public class YangNotificationEvent
        extends AbstractEvent<YangNotificationEvent.Type, YangNotification> {

    /**
     * Event type is the notification as defined in the YANG file.
     */
    public enum Type {
        /**
         * Indicates a YANG notification.
         */
        YANG_NOTIFICATION
    }

    /**
     * YANG notification information shared to NBI protocol in YANG data tree
     * using the registered callback.
     *
     * @param subject notification information in YANG data tree.
     */
    public YangNotificationEvent(YangNotification subject) {
        super(Type.YANG_NOTIFICATION, subject);
    }
}
