/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yms.app.ymsm;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.Tools;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.core.IdGenerator;
import org.onosproject.event.ListenerService;
import org.onosproject.yms.app.yab.YangApplicationBroker;
import org.onosproject.yms.app.ych.DefaultYangCodecHandler;
import org.onosproject.yms.app.ych.defaultcodecs.YangCodecRegistry;
import org.onosproject.yms.app.ydt.DefaultYdtWalker;
import org.onosproject.yms.app.ydt.YangRequestWorkBench;
import org.onosproject.yms.app.ynh.YangNotificationExtendedService;
import org.onosproject.yms.app.ynh.YangNotificationManager;
import org.onosproject.yms.app.ysr.DefaultYangModuleLibrary;
import org.onosproject.yms.app.ysr.DefaultYangSchemaRegistry;
import org.onosproject.yms.app.ysr.YangSchemaRegistry;
import org.onosproject.yms.ych.YangCodecHandler;
import org.onosproject.yms.ych.YangDataTreeCodec;
import org.onosproject.yms.ych.YangProtocolEncodingFormat;
import org.onosproject.yms.ydt.YdtBuilder;
import org.onosproject.yms.ydt.YdtResponse;
import org.onosproject.yms.ydt.YdtWalker;
import org.onosproject.yms.ydt.YmsOperationType;
import org.onosproject.yms.ymsm.YmsService;
import org.onosproject.yms.ynh.YangNotificationService;
import org.onosproject.yms.ysr.YangModuleIdentifier;
import org.onosproject.yms.ysr.YangModuleLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(immediate=true)
public class YmsManager
implements YmsService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String APP_ID = "org.onosproject.app.yms";
    private static final String MODULE_ID = "module-id";
    private ApplicationId appId;
    private YangSchemaRegistry schemaRegistry;
    private IdGenerator moduleIdGenerator;
    private ExecutorService executor;
    private YangNotificationExtendedService ynhExtendedService;
    private YangModuleLibrary library;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication(APP_ID);
        this.moduleIdGenerator = this.coreService.getIdGenerator(MODULE_ID);
        this.schemaRegistry = new DefaultYangSchemaRegistry();
        this.library = new DefaultYangModuleLibrary(this.getNewModuleId());
        this.executor = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)"onos/apps/yang-management-system/schema-registry", (String)"schema-registry-handler", (Logger)this.log));
        this.ynhExtendedService = new YangNotificationManager(this.schemaRegistry);
        YangCodecRegistry.initializeDefaultCodec();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.schemaRegistry.flushYsrData();
        this.executor.shutdown();
        this.log.info("Stopped");
    }

    public YdtBuilder getYdtBuilder(String logicalRootName, String rootNamespace, YmsOperationType opType) {
        return new YangRequestWorkBench(logicalRootName, rootNamespace, opType, this.schemaRegistry, true);
    }

    public YdtBuilder getYdtBuilder(String logicalRootName, String rootNamespace, YmsOperationType opType, Object schemaRegistryForYdt) {
        if (schemaRegistryForYdt != null) {
            return new YangRequestWorkBench(logicalRootName, rootNamespace, opType, (YangSchemaRegistry)schemaRegistryForYdt, false);
        }
        return new YangRequestWorkBench(logicalRootName, rootNamespace, opType, this.schemaRegistry, true);
    }

    public YdtWalker getYdtWalker() {
        return new DefaultYdtWalker();
    }

    public YdtResponse executeOperation(YdtBuilder operationRequest) {
        YangApplicationBroker requestBroker = new YangApplicationBroker(this.schemaRegistry);
        switch (operationRequest.getYmsOperationType()) {
            case EDIT_CONFIG_REQUEST: {
                try {
                    return requestBroker.processEdit(operationRequest);
                }
                catch (CloneNotSupportedException e) {
                    this.log.error("YAB: failed to process edit request.");
                }
            }
            case QUERY_CONFIG_REQUEST: 
            case QUERY_REQUEST: {
                return requestBroker.processQuery(operationRequest);
            }
            case RPC_REQUEST: {
                return requestBroker.processOperation(operationRequest);
            }
        }
        return null;
    }

    public YangNotificationService getYangNotificationService() {
        return this.ynhExtendedService;
    }

    public YangModuleLibrary getYangModuleLibrary() {
        return this.library;
    }

    public String getYangFile(YangModuleIdentifier moduleIdentifier) {
        return this.schemaRegistry.getYangFile(moduleIdentifier);
    }

    public void registerDefaultCodec(YangDataTreeCodec defaultCodec, YangProtocolEncodingFormat dataFormat) {
        YangCodecRegistry.registerDefaultCodec(defaultCodec, dataFormat);
    }

    public void registerService(Object manager, Class<?> service, List<String> features) {
        this.executor.execute(() -> {
            this.schemaRegistry.registerApplication(manager, service);
            this.processNotificationRegistration(manager, service);
            this.schemaRegistry.processModuleLibrary(service.getName(), this.library);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNotificationRegistration(Object manager, Class<?> service) {
        Class<?> clazz = service;
        synchronized (clazz) {
            if (manager != null && manager instanceof ListenerService && this.schemaRegistry.verifyNotificationObject(manager, service)) {
                this.ynhExtendedService.registerAsListener((ListenerService)manager);
            }
        }
    }

    public void unRegisterService(Object appManager, Class<?> yangService) {
        this.schemaRegistry.unRegisterApplication(appManager, yangService);
    }

    public YangCodecHandler getYangCodecHandler() {
        DefaultYangSchemaRegistry registry = new DefaultYangSchemaRegistry();
        DefaultYangCodecHandler handler = new DefaultYangCodecHandler(registry);
        handler.setLibrary(new DefaultYangModuleLibrary(this.getNewModuleId()));
        return handler;
    }

    public YangSchemaRegistry getSchemaRegistry() {
        return this.schemaRegistry;
    }

    private String getNewModuleId() {
        return String.valueOf(this.moduleIdGenerator.getNewId());
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }
}

