/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgp.controller;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.protocol.linkstate.BgpLinkLsNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.BgpNodeLSNlriVer4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BgpDpid {
    private static final Logger log = LoggerFactory.getLogger(BgpDpid.class);
    private static final String SCHEME = "bgp";
    private static final long UNKNOWN = 0L;
    private StringBuilder stringBuilder = new StringBuilder("bgpls://");
    public static final int NODE_DESCRIPTOR_LOCAL = 1;
    public static final int NODE_DESCRIPTOR_REMOTE = 2;

    public BgpDpid(BgpLinkLsNlriVer4 linkNlri, int nodeDescriptorType) {
        if (linkNlri.getRouteDistinguisher() != null) {
            this.stringBuilder.append(linkNlri.getRouteDistinguisher().getRouteDistinguisher()).append(':');
        }
        try {
            this.stringBuilder.append(linkNlri.getProtocolId()).append(':').append(linkNlri.getIdentifier()).append('/');
            if (nodeDescriptorType == 1) {
                this.add(linkNlri.localNodeDescriptors());
            } else if (nodeDescriptorType == 2) {
                this.add(linkNlri.remoteNodeDescriptors());
            }
        }
        catch (BgpParseException e) {
            log.info("Exception BgpId string: " + e.toString());
        }
    }

    public BgpDpid(BgpNodeLSNlriVer4 nodeNlri) {
        if (nodeNlri.getRouteDistinguisher() != null) {
            this.stringBuilder.append(nodeNlri.getRouteDistinguisher().getRouteDistinguisher()).append(':');
        }
        try {
            this.stringBuilder.append(nodeNlri.getProtocolId()).append(':').append(nodeNlri.getIdentifier()).append('/');
            this.add(nodeNlri.getLocalNodeDescriptors());
        }
        catch (BgpParseException e) {
            log.info("Exception node string: " + e.toString());
        }
    }

    BgpDpid add(Object value) {
        if (value != null) {
            this.stringBuilder.append('&').append('=').append(value.toString());
        }
        return this;
    }

    public String toString() {
        return this.stringBuilder.toString();
    }

    public static URI uri(String value) {
        try {
            return new URI(SCHEME, value, null);
        }
        catch (URISyntaxException e) {
            log.info("Exception BgpId URI: " + e.toString());
            return null;
        }
    }

    public static BgpDpid bgpDpid(URI uri) {
        Preconditions.checkArgument((boolean)uri.getScheme().equals(SCHEME), (Object)"Unsupported URI scheme");
        return null;
    }
}

