/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgp.controller;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.onlab.packet.IpAddress;

public final class BgpId {
    private static final String SCHEME = "bgp";
    private static final long UNKNOWN = 0L;
    private final IpAddress ipAddress;

    public BgpId(IpAddress ipAddress) {
        this.ipAddress = ipAddress;
    }

    public static BgpId bgpId(IpAddress ipAddress) {
        return new BgpId(ipAddress);
    }

    public IpAddress ipAddress() {
        return this.ipAddress;
    }

    public String toString() {
        return this.ipAddress.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof BgpId)) {
            return false;
        }
        BgpId otherBGPid = (BgpId)other;
        return Objects.equals(this.ipAddress, otherBGPid.ipAddress);
    }

    public int hashCode() {
        return Objects.hash(this.ipAddress);
    }

    public static BgpId bgpId(URI uri) {
        Preconditions.checkArgument((boolean)uri.getScheme().equals(SCHEME), (Object)"Unsupported URI scheme");
        return new BgpId(IpAddress.valueOf((String)uri.getSchemeSpecificPart()));
    }

    public static URI uri(BgpId bgpId) {
        return BgpId.uri(bgpId.ipAddress());
    }

    public static URI uri(IpAddress ipAddress) {
        try {
            return new URI(SCHEME, ipAddress.toString(), null);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }
}

