/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgp.controller;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.ListIterator;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.protocol.linkstate.BgpLinkLsNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.BgpNodeLSIdentifier;
import org.onosproject.bgpio.protocol.linkstate.BgpNodeLSNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.NodeDescriptors;
import org.onosproject.bgpio.types.AreaIDTlv;
import org.onosproject.bgpio.types.AutonomousSystemTlv;
import org.onosproject.bgpio.types.BgpLSIdentifierTlv;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.types.IsIsNonPseudonode;
import org.onosproject.bgpio.types.IsIsPseudonode;
import org.onosproject.bgpio.types.OspfNonPseudonode;
import org.onosproject.bgpio.types.OspfPseudonode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BgpDpid {
    private static final Logger log = LoggerFactory.getLogger(BgpDpid.class);
    private static final String SCHEME = "bgp";
    private static final long UNKNOWN = 0L;
    private StringBuilder stringBuilder = new StringBuilder("");
    public static final int NODE_DESCRIPTOR_LOCAL = 1;
    public static final int NODE_DESCRIPTOR_REMOTE = 2;

    public BgpDpid(BgpLinkLsNlriVer4 linkNlri, int nodeDescriptorType) {
        if (linkNlri.getRouteDistinguisher() != null) {
            this.stringBuilder.append("RD=").append(linkNlri.getRouteDistinguisher().getRouteDistinguisher()).append(":");
        }
        try {
            if (linkNlri.getProtocolId() == BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_ONE || linkNlri.getProtocolId() == BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_TWO) {
                this.stringBuilder.append("PROTO=").append("ISIS").append(":ID=").append(linkNlri.getIdentifier());
            } else {
                this.stringBuilder.append("PROTO=").append(linkNlri.getProtocolId()).append(":ID=").append(linkNlri.getIdentifier());
            }
            if (nodeDescriptorType == 1) {
                this.add(linkNlri.localNodeDescriptors());
            } else if (nodeDescriptorType == 2) {
                this.add(linkNlri.remoteNodeDescriptors());
            }
        }
        catch (BgpParseException e) {
            log.info("Exception BgpId string: " + e.toString());
        }
    }

    private String isoNodeIdString(byte[] isoNodeId) {
        if (isoNodeId != null) {
            return String.format("%02x%02x.%02x%02x.%02x%02x", isoNodeId[0], isoNodeId[1], isoNodeId[2], isoNodeId[3], isoNodeId[4], isoNodeId[5]);
        }
        return null;
    }

    public BgpDpid(BgpNodeLSNlriVer4 nodeNlri) {
        if (nodeNlri.getRouteDistinguisher() != null) {
            this.stringBuilder.append("RD=").append(nodeNlri.getRouteDistinguisher().getRouteDistinguisher()).append(":");
        }
        try {
            if (nodeNlri.getProtocolId() == BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_ONE || nodeNlri.getProtocolId() == BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_TWO) {
                this.stringBuilder.append("PROTO=").append("ISIS").append(":ID=").append(nodeNlri.getIdentifier());
            } else {
                this.stringBuilder.append("PROTO=").append(nodeNlri.getProtocolId()).append(":ID=").append(nodeNlri.getIdentifier());
            }
            this.add(nodeNlri.getLocalNodeDescriptors());
        }
        catch (BgpParseException e) {
            log.info("Exception node string: " + e.toString());
        }
    }

    BgpDpid add(Object value) {
        NodeDescriptors nodeDescriptors = null;
        if (value instanceof BgpNodeLSIdentifier) {
            BgpNodeLSIdentifier nodeLsIdentifier = (BgpNodeLSIdentifier)value;
            nodeDescriptors = nodeLsIdentifier.getNodedescriptors();
        } else if (value instanceof NodeDescriptors) {
            nodeDescriptors = (NodeDescriptors)value;
        }
        if (nodeDescriptors != null) {
            List subTlvs = nodeDescriptors.getSubTlvs();
            ListIterator listIterator = subTlvs.listIterator();
            while (listIterator.hasNext()) {
                BgpValueType tlv = (BgpValueType)listIterator.next();
                if (tlv.getType() == 512) {
                    AutonomousSystemTlv autonomousSystem = (AutonomousSystemTlv)tlv;
                    this.stringBuilder.append(":AS=").append(autonomousSystem.getAsNum());
                    continue;
                }
                if (tlv.getType() == 513) {
                    BgpLSIdentifierTlv lsIdentifierTlv = (BgpLSIdentifierTlv)tlv;
                    this.stringBuilder.append(":LSID=").append(lsIdentifierTlv.getBgpLsIdentifier());
                    continue;
                }
                if (tlv.getType() == 514) {
                    AreaIDTlv areaIdTlv = (AreaIDTlv)tlv;
                    this.stringBuilder.append(":AREA=").append(areaIdTlv.getAreaID());
                    continue;
                }
                if (tlv.getType() != 515) continue;
                if (tlv instanceof IsIsNonPseudonode) {
                    IsIsNonPseudonode isisNonPseudonode = (IsIsNonPseudonode)tlv;
                    this.stringBuilder.append(":ISOID=").append(this.isoNodeIdString(isisNonPseudonode.getIsoNodeId()));
                    continue;
                }
                if (tlv instanceof IsIsPseudonode) {
                    IsIsPseudonode isisPseudonode = (IsIsPseudonode)tlv;
                    this.stringBuilder.append(":ISOID=").append(this.isoNodeIdString(isisPseudonode.getIsoNodeId()));
                    this.stringBuilder.append(":PSN=").append(isisPseudonode.getPsnIdentifier());
                    continue;
                }
                if (tlv instanceof OspfNonPseudonode) {
                    OspfNonPseudonode ospfNonPseudonode = (OspfNonPseudonode)tlv;
                    this.stringBuilder.append(":RID=").append(ospfNonPseudonode.getrouterID());
                    continue;
                }
                if (!(tlv instanceof OspfPseudonode)) continue;
                OspfPseudonode ospfPseudonode = (OspfPseudonode)tlv;
                this.stringBuilder.append(":RID=").append(ospfPseudonode.getrouterID());
            }
        }
        return this;
    }

    public String toString() {
        return this.stringBuilder.toString();
    }

    public static URI uri(String value) {
        try {
            return new URI(SCHEME, value, null);
        }
        catch (URISyntaxException e) {
            log.info("Exception BgpId URI: " + e.toString());
            return null;
        }
    }

    public static BgpDpid bgpDpid(URI uri) {
        Preconditions.checkArgument((boolean)uri.getScheme().equals(SCHEME), (Object)"Unsupported URI scheme");
        return null;
    }
}

