/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgp;

import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.LinkedList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.junit.TestUtils;
import org.onosproject.bgp.BgpPeerChannelHandlerTest;
import org.onosproject.bgp.BgpPeerFrameDecoderTest;
import org.onosproject.bgp.controller.BgpCfg;
import org.onosproject.bgp.controller.impl.BgpControllerImpl;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.types.FourOctetAsNumCapabilityTlv;
import org.onosproject.bgpio.types.MultiProtocolExtnCapabilityTlv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpControllerImplTest {
    protected static final Logger log = LoggerFactory.getLogger(BgpControllerImplTest.class);
    private static final String IP_LOOPBACK_ID1 = "127.0.0.1";
    private static final int MESSAGE_TIMEOUT_MS = 3000;
    public byte version;
    public short asNumber;
    public short holdTime;
    public int bgpId = InetAddresses.coerceToInteger((InetAddress)InetAddresses.forString((String)"127.0.0.1"));
    public boolean isLargeAsCapabilitySet = false;
    public LinkedList<BgpValueType> capabilityTlv = new LinkedList();
    private BgpControllerImpl bgpControllerImpl;
    BgpPeerTest peer1;
    private InetSocketAddress connectToSocket;

    @Before
    public void setUp() throws Exception {
        this.peer1 = new BgpPeerTest(this.version, this.asNumber, this.holdTime, this.bgpId, this.isLargeAsCapabilitySet, this.capabilityTlv);
        this.bgpControllerImpl = new BgpControllerImpl();
        this.bgpControllerImpl.controller().setBgpPortNum();
        this.bgpControllerImpl.activate();
        Channel serverChannel = (Channel)TestUtils.getField((Object)this.bgpControllerImpl.controller(), (String)"serverChannel");
        SocketAddress socketAddress = serverChannel.getLocalAddress();
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        InetAddress connectToAddress = InetAddresses.forString((String)IP_LOOPBACK_ID1);
        this.connectToSocket = new InetSocketAddress(connectToAddress, inetSocketAddress.getPort());
        this.bgpControllerImpl.getConfig().setRouterId("1.1.1.1");
        this.bgpControllerImpl.getConfig().setAsNumber(200);
        this.bgpControllerImpl.getConfig().setHoldTime((short)120);
        this.bgpControllerImpl.getConfig().setState(BgpCfg.State.IP_AS_CONFIGURED);
        this.bgpControllerImpl.getConfig().addPeer(IP_LOOPBACK_ID1, 200);
    }

    @After
    public void tearDown() throws Exception {
        this.bgpControllerImpl.deactivate();
        this.bgpControllerImpl = null;
    }

    @Test
    public void bgpOpenMessageTest1() throws InterruptedException {
        short afi = 16388;
        byte res = 0;
        byte safi = 71;
        ((BgpPeerTest)this.peer1).peerChannelHandler.asNumber = (short)200;
        ((BgpPeerTest)this.peer1).peerChannelHandler.version = (byte)4;
        ((BgpPeerTest)this.peer1).peerChannelHandler.holdTime = (short)120;
        this.bgpControllerImpl.getConfig().setLsCapability(true);
        MultiProtocolExtnCapabilityTlv tempTlv1 = new MultiProtocolExtnCapabilityTlv(afi, res, safi);
        ((BgpPeerTest)this.peer1).peerChannelHandler.capabilityTlv.add((BgpValueType)tempTlv1);
        this.peer1.connect(this.connectToSocket);
        boolean result = ((BgpPeerTest)this.peer1).peerFrameDecoder.receivedOpenMessageLatch.await(3000L, TimeUnit.MILLISECONDS);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)true));
        result = ((BgpPeerTest)this.peer1).peerFrameDecoder.receivedKeepaliveMessageLatch.await(3000L, TimeUnit.MILLISECONDS);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)true));
    }

    @Test
    public void bgpOpenMessageTest2() throws InterruptedException {
        short afi = 16388;
        byte res = 0;
        byte safi = 71;
        ((BgpPeerTest)this.peer1).peerChannelHandler.asNumber = (short)500;
        ((BgpPeerTest)this.peer1).peerChannelHandler.version = (byte)4;
        ((BgpPeerTest)this.peer1).peerChannelHandler.holdTime = (short)120;
        this.bgpControllerImpl.getConfig().setLsCapability(true);
        MultiProtocolExtnCapabilityTlv tempTlv1 = new MultiProtocolExtnCapabilityTlv(afi, res, safi);
        ((BgpPeerTest)this.peer1).peerChannelHandler.capabilityTlv.add((BgpValueType)tempTlv1);
        this.peer1.connect(this.connectToSocket);
        boolean result = ((BgpPeerTest)this.peer1).peerFrameDecoder.receivedOpenMessageLatch.await(3000L, TimeUnit.MILLISECONDS);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)true));
        result = ((BgpPeerTest)this.peer1).peerFrameDecoder.receivedKeepaliveMessageLatch.await(3000L, TimeUnit.MILLISECONDS);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)true));
        result = ((BgpPeerTest)this.peer1).peerFrameDecoder.receivedNotificationMessageLatch.await(3000L, TimeUnit.MILLISECONDS);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)false));
    }

    @Test
    public void bgpOpenMessageTest3() throws InterruptedException {
        ((BgpPeerTest)this.peer1).peerChannelHandler.asNumber = (short)200;
        ((BgpPeerTest)this.peer1).peerChannelHandler.version = (byte)4;
        ((BgpPeerTest)this.peer1).peerChannelHandler.holdTime = 1;
        this.peer1.connect(this.connectToSocket);
        boolean result = ((BgpPeerTest)this.peer1).peerFrameDecoder.receivedNotificationMessageLatch.await(3000L, TimeUnit.MILLISECONDS);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)true));
    }

    @Test
    public void bgpOpenMessageTest4() throws InterruptedException {
        ((BgpPeerTest)this.peer1).peerChannelHandler.asNumber = (short)200;
        ((BgpPeerTest)this.peer1).peerChannelHandler.version = (byte)4;
        ((BgpPeerTest)this.peer1).peerChannelHandler.holdTime = (short)120;
        ((BgpPeerTest)this.peer1).peerChannelHandler.isLargeAsCapabilitySet = true;
        FourOctetAsNumCapabilityTlv tempTlv = new FourOctetAsNumCapabilityTlv(766545);
        ((BgpPeerTest)this.peer1).peerChannelHandler.capabilityTlv.add((BgpValueType)tempTlv);
        this.peer1.connect(this.connectToSocket);
        boolean result = ((BgpPeerTest)this.peer1).peerFrameDecoder.receivedNotificationMessageLatch.await(3000L, TimeUnit.MILLISECONDS);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)true));
    }

    @Test
    public void bgpOpenMessageTest5() throws InterruptedException {
        short afi = 16388;
        byte res = 0;
        byte safi = 71;
        ((BgpPeerTest)this.peer1).peerChannelHandler.asNumber = (short)200;
        ((BgpPeerTest)this.peer1).peerChannelHandler.version = (byte)4;
        ((BgpPeerTest)this.peer1).peerChannelHandler.holdTime = (short)120;
        this.bgpControllerImpl.getConfig().setLsCapability(true);
        MultiProtocolExtnCapabilityTlv tempTlv1 = new MultiProtocolExtnCapabilityTlv(afi, res, safi);
        ((BgpPeerTest)this.peer1).peerChannelHandler.capabilityTlv.add((BgpValueType)tempTlv1);
        this.peer1.connect(this.connectToSocket);
        boolean result = ((BgpPeerTest)this.peer1).peerFrameDecoder.receivedOpenMessageLatch.await(3000L, TimeUnit.MILLISECONDS);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)true));
        result = ((BgpPeerTest)this.peer1).peerFrameDecoder.receivedKeepaliveMessageLatch.await(3000L, TimeUnit.MILLISECONDS);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)true));
    }

    @Test
    public void bgpOpenMessageTest6() throws InterruptedException {
        short afi = 16388;
        byte res = 0;
        byte safi = 71;
        ((BgpPeerTest)this.peer1).peerChannelHandler.asNumber = (short)200;
        ((BgpPeerTest)this.peer1).peerChannelHandler.version = (byte)4;
        ((BgpPeerTest)this.peer1).peerChannelHandler.holdTime = (short)120;
        ((BgpPeerTest)this.peer1).peerChannelHandler.isLargeAsCapabilitySet = true;
        this.bgpControllerImpl.getConfig().setLargeASCapability(true);
        FourOctetAsNumCapabilityTlv tempTlv = new FourOctetAsNumCapabilityTlv(200);
        ((BgpPeerTest)this.peer1).peerChannelHandler.capabilityTlv.add((BgpValueType)tempTlv);
        this.bgpControllerImpl.getConfig().setLsCapability(true);
        MultiProtocolExtnCapabilityTlv tempTlv1 = new MultiProtocolExtnCapabilityTlv(afi, res, safi);
        ((BgpPeerTest)this.peer1).peerChannelHandler.capabilityTlv.add((BgpValueType)tempTlv1);
        this.peer1.connect(this.connectToSocket);
        boolean result = ((BgpPeerTest)this.peer1).peerFrameDecoder.receivedOpenMessageLatch.await(3000L, TimeUnit.MILLISECONDS);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)true));
        result = ((BgpPeerTest)this.peer1).peerFrameDecoder.receivedKeepaliveMessageLatch.await(3000L, TimeUnit.MILLISECONDS);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)true));
        result = ((BgpPeerTest)this.peer1).peerFrameDecoder.receivedKeepaliveMessageLatch.await(3000L, TimeUnit.MILLISECONDS);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)true));
    }

    @Test
    public void bgpOpenMessageTest7() throws InterruptedException {
        short afi = 16388;
        byte res = 0;
        byte safi = 71;
        ((BgpPeerTest)this.peer1).peerChannelHandler.asNumber = (short)200;
        ((BgpPeerTest)this.peer1).peerChannelHandler.version = (byte)4;
        ((BgpPeerTest)this.peer1).peerChannelHandler.holdTime = (short)120;
        ((BgpPeerTest)this.peer1).peerChannelHandler.isLargeAsCapabilitySet = true;
        this.bgpControllerImpl.getConfig().setLargeASCapability(true);
        FourOctetAsNumCapabilityTlv tempTlv = new FourOctetAsNumCapabilityTlv(200);
        ((BgpPeerTest)this.peer1).peerChannelHandler.capabilityTlv.add((BgpValueType)tempTlv);
        this.bgpControllerImpl.getConfig().setLsCapability(true);
        MultiProtocolExtnCapabilityTlv tempTlv1 = new MultiProtocolExtnCapabilityTlv(afi, res, safi);
        ((BgpPeerTest)this.peer1).peerChannelHandler.capabilityTlv.add((BgpValueType)tempTlv1);
        this.peer1.connect(this.connectToSocket);
        boolean result = ((BgpPeerTest)this.peer1).peerFrameDecoder.receivedOpenMessageLatch.await(3000L, TimeUnit.MILLISECONDS);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)true));
    }

    private final class BgpPeerTest {
        private ClientBootstrap peerBootstrap;
        private BgpPeerFrameDecoderTest peerFrameDecoder = new BgpPeerFrameDecoderTest();
        private BgpPeerChannelHandlerTest peerChannelHandler;

        private BgpPeerTest(byte version, short asNumber, short holdTime, int bgpId, boolean isLargeAsCapabilitySet, LinkedList<BgpValueType> capabilityTlv) {
            this.peerChannelHandler = new BgpPeerChannelHandlerTest(version, asNumber, holdTime, bgpId, isLargeAsCapabilitySet, capabilityTlv);
        }

        private void connect(InetSocketAddress connectToSocket) throws InterruptedException {
            NioClientSocketChannelFactory channelFactory = new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
            ChannelPipelineFactory pipelineFactory = () -> {
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast("BgpPeerFrameDecoderTest", (ChannelHandler)this.peerFrameDecoder);
                pipeline.addLast("BgpPeerChannelHandlerTest", (ChannelHandler)this.peerChannelHandler);
                return pipeline;
            };
            this.peerBootstrap = new ClientBootstrap((ChannelFactory)channelFactory);
            this.peerBootstrap.setOption("child.keepAlive", (Object)true);
            this.peerBootstrap.setOption("child.tcpNoDelay", (Object)true);
            this.peerBootstrap.setPipelineFactory(pipelineFactory);
            this.peerBootstrap.connect((SocketAddress)connectToSocket);
        }
    }
}

