/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgp;

import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.onosproject.bgpio.protocol.ver4.BgpKeepaliveMsgVer4;
import org.onosproject.bgpio.protocol.ver4.BgpOpenMsgVer4;
import org.onosproject.bgpio.types.BgpHeader;
import org.onosproject.bgpio.types.BgpValueType;

public class BgpPeerChannelHandlerTest
extends SimpleChannelHandler {
    public static final int OPEN_MSG_MINIMUM_LENGTH = 29;
    public static final byte[] MARKER = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    public static final BgpHeader DEFAULT_OPEN_HEADER = new BgpHeader(MARKER, 29, 1);
    LinkedList<BgpValueType> capabilityTlv = new LinkedList();
    public byte version;
    public short asNumber;
    public short holdTime;
    public int bgpId;
    public boolean isLargeAsCapabilitySet;
    final BgpOpenMsgVer4 openMessage = new BgpOpenMsgVer4();
    ChannelHandlerContext savedCtx;

    public BgpPeerChannelHandlerTest(byte version, short asNumber, short holdTime, int bgpId, boolean isLargeAsCapabilitySet, LinkedList<BgpValueType> capabilityTlv) {
        this.version = version;
        this.asNumber = asNumber;
        this.holdTime = holdTime;
        this.bgpId = bgpId;
        this.isLargeAsCapabilitySet = isLargeAsCapabilitySet;
        this.capabilityTlv = capabilityTlv;
    }

    void closeChannel() {
        this.savedCtx.getChannel().close();
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent channelEvent) throws InterruptedException {
        this.savedCtx = ctx;
        BgpOpenMsgVer4 openMsg = new BgpOpenMsgVer4(DEFAULT_OPEN_HEADER, this.version, this.asNumber, this.holdTime, this.bgpId, this.capabilityTlv);
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        openMsg.writeTo(buffer);
        ctx.getChannel().write((Object)buffer);
        TimeUnit.MILLISECONDS.sleep(100L);
        BgpKeepaliveMsgVer4 keepaliveMsg = new BgpKeepaliveMsgVer4();
        ChannelBuffer buffer1 = ChannelBuffers.dynamicBuffer();
        keepaliveMsg.writeTo(buffer1);
        ctx.getChannel().write((Object)buffer1);
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent channelEvent) {
    }
}

