/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgp;

import java.util.concurrent.CountDownLatch;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpPeerFrameDecoderTest
extends FrameDecoder {
    static final byte OPEN_MSG_TYPE = 1;
    static final byte KEEPALIVE_MSG_TYPE = 4;
    static final byte UPDATE_MSG_TYPE = 2;
    static final byte NOTIFICATION_MSG_TYPE = 3;
    static final int MINIMUM_COMMON_HEADER_LENGTH = 19;
    static final int MINIMUM_OPEN_MSG_LENGTH = 29;
    static final int MINIMUM_HEADER_MARKER_LENGTH = 16;
    static final int HEADER_AND_MSG_LEN = 18;
    protected static final Logger log = LoggerFactory.getLogger(BgpPeerFrameDecoderTest.class);
    final CountDownLatch receivedOpenMessageLatch = new CountDownLatch(1);
    final CountDownLatch receivedKeepaliveMessageLatch = new CountDownLatch(1);
    final CountDownLatch receivedNotificationMessageLatch = new CountDownLatch(1);

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer cb) throws Exception {
        if (cb.readableBytes() < 19) {
            log.debug("Error: Packet length is less then minimum length");
            return null;
        }
        byte[] marker = new byte[16];
        cb.readBytes(marker);
        for (int i = 0; i < marker.length; ++i) {
            if (marker[i] == -1) continue;
            log.debug("Error: Marker must be set all ones");
            ctx.getChannel().close();
            return null;
        }
        short length = cb.readShort();
        if (length < 19) {
            log.debug("Error: Bad message length");
            ctx.getChannel().close();
            return null;
        }
        if (length != cb.readableBytes() + 18) {
            log.debug("Error: Bad message length");
            ctx.getChannel().close();
            return null;
        }
        byte type = cb.readByte();
        int len = length - 19;
        ChannelBuffer message = cb.readBytes(len);
        switch (type) {
            case 1: {
                this.processBgpOpen(ctx, message);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.processBgpNotification(ctx, message);
                break;
            }
            case 4: {
                this.processBgpKeepalive(ctx, message);
                break;
            }
            default: {
                ctx.getChannel().close();
                return null;
            }
        }
        return null;
    }

    private void processBgpOpen(ChannelHandlerContext ctx, ChannelBuffer message) {
        int minLength = 10;
        if (message.readableBytes() < minLength) {
            log.debug("Error: Bad message length");
            ctx.getChannel().close();
            return;
        }
        message.readByte();
        message.readShort();
        message.readShort();
        message.readInt();
        short optParamLen = message.readUnsignedByte();
        if (message.readableBytes() < optParamLen) {
            log.debug("Error: Bad message length");
            ctx.getChannel().close();
            return;
        }
        message.readBytes((int)optParamLen);
        this.receivedOpenMessageLatch.countDown();
    }

    private void processBgpKeepalive(ChannelHandlerContext ctx, ChannelBuffer message) {
        this.receivedKeepaliveMessageLatch.countDown();
    }

    private void processBgpNotification(ChannelHandlerContext ctx, ChannelBuffer message) {
        message.readByte();
        message.readByte();
        if (message.readableBytes() > 0) {
            byte[] data = new byte[message.readableBytes()];
            message.readBytes(data, 0, message.readableBytes());
        }
        this.receivedNotificationMessageLatch.countDown();
    }
}

