/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgp.controller.impl;

import java.util.LinkedList;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.onlab.util.HexDump;
import org.onosproject.bgpio.protocol.BgpFactories;
import org.onosproject.bgpio.protocol.BgpMessage;
import org.onosproject.bgpio.protocol.BgpMessageReader;
import org.onosproject.bgpio.types.BgpHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpMessageDecoder
extends FrameDecoder {
    protected static final Logger log = LoggerFactory.getLogger(BgpMessageDecoder.class);

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        log.debug("MESSAGE IS RECEIVED.");
        if (!channel.isConnected()) {
            log.info("Channel is not connected.");
            return null;
        }
        HexDump.dump((ChannelBuffer)buffer);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        LinkedList<BgpMessage> msgList = new LinkedList<BgpMessage>();
        while (buffer.readableBytes() > 0) {
            BgpHeader bgpHeader = new BgpHeader();
            BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
            msgList.add(message);
        }
        return msgList;
    }
}

