/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgp.controller.impl;

import com.google.common.base.MoreObjects;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.RejectedExecutionException;
import org.jboss.netty.channel.Channel;
import org.onlab.packet.IpAddress;
import org.onosproject.bgp.controller.BgpController;
import org.onosproject.bgp.controller.BgpLocalRib;
import org.onosproject.bgp.controller.BgpPeer;
import org.onosproject.bgp.controller.BgpSessionInfo;
import org.onosproject.bgp.controller.impl.AdjRibIn;
import org.onosproject.bgp.controller.impl.BgpLocalRibImpl;
import org.onosproject.bgp.controller.impl.BgpPacketStatsImpl;
import org.onosproject.bgp.controller.impl.VpnAdjRibIn;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.protocol.BgpFactories;
import org.onosproject.bgpio.protocol.BgpFactory;
import org.onosproject.bgpio.protocol.BgpLSNlri;
import org.onosproject.bgpio.protocol.BgpMessage;
import org.onosproject.bgpio.protocol.BgpVersion;
import org.onosproject.bgpio.protocol.linkstate.BgpLinkLsNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.BgpNodeLSNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.BgpPrefixIPv4LSNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.PathAttrNlriDetails;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.types.MpReachNlri;
import org.onosproject.bgpio.types.MpUnReachNlri;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpPeerImpl
implements BgpPeer {
    protected final Logger log = LoggerFactory.getLogger(BgpPeerImpl.class);
    private static final String SHUTDOWN_MSG = "Worker has already been shutdown";
    private BgpController bgpController;
    private Channel channel;
    protected String channelId;
    private boolean connected;
    protected boolean isHandShakeComplete = false;
    private BgpSessionInfo sessionInfo;
    private BgpPacketStatsImpl pktStats;
    private BgpLocalRib bgplocalRIB;
    private BgpLocalRib bgplocalRIBVpn;
    private AdjRibIn adjRib;
    private VpnAdjRibIn vpnAdjRib;

    public AdjRibIn adjacencyRib() {
        return this.adjRib;
    }

    public VpnAdjRibIn vpnAdjacencyRib() {
        return this.vpnAdjRib;
    }

    public BgpSessionInfo sessionInfo() {
        return this.sessionInfo;
    }

    public BgpPeerImpl(BgpController bgpController, BgpSessionInfo sessionInfo, BgpPacketStatsImpl pktStats) {
        this.bgpController = bgpController;
        this.sessionInfo = sessionInfo;
        this.pktStats = pktStats;
        this.bgplocalRIB = bgpController.bgpLocalRib();
        this.bgplocalRIBVpn = bgpController.bgpLocalRibVpn();
        this.adjRib = new AdjRibIn();
        this.vpnAdjRib = new VpnAdjRibIn();
    }

    public void buildAdjRibIn(List<BgpValueType> pathAttr) throws BgpParseException {
        ListIterator<BgpValueType> iterator = pathAttr.listIterator();
        while (iterator.hasNext()) {
            List nlri;
            BgpValueType attr = iterator.next();
            if (attr instanceof MpReachNlri) {
                nlri = ((MpReachNlri)attr).mpReachNlri();
                this.callAdd(this, nlri, pathAttr);
            }
            if (!(attr instanceof MpUnReachNlri)) continue;
            nlri = ((MpUnReachNlri)attr).mpUnReachNlri();
            this.callRemove(this, nlri);
        }
    }

    public void callAdd(BgpPeerImpl peerImpl, List<BgpLSNlri> nlri, List<BgpValueType> pathAttr) throws BgpParseException {
        ListIterator<BgpLSNlri> listIterator = nlri.listIterator();
        while (listIterator.hasNext()) {
            PathAttrNlriDetails details;
            BgpLSNlri nlriInfo = listIterator.next();
            if (nlriInfo instanceof BgpNodeLSNlriVer4) {
                details = this.setPathAttrDetails(nlriInfo, pathAttr);
                if (!((BgpNodeLSNlriVer4)nlriInfo).isVpnPresent()) {
                    this.adjRib.add(nlriInfo, details);
                    this.bgplocalRIB.add(this.sessionInfo(), nlriInfo, details);
                    continue;
                }
                this.vpnAdjRib.addVpn(nlriInfo, details, ((BgpNodeLSNlriVer4)nlriInfo).getRouteDistinguisher());
                this.bgplocalRIBVpn.add(this.sessionInfo(), nlriInfo, details, ((BgpNodeLSNlriVer4)nlriInfo).getRouteDistinguisher());
                continue;
            }
            if (nlriInfo instanceof BgpLinkLsNlriVer4) {
                details = this.setPathAttrDetails(nlriInfo, pathAttr);
                if (!((BgpLinkLsNlriVer4)nlriInfo).isVpnPresent()) {
                    this.adjRib.add(nlriInfo, details);
                    this.bgplocalRIB.add(this.sessionInfo(), nlriInfo, details);
                    continue;
                }
                this.vpnAdjRib.addVpn(nlriInfo, details, ((BgpLinkLsNlriVer4)nlriInfo).getRouteDistinguisher());
                this.bgplocalRIBVpn.add(this.sessionInfo(), nlriInfo, details, ((BgpLinkLsNlriVer4)nlriInfo).getRouteDistinguisher());
                continue;
            }
            if (!(nlriInfo instanceof BgpPrefixIPv4LSNlriVer4)) continue;
            details = this.setPathAttrDetails(nlriInfo, pathAttr);
            if (!((BgpPrefixIPv4LSNlriVer4)nlriInfo).isVpnPresent()) {
                this.adjRib.add(nlriInfo, details);
                this.bgplocalRIB.add(this.sessionInfo(), nlriInfo, details);
                continue;
            }
            this.vpnAdjRib.addVpn(nlriInfo, details, ((BgpPrefixIPv4LSNlriVer4)nlriInfo).getRouteDistinguisher());
            this.bgplocalRIBVpn.add(this.sessionInfo(), nlriInfo, details, ((BgpPrefixIPv4LSNlriVer4)nlriInfo).getRouteDistinguisher());
        }
    }

    public PathAttrNlriDetails setPathAttrDetails(BgpLSNlri nlriInfo, List<BgpValueType> pathAttr) throws BgpParseException {
        PathAttrNlriDetails details = new PathAttrNlriDetails();
        details.setProtocolID(nlriInfo.getProtocolId());
        details.setIdentifier(nlriInfo.getIdentifier());
        details.setPathAttribute(pathAttr);
        return details;
    }

    public void callRemove(BgpPeerImpl peerImpl, List<BgpLSNlri> nlri) {
        ListIterator<BgpLSNlri> listIterator = nlri.listIterator();
        while (listIterator.hasNext()) {
            BgpLSNlri nlriInfo = listIterator.next();
            if (nlriInfo instanceof BgpNodeLSNlriVer4) {
                if (!((BgpNodeLSNlriVer4)nlriInfo).isVpnPresent()) {
                    this.adjRib.remove(nlriInfo);
                    this.bgplocalRIB.delete(nlriInfo);
                    continue;
                }
                this.vpnAdjRib.removeVpn(nlriInfo, ((BgpNodeLSNlriVer4)nlriInfo).getRouteDistinguisher());
                this.bgplocalRIBVpn.delete(nlriInfo, ((BgpNodeLSNlriVer4)nlriInfo).getRouteDistinguisher());
                continue;
            }
            if (nlriInfo instanceof BgpLinkLsNlriVer4) {
                if (!((BgpLinkLsNlriVer4)nlriInfo).isVpnPresent()) {
                    this.adjRib.remove(nlriInfo);
                    this.bgplocalRIB.delete(nlriInfo);
                    continue;
                }
                this.vpnAdjRib.removeVpn(nlriInfo, ((BgpLinkLsNlriVer4)nlriInfo).getRouteDistinguisher());
                this.bgplocalRIBVpn.delete(nlriInfo, ((BgpLinkLsNlriVer4)nlriInfo).getRouteDistinguisher());
                continue;
            }
            if (!(nlriInfo instanceof BgpPrefixIPv4LSNlriVer4)) continue;
            if (!((BgpPrefixIPv4LSNlriVer4)nlriInfo).isVpnPresent()) {
                this.adjRib.remove(nlriInfo);
                this.bgplocalRIB.delete(nlriInfo);
                continue;
            }
            this.vpnAdjRib.removeVpn(nlriInfo, ((BgpPrefixIPv4LSNlriVer4)nlriInfo).getRouteDistinguisher());
            this.bgplocalRIBVpn.delete(nlriInfo, ((BgpPrefixIPv4LSNlriVer4)nlriInfo).getRouteDistinguisher());
        }
    }

    public AdjRibIn adjRib() {
        return this.adjRib;
    }

    public VpnAdjRibIn vpnAdjRib() {
        return this.vpnAdjRib;
    }

    public void updateLocalRIBOnPeerDisconnect() {
        BgpLocalRibImpl localRib = (BgpLocalRibImpl)this.bgplocalRIB;
        BgpLocalRibImpl localRibVpn = (BgpLocalRibImpl)this.bgplocalRIBVpn;
        localRib.localRIBUpdate(this.adjacencyRib());
        localRibVpn.localRIBUpdate(this.vpnAdjacencyRib());
    }

    public final void disconnectPeer() {
        this.channel.close();
    }

    public final void sendMessage(BgpMessage m) {
        block2: {
            this.log.debug("Sending message to {}", (Object)this.channel.getRemoteAddress());
            try {
                this.channel.write(Collections.singletonList(m));
                this.pktStats.addOutPacket();
            }
            catch (RejectedExecutionException e) {
                this.log.warn(e.getMessage());
                if (e.getMessage().contains(SHUTDOWN_MSG)) break block2;
                throw e;
            }
        }
    }

    public final void sendMessage(List<BgpMessage> msgs) {
        block2: {
            try {
                this.channel.write(msgs);
                this.pktStats.addOutPacket(msgs.size());
            }
            catch (RejectedExecutionException e) {
                this.log.warn(e.getMessage());
                if (e.getMessage().contains(SHUTDOWN_MSG)) break block2;
                throw e;
            }
        }
    }

    public final boolean isConnected() {
        return this.connected;
    }

    public final void setConnected(boolean connected) {
        this.connected = connected;
    }

    public final void setChannel(Channel channel) {
        this.channel = channel;
        SocketAddress address = channel.getRemoteAddress();
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetAddress = (InetSocketAddress)address;
            IpAddress ipAddress = IpAddress.valueOf((InetAddress)inetAddress.getAddress());
            this.channelId = ipAddress.isIp4() ? ipAddress.toString() + ':' + inetAddress.getPort() : '[' + ipAddress.toString() + "]:" + inetAddress.getPort();
        }
    }

    public final Channel getChannel() {
        return this.channel;
    }

    public String channelId() {
        return this.channelId;
    }

    public BgpFactory factory() {
        return BgpFactories.getFactory((BgpVersion)this.sessionInfo.remoteBgpVersion());
    }

    public boolean isHandshakeComplete() {
        return this.isHandShakeComplete;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("channel", (Object)this.channelId()).add("BgpId", (Object)this.sessionInfo().remoteBgpId()).toString();
    }
}

