/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgp.controller.impl;

import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.timeout.ReadTimeoutHandler;
import org.jboss.netty.util.ExternalResourceReleasable;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import org.onosproject.bgp.controller.BgpController;
import org.onosproject.bgp.controller.impl.BgpChannelHandler;
import org.onosproject.bgp.controller.impl.BgpMessageDecoder;
import org.onosproject.bgp.controller.impl.BgpMessageEncoder;

public class BgpPipelineFactory
implements ChannelPipelineFactory,
ExternalResourceReleasable {
    static final Timer TIMER = new HashedWheelTimer();
    protected ReadTimeoutHandler readTimeoutHandler;
    private boolean isBgpServ;
    private BgpController bgpController;

    public BgpPipelineFactory(BgpController bgpController, boolean isBgpServ) {
        this.isBgpServ = isBgpServ;
        this.bgpController = bgpController;
        this.readTimeoutHandler = new ReadTimeoutHandler(TIMER, (int)bgpController.getConfig().getHoldTime());
    }

    public ChannelPipeline getPipeline() throws Exception {
        BgpChannelHandler handler = new BgpChannelHandler(this.bgpController);
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("bgpmessagedecoder", (ChannelHandler)new BgpMessageDecoder());
        pipeline.addLast("bgpmessageencoder", (ChannelHandler)new BgpMessageEncoder());
        pipeline.addLast("holdTime", (ChannelHandler)this.readTimeoutHandler);
        if (this.isBgpServ) {
            pipeline.addLast("PassiveHandler", (ChannelHandler)handler);
        } else {
            pipeline.addLast("ActiveHandler", (ChannelHandler)handler);
        }
        return pipeline;
    }

    public void releaseExternalResources() {
        TIMER.stop();
    }
}

