/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgp;

import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.onlab.junit.TestUtils;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onosproject.bgp.BgpPeerChannelHandlerTest;
import org.onosproject.bgp.BgpPeerFrameDecoderTest;
import org.onosproject.bgp.controller.BgpCfg;
import org.onosproject.bgp.controller.BgpId;
import org.onosproject.bgp.controller.impl.AdjRibIn;
import org.onosproject.bgp.controller.impl.BgpControllerImpl;
import org.onosproject.bgp.controller.impl.BgpLocalRibImpl;
import org.onosproject.bgp.controller.impl.BgpPeerImpl;
import org.onosproject.bgp.controller.impl.VpnAdjRibIn;
import org.onosproject.bgpio.protocol.linkstate.BgpLinkLSIdentifier;
import org.onosproject.bgpio.protocol.linkstate.BgpNodeLSIdentifier;
import org.onosproject.bgpio.protocol.linkstate.BgpPrefixLSIdentifier;
import org.onosproject.bgpio.protocol.linkstate.NodeDescriptors;
import org.onosproject.bgpio.types.AutonomousSystemTlv;
import org.onosproject.bgpio.types.BgpLSIdentifierTlv;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.types.FourOctetAsNumCapabilityTlv;
import org.onosproject.bgpio.types.IPReachabilityInformationTlv;
import org.onosproject.bgpio.types.IPv4AddressTlv;
import org.onosproject.bgpio.types.IsIsNonPseudonode;
import org.onosproject.bgpio.types.IsIsPseudonode;
import org.onosproject.bgpio.types.MultiProtocolExtnCapabilityTlv;
import org.onosproject.bgpio.types.RouteDistinguisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore(value="Tests are failing due to NPE and due to failure to bind port")
public class BgpControllerImplTest {
    protected static final Logger log = LoggerFactory.getLogger(BgpControllerImplTest.class);
    private static final String IP_LOOPBACK_ID1 = "127.0.0.1";
    private static final int MESSAGE_TIMEOUT_MS = 3000;
    public byte version;
    public short asNumber;
    public short holdTime;
    public int bgpId = InetAddresses.coerceToInteger((InetAddress)InetAddresses.forString((String)"127.0.0.1"));
    public boolean isLargeAsCapabilitySet = false;
    public LinkedList<BgpValueType> capabilityTlv = new LinkedList();
    private BgpControllerImpl bgpControllerImpl;
    BgpPeerTest peer1;
    BgpPeerTest peer2;
    private InetSocketAddress connectToSocket;

    @Before
    public void setUp() throws Exception {
        this.peer1 = new BgpPeerTest(this.version, this.asNumber, this.holdTime, this.bgpId, this.isLargeAsCapabilitySet, this.capabilityTlv);
        this.peer2 = new BgpPeerTest(this.version, this.asNumber, this.holdTime, this.bgpId, this.isLargeAsCapabilitySet, this.capabilityTlv);
        this.bgpControllerImpl = new BgpControllerImpl();
        this.bgpControllerImpl.controller().setBgpPortNum();
        this.bgpControllerImpl.activate();
        Channel serverChannel = (Channel)TestUtils.getField((Object)this.bgpControllerImpl.controller(), (String)"serverChannel");
        SocketAddress socketAddress = serverChannel.getLocalAddress();
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        InetAddress connectToAddress = InetAddresses.forString((String)IP_LOOPBACK_ID1);
        this.connectToSocket = new InetSocketAddress(connectToAddress, inetSocketAddress.getPort());
        this.bgpControllerImpl.getConfig().setRouterId("1.1.1.1");
        this.bgpControllerImpl.getConfig().setAsNumber(200);
        this.bgpControllerImpl.getConfig().setHoldTime((short)120);
        this.bgpControllerImpl.getConfig().setState(BgpCfg.State.IP_AS_CONFIGURED);
        this.bgpControllerImpl.getConfig().addPeer(IP_LOOPBACK_ID1, 200);
        this.bgpControllerImpl.getConfig().addPeer("127.0.0.9", 200);
        this.bgpControllerImpl.getConfig().addPeer("127.0.0.33", 200);
        this.bgpControllerImpl.getConfig().addPeer("127.0.0.10", 200);
        this.bgpControllerImpl.getConfig().addPeer("127.0.0.20", 200);
        this.bgpControllerImpl.getConfig().addPeer("127.0.0.30", 200);
        this.bgpControllerImpl.getConfig().addPeer("127.0.0.40", 200);
        this.bgpControllerImpl.getConfig().addPeer("127.0.0.50", 200);
        this.bgpControllerImpl.getConfig().addPeer("127.0.0.60", 200);
        this.bgpControllerImpl.getConfig().addPeer("127.0.0.70", 200);
        this.bgpControllerImpl.getConfig().addPeer("127.0.0.80", 200);
        this.bgpControllerImpl.getConfig().addPeer("127.0.0.90", 200);
        this.bgpControllerImpl.getConfig().addPeer("127.0.0.91", 200);
        this.bgpControllerImpl.getConfig().addPeer("127.0.0.92", 200);
        this.bgpControllerImpl.getConfig().addPeer("127.0.0.99", 200);
        this.bgpControllerImpl.getConfig().addPeer("127.0.0.94", 200);
        this.bgpControllerImpl.getConfig().addPeer("127.0.0.95", 200);
        this.bgpControllerImpl.getConfig().addPeer("127.0.0.35", 200);
    }

    @After
    public void tearDown() throws Exception {
        this.bgpControllerImpl.deactivate();
        this.bgpControllerImpl = null;
    }

    @Test
    public void bgpOpenMessageTest1() throws InterruptedException {
        ((BgpPeerTest)this.peer1).peerChannelHandler.asNumber = (short)200;
        ((BgpPeerTest)this.peer1).peerChannelHandler.version = (byte)4;
        ((BgpPeerTest)this.peer1).peerChannelHandler.holdTime = (short)120;
        this.peer1.connect(this.connectToSocket);
        boolean result = ((BgpPeerTest)this.peer1).peerFrameDecoder.receivedOpenMessageLatch.await(3000L, TimeUnit.MILLISECONDS);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)true));
        result = ((BgpPeerTest)this.peer1).peerFrameDecoder.receivedKeepaliveMessageLatch.await(3000L, TimeUnit.MILLISECONDS);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)true));
    }

    @Test
    public void bgpOpenMessageTest2() throws InterruptedException {
        ((BgpPeerTest)this.peer1).peerChannelHandler.asNumber = (short)500;
        ((BgpPeerTest)this.peer1).peerChannelHandler.version = (byte)4;
        ((BgpPeerTest)this.peer1).peerChannelHandler.holdTime = (short)120;
        this.peer1.connect(this.connectToSocket);
        boolean result = ((BgpPeerTest)this.peer1).peerFrameDecoder.receivedNotificationMessageLatch.await(3000L, TimeUnit.MILLISECONDS);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)true));
    }

    @Test
    public void bgpOpenMessageTest3() throws InterruptedException {
        ((BgpPeerTest)this.peer1).peerChannelHandler.asNumber = (short)200;
        ((BgpPeerTest)this.peer1).peerChannelHandler.version = (byte)4;
        ((BgpPeerTest)this.peer1).peerChannelHandler.holdTime = 1;
        this.peer1.connect(this.connectToSocket);
        boolean result = ((BgpPeerTest)this.peer1).peerFrameDecoder.receivedNotificationMessageLatch.await(3000L, TimeUnit.MILLISECONDS);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)true));
    }

    @Test
    public void bgpOpenMessageTest4() throws InterruptedException {
        ((BgpPeerTest)this.peer1).peerChannelHandler.asNumber = (short)200;
        ((BgpPeerTest)this.peer1).peerChannelHandler.version = (byte)4;
        ((BgpPeerTest)this.peer1).peerChannelHandler.holdTime = (short)120;
        ((BgpPeerTest)this.peer1).peerChannelHandler.isLargeAsCapabilitySet = true;
        FourOctetAsNumCapabilityTlv tempTlv = new FourOctetAsNumCapabilityTlv(766545);
        ((BgpPeerTest)this.peer1).peerChannelHandler.capabilityTlv.add((BgpValueType)tempTlv);
        this.peer1.connect(this.connectToSocket);
        boolean result = ((BgpPeerTest)this.peer1).peerFrameDecoder.receivedNotificationMessageLatch.await(3000L, TimeUnit.MILLISECONDS);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)true));
    }

    @Test
    public void bgpOpenMessageTest5() throws InterruptedException {
        short afi = 16388;
        byte res = 0;
        byte safi = 71;
        ((BgpPeerTest)this.peer1).peerChannelHandler.asNumber = (short)200;
        ((BgpPeerTest)this.peer1).peerChannelHandler.version = (byte)4;
        ((BgpPeerTest)this.peer1).peerChannelHandler.holdTime = (short)120;
        this.bgpControllerImpl.getConfig().setLsCapability(true);
        MultiProtocolExtnCapabilityTlv tempTlv1 = new MultiProtocolExtnCapabilityTlv(afi, res, safi);
        ((BgpPeerTest)this.peer1).peerChannelHandler.capabilityTlv.add((BgpValueType)tempTlv1);
        this.peer1.connect(this.connectToSocket);
        boolean result = ((BgpPeerTest)this.peer1).peerFrameDecoder.receivedOpenMessageLatch.await(3000L, TimeUnit.MILLISECONDS);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)true));
        result = ((BgpPeerTest)this.peer1).peerFrameDecoder.receivedKeepaliveMessageLatch.await(3000L, TimeUnit.MILLISECONDS);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)true));
    }

    @Test
    public void bgpOpenMessageTest6() throws InterruptedException {
        ((BgpPeerTest)this.peer1).peerChannelHandler.asNumber = (short)200;
        ((BgpPeerTest)this.peer1).peerChannelHandler.version = (byte)4;
        ((BgpPeerTest)this.peer1).peerChannelHandler.holdTime = (short)120;
        ((BgpPeerTest)this.peer1).peerChannelHandler.isLargeAsCapabilitySet = true;
        this.bgpControllerImpl.getConfig().setLargeASCapability(true);
        FourOctetAsNumCapabilityTlv tempTlv = new FourOctetAsNumCapabilityTlv(200);
        ((BgpPeerTest)this.peer1).peerChannelHandler.capabilityTlv.add((BgpValueType)tempTlv);
        this.peer1.connect(this.connectToSocket);
        boolean result = ((BgpPeerTest)this.peer1).peerFrameDecoder.receivedOpenMessageLatch.await(3000L, TimeUnit.MILLISECONDS);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)true));
        result = ((BgpPeerTest)this.peer1).peerFrameDecoder.receivedKeepaliveMessageLatch.await(3000L, TimeUnit.MILLISECONDS);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)true));
        result = ((BgpPeerTest)this.peer1).peerFrameDecoder.receivedKeepaliveMessageLatch.await(3000L, TimeUnit.MILLISECONDS);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)true));
    }

    @Test
    public void bgpOpenMessageTest7() throws InterruptedException {
        short afi = 16388;
        byte res = 0;
        byte safi = 71;
        ((BgpPeerTest)this.peer1).peerChannelHandler.asNumber = (short)200;
        ((BgpPeerTest)this.peer1).peerChannelHandler.version = (byte)4;
        ((BgpPeerTest)this.peer1).peerChannelHandler.holdTime = (short)120;
        ((BgpPeerTest)this.peer1).peerChannelHandler.isLargeAsCapabilitySet = true;
        this.bgpControllerImpl.getConfig().setLargeASCapability(true);
        FourOctetAsNumCapabilityTlv tempTlv = new FourOctetAsNumCapabilityTlv(200);
        ((BgpPeerTest)this.peer1).peerChannelHandler.capabilityTlv.add((BgpValueType)tempTlv);
        this.bgpControllerImpl.getConfig().setLsCapability(true);
        MultiProtocolExtnCapabilityTlv tempTlv1 = new MultiProtocolExtnCapabilityTlv(afi, res, safi);
        ((BgpPeerTest)this.peer1).peerChannelHandler.capabilityTlv.add((BgpValueType)tempTlv1);
        this.peer1.connect(this.connectToSocket);
        boolean result = ((BgpPeerTest)this.peer1).peerFrameDecoder.receivedOpenMessageLatch.await(3000L, TimeUnit.MILLISECONDS);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)true));
    }

    @Test
    public void testBgpUpdateMessage1() throws InterruptedException {
        ((BgpPeerTest)this.peer1).peerChannelHandler.asNumber = (short)200;
        ((BgpPeerTest)this.peer1).peerChannelHandler.version = (byte)4;
        ((BgpPeerTest)this.peer1).peerChannelHandler.holdTime = (short)120;
        short afi = 16388;
        byte res = 0;
        byte safi = 71;
        this.bgpControllerImpl.getConfig().setLsCapability(true);
        MultiProtocolExtnCapabilityTlv tempTlv1 = new MultiProtocolExtnCapabilityTlv(afi, res, safi);
        ((BgpPeerTest)this.peer1).peerChannelHandler.capabilityTlv.add((BgpValueType)tempTlv1);
        this.peer1.connectFrom(this.connectToSocket, new InetSocketAddress("127.0.0.9", 0));
        TimeUnit.MILLISECONDS.sleep(1000L);
        BgpId bgpId = new BgpId(IpAddress.valueOf((String)"127.0.0.9"));
        BgpPeerImpl peer = (BgpPeerImpl)this.bgpControllerImpl.getPeer(bgpId);
        LinkedList<AutonomousSystemTlv> subTlvs = new LinkedList<AutonomousSystemTlv>();
        AutonomousSystemTlv tlv = AutonomousSystemTlv.of((int)2478);
        subTlvs.add(tlv);
        tlv = BgpLSIdentifierTlv.of((int)0x2020202);
        subTlvs.add(tlv);
        NodeDescriptors nodeDes = new NodeDescriptors(subTlvs, 16, 256);
        BgpNodeLSIdentifier key = new BgpNodeLSIdentifier(nodeDes);
        AdjRibIn adj = peer.adjRib();
        Assert.assertThat((Object)adj.nodeTree().containsKey(key), (Matcher)Is.is((Object)true));
        BgpLocalRibImpl obj = (BgpLocalRibImpl)this.bgpControllerImpl.bgpLocalRib();
        Assert.assertThat((Object)obj.nodeTree().containsKey(key), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testBgpUpdateMessage2() throws InterruptedException, TestUtils.TestUtilsException {
        ((BgpPeerTest)this.peer1).peerChannelHandler.asNumber = (short)200;
        ((BgpPeerTest)this.peer1).peerChannelHandler.version = (byte)4;
        ((BgpPeerTest)this.peer1).peerChannelHandler.holdTime = (short)120;
        short afi = 16388;
        byte res = 0;
        byte safi = 71;
        this.bgpControllerImpl.getConfig().setLsCapability(true);
        MultiProtocolExtnCapabilityTlv tempTlv1 = new MultiProtocolExtnCapabilityTlv(afi, res, safi);
        ((BgpPeerTest)this.peer2).peerChannelHandler.capabilityTlv.add((BgpValueType)tempTlv1);
        Channel channel = this.peer1.connectFrom(this.connectToSocket, new InetSocketAddress("127.0.0.95", 0));
        TimeUnit.MILLISECONDS.sleep(1000L);
        BgpId bgpId = new BgpId(IpAddress.valueOf((String)"127.0.0.95"));
        BgpPeerImpl peer = (BgpPeerImpl)this.bgpControllerImpl.getPeer(bgpId);
        LinkedList<AutonomousSystemTlv> subTlvs = new LinkedList<AutonomousSystemTlv>();
        AutonomousSystemTlv tlv = AutonomousSystemTlv.of((int)2478);
        subTlvs.add(tlv);
        tlv = BgpLSIdentifierTlv.of((int)0x2020202);
        subTlvs.add(tlv);
        NodeDescriptors nodeDes = new NodeDescriptors(subTlvs, 16, 256);
        BgpNodeLSIdentifier key = new BgpNodeLSIdentifier(nodeDes);
        TimeUnit.MILLISECONDS.sleep(500L);
        AdjRibIn adj = peer.adjRib();
        Assert.assertThat((Object)adj.nodeTree().containsKey(key), (Matcher)Is.is((Object)true));
        BgpLocalRibImpl obj = (BgpLocalRibImpl)this.bgpControllerImpl.bgpLocalRib();
        Assert.assertThat((Object)obj.nodeTree().containsKey(key), (Matcher)Is.is((Object)true));
        ((BgpPeerTest)this.peer2).peerChannelHandler.asNumber = (short)200;
        ((BgpPeerTest)this.peer2).peerChannelHandler.version = (byte)4;
        ((BgpPeerTest)this.peer2).peerChannelHandler.holdTime = (short)120;
        this.bgpControllerImpl.getConfig().setLsCapability(true);
        tempTlv1 = new MultiProtocolExtnCapabilityTlv(afi, res, safi);
        ((BgpPeerTest)this.peer2).peerChannelHandler.capabilityTlv.add((BgpValueType)tempTlv1);
        this.peer2.connectFrom(this.connectToSocket, new InetSocketAddress("127.0.0.70", 0));
        TimeUnit.MILLISECONDS.sleep(1000L);
        bgpId = new BgpId(IpAddress.valueOf((String)"127.0.0.70"));
        peer = (BgpPeerImpl)this.bgpControllerImpl.getPeer(bgpId);
        TimeUnit.MILLISECONDS.sleep(200L);
        adj = peer.adjRib();
        Assert.assertThat((Object)adj.nodeTree().isEmpty(), (Matcher)Is.is((Object)true));
        channel.disconnect();
        channel.close();
        obj = (BgpLocalRibImpl)this.bgpControllerImpl.bgpLocalRib();
        TimeUnit.MILLISECONDS.sleep(200L);
        Assert.assertThat((Object)obj.nodeTree().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testBgpUpdateMessage3() throws InterruptedException, TestUtils.TestUtilsException {
        ((BgpPeerTest)this.peer1).peerChannelHandler.asNumber = (short)200;
        ((BgpPeerTest)this.peer1).peerChannelHandler.version = (byte)4;
        ((BgpPeerTest)this.peer1).peerChannelHandler.holdTime = (short)120;
        short afi = 16388;
        byte res = 0;
        byte safi = 71;
        this.bgpControllerImpl.getConfig().setLsCapability(true);
        MultiProtocolExtnCapabilityTlv tempTlv1 = new MultiProtocolExtnCapabilityTlv(afi, res, safi);
        ((BgpPeerTest)this.peer1).peerChannelHandler.capabilityTlv.add((BgpValueType)tempTlv1);
        this.peer1.connectFrom(this.connectToSocket, new InetSocketAddress("127.0.0.10", 0));
        TimeUnit.MILLISECONDS.sleep(1000L);
        BgpId bgpId = new BgpId(IpAddress.valueOf((String)"127.0.0.10"));
        BgpPeerImpl peer = (BgpPeerImpl)this.bgpControllerImpl.getPeer(bgpId);
        LinkedList<AutonomousSystemTlv> localNodeSubTlvs = new LinkedList<AutonomousSystemTlv>();
        LinkedList<AutonomousSystemTlv> remoteNodeSubTlvs = new LinkedList<AutonomousSystemTlv>();
        AutonomousSystemTlv tlv = AutonomousSystemTlv.of((int)2222);
        localNodeSubTlvs.add(tlv);
        remoteNodeSubTlvs.add(tlv);
        tlv = BgpLSIdentifierTlv.of((int)0x2020202);
        localNodeSubTlvs.add(tlv);
        remoteNodeSubTlvs.add(tlv);
        byte[] isoNodeID = new byte[]{25, 0, -107, 2, 80, 33};
        tlv = IsIsPseudonode.of((byte[])isoNodeID, (byte)3);
        localNodeSubTlvs.add(tlv);
        isoNodeID = new byte[]{25, 0, -107, 2, 80, 33};
        tlv = IsIsNonPseudonode.of((byte[])isoNodeID);
        remoteNodeSubTlvs.add(tlv);
        NodeDescriptors localNodeDes = new NodeDescriptors(localNodeSubTlvs, 27, 256);
        NodeDescriptors remoteNodeDes = new NodeDescriptors(remoteNodeSubTlvs, 26, 257);
        LinkedList<AutonomousSystemTlv> linkDescriptor = new LinkedList<AutonomousSystemTlv>();
        tlv = IPv4AddressTlv.of((Ip4Address)Ip4Address.valueOf((String)"2.2.2.2"), (short)259);
        linkDescriptor.add(tlv);
        BgpLinkLSIdentifier key = new BgpLinkLSIdentifier(localNodeDes, remoteNodeDes, linkDescriptor);
        TimeUnit.MILLISECONDS.sleep(200L);
        AdjRibIn adj = peer.adjRib();
        Assert.assertThat((Object)adj.linkTree().containsKey(key), (Matcher)Is.is((Object)true));
        BgpLocalRibImpl obj = (BgpLocalRibImpl)this.bgpControllerImpl.bgpLocalRib();
        TimeUnit.MILLISECONDS.sleep(200L);
        Assert.assertThat((Object)obj.linkTree().containsKey(key), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testBgpUpdateMessage4() throws InterruptedException {
        ((BgpPeerTest)this.peer1).peerChannelHandler.asNumber = (short)200;
        ((BgpPeerTest)this.peer1).peerChannelHandler.version = (byte)4;
        ((BgpPeerTest)this.peer1).peerChannelHandler.holdTime = (short)120;
        short afi = 16388;
        byte res = 0;
        byte safi = -128;
        this.bgpControllerImpl.getConfig().setLsCapability(true);
        MultiProtocolExtnCapabilityTlv tempTlv1 = new MultiProtocolExtnCapabilityTlv(afi, res, safi);
        ((BgpPeerTest)this.peer1).peerChannelHandler.capabilityTlv.add((BgpValueType)tempTlv1);
        Channel channel = this.peer1.connectFrom(this.connectToSocket, new InetSocketAddress("127.0.0.35", 0));
        TimeUnit.MILLISECONDS.sleep(1000L);
        IpAddress ipAddress = IpAddress.valueOf((String)"127.0.0.35");
        BgpId bgpId = new BgpId(ipAddress);
        BgpPeerImpl peer = (BgpPeerImpl)this.bgpControllerImpl.getPeer(bgpId);
        LinkedList<AutonomousSystemTlv> subTlvs1 = new LinkedList<AutonomousSystemTlv>();
        LinkedList<AutonomousSystemTlv> subTlvs = new LinkedList<AutonomousSystemTlv>();
        AutonomousSystemTlv tlv = AutonomousSystemTlv.of((int)2478);
        subTlvs.add(tlv);
        tlv = BgpLSIdentifierTlv.of((int)0x2020202);
        subTlvs.add(tlv);
        NodeDescriptors nodeDes = new NodeDescriptors(subTlvs, 16, 256);
        BgpNodeLSIdentifier key = new BgpNodeLSIdentifier(nodeDes);
        RouteDistinguisher rd = new RouteDistinguisher(10L);
        VpnAdjRibIn vpnAdj = peer.vpnAdjRib();
        Assert.assertThat((Object)vpnAdj.vpnNodeTree().containsKey(rd), (Matcher)Is.is((Object)true));
        Map treeValue = (Map)vpnAdj.vpnNodeTree().get(rd);
        Assert.assertThat((Object)treeValue.containsKey(key), (Matcher)Is.is((Object)true));
        BgpLocalRibImpl obj = (BgpLocalRibImpl)this.bgpControllerImpl.bgpLocalRibVpn();
        Assert.assertThat((Object)obj.vpnNodeTree().containsKey(rd), (Matcher)Is.is((Object)true));
        Map value = (Map)obj.vpnNodeTree().get(rd);
        Assert.assertThat((Object)value.containsKey(key), (Matcher)Is.is((Object)true));
        ((BgpPeerTest)this.peer2).peerChannelHandler.asNumber = (short)200;
        ((BgpPeerTest)this.peer2).peerChannelHandler.version = (byte)4;
        ((BgpPeerTest)this.peer2).peerChannelHandler.holdTime = (short)120;
        this.bgpControllerImpl.getConfig().setLsCapability(true);
        tempTlv1 = new MultiProtocolExtnCapabilityTlv(afi, res, safi);
        ((BgpPeerTest)this.peer1).peerChannelHandler.capabilityTlv.add((BgpValueType)tempTlv1);
        this.peer2.connectFrom(this.connectToSocket, new InetSocketAddress("127.0.0.40", 0));
        TimeUnit.MILLISECONDS.sleep(1000L);
        bgpId = new BgpId(IpAddress.valueOf((String)"127.0.0.40"));
        peer = (BgpPeerImpl)this.bgpControllerImpl.getPeer(bgpId);
        tlv = AutonomousSystemTlv.of((int)686);
        subTlvs1.add(tlv);
        tlv = BgpLSIdentifierTlv.of((int)0x2020202);
        subTlvs1.add(tlv);
        nodeDes = new NodeDescriptors(subTlvs1, 16, 256);
        key = new BgpNodeLSIdentifier(nodeDes);
        vpnAdj = peer.vpnAdjRib();
        Assert.assertThat((Object)vpnAdj.vpnNodeTree().containsKey(rd), (Matcher)Is.is((Object)true));
        treeValue = (Map)vpnAdj.vpnNodeTree().get(rd);
        Assert.assertThat((Object)treeValue.containsKey(key), (Matcher)Is.is((Object)true));
        channel.disconnect();
        channel.close();
        obj = (BgpLocalRibImpl)this.bgpControllerImpl.bgpLocalRibVpn();
        Assert.assertThat((Object)obj.vpnNodeTree().containsKey(rd), (Matcher)Is.is((Object)true));
        value = (Map)obj.vpnNodeTree().get(rd);
        Assert.assertThat((Object)value.containsKey(key), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testBgpUpdateMessage5() throws InterruptedException, TestUtils.TestUtilsException {
        ((BgpPeerTest)this.peer1).peerChannelHandler.asNumber = (short)200;
        ((BgpPeerTest)this.peer1).peerChannelHandler.version = (byte)4;
        ((BgpPeerTest)this.peer1).peerChannelHandler.holdTime = (short)120;
        short afi = 16388;
        byte res = 0;
        byte safi = 71;
        this.bgpControllerImpl.getConfig().setLsCapability(true);
        MultiProtocolExtnCapabilityTlv tempTlv1 = new MultiProtocolExtnCapabilityTlv(afi, res, safi);
        ((BgpPeerTest)this.peer1).peerChannelHandler.capabilityTlv.add((BgpValueType)tempTlv1);
        Channel channel = this.peer1.connectFrom(this.connectToSocket, new InetSocketAddress("127.0.0.99", 0));
        TimeUnit.MILLISECONDS.sleep(1000L);
        BgpId bgpId = new BgpId(IpAddress.valueOf((String)"127.0.0.99"));
        BgpPeerImpl peer = (BgpPeerImpl)this.bgpControllerImpl.getPeer(bgpId);
        LinkedList<AutonomousSystemTlv> subTlvs = new LinkedList<AutonomousSystemTlv>();
        AutonomousSystemTlv tlv = null;
        tlv = AutonomousSystemTlv.of((int)2478);
        subTlvs.add(tlv);
        tlv = BgpLSIdentifierTlv.of((int)0x2020202);
        subTlvs.add(tlv);
        NodeDescriptors nodeDes = new NodeDescriptors(subTlvs, 16, 256);
        BgpNodeLSIdentifier key = new BgpNodeLSIdentifier(nodeDes);
        TimeUnit.MILLISECONDS.sleep(500L);
        AdjRibIn adj = peer.adjRib();
        Assert.assertThat((Object)adj.nodeTree().containsKey(key), (Matcher)Is.is((Object)true));
        BgpLocalRibImpl obj = (BgpLocalRibImpl)this.bgpControllerImpl.bgpLocalRib();
        Assert.assertThat((Object)obj.nodeTree().containsKey(key), (Matcher)Is.is((Object)true));
        ((BgpPeerTest)this.peer2).peerChannelHandler.asNumber = (short)200;
        ((BgpPeerTest)this.peer2).peerChannelHandler.version = (byte)4;
        ((BgpPeerTest)this.peer2).peerChannelHandler.holdTime = (short)120;
        this.bgpControllerImpl.getConfig().setLsCapability(true);
        tempTlv1 = new MultiProtocolExtnCapabilityTlv(afi, res, safi);
        ((BgpPeerTest)this.peer2).peerChannelHandler.capabilityTlv.add((BgpValueType)tempTlv1);
        this.peer2.connectFrom(this.connectToSocket, new InetSocketAddress("127.0.0.92", 0));
        TimeUnit.MILLISECONDS.sleep(1000L);
        bgpId = new BgpId(IpAddress.valueOf((String)"127.0.0.92"));
        peer = (BgpPeerImpl)this.bgpControllerImpl.getPeer(bgpId);
        adj = peer.adjRib();
        Assert.assertThat((Object)adj.nodeTree().isEmpty(), (Matcher)Is.is((Object)true));
        channel.disconnect();
        channel.close();
        obj = (BgpLocalRibImpl)this.bgpControllerImpl.bgpLocalRib();
        TimeUnit.MILLISECONDS.sleep(200L);
        Assert.assertThat((Object)obj.nodeTree().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testBgpUpdateMessage6() throws InterruptedException {
        ((BgpPeerTest)this.peer1).peerChannelHandler.asNumber = (short)200;
        ((BgpPeerTest)this.peer1).peerChannelHandler.version = (byte)4;
        ((BgpPeerTest)this.peer1).peerChannelHandler.holdTime = (short)120;
        short afi = 16388;
        byte res = 0;
        byte safi = 71;
        this.bgpControllerImpl.getConfig().setLsCapability(true);
        MultiProtocolExtnCapabilityTlv tempTlv1 = new MultiProtocolExtnCapabilityTlv(afi, res, safi);
        ((BgpPeerTest)this.peer1).peerChannelHandler.capabilityTlv.add((BgpValueType)tempTlv1);
        Channel channel = this.peer1.connectFrom(this.connectToSocket, new InetSocketAddress("127.0.0.94", 0));
        TimeUnit.MILLISECONDS.sleep(1000L);
        BgpId bgpId = new BgpId(IpAddress.valueOf((String)"127.0.0.94"));
        BgpPeerImpl peer = (BgpPeerImpl)this.bgpControllerImpl.getPeer(bgpId);
        LinkedList<AutonomousSystemTlv> subTlvs = new LinkedList<AutonomousSystemTlv>();
        AutonomousSystemTlv tlv = AutonomousSystemTlv.of((int)2478);
        subTlvs.add(tlv);
        tlv = BgpLSIdentifierTlv.of((int)0x2020202);
        subTlvs.add(tlv);
        NodeDescriptors nodeDes = new NodeDescriptors(subTlvs, 16, 256);
        BgpNodeLSIdentifier key = new BgpNodeLSIdentifier(nodeDes);
        TimeUnit.MILLISECONDS.sleep(500L);
        AdjRibIn adj = peer.adjRib();
        Assert.assertThat((Object)adj.nodeTree().containsKey(key), (Matcher)Is.is((Object)true));
        BgpLocalRibImpl obj = (BgpLocalRibImpl)this.bgpControllerImpl.bgpLocalRib();
        Assert.assertThat((Object)obj.nodeTree().containsKey(key), (Matcher)Is.is((Object)true));
        ((BgpPeerTest)this.peer2).peerChannelHandler.asNumber = (short)200;
        ((BgpPeerTest)this.peer2).peerChannelHandler.version = (byte)4;
        ((BgpPeerTest)this.peer2).peerChannelHandler.holdTime = (short)120;
        this.bgpControllerImpl.getConfig().setLsCapability(true);
        tempTlv1 = new MultiProtocolExtnCapabilityTlv(afi, res, safi);
        ((BgpPeerTest)this.peer2).peerChannelHandler.capabilityTlv.add((BgpValueType)tempTlv1);
        this.peer2.connectFrom(this.connectToSocket, new InetSocketAddress("127.0.0.80", 0));
        TimeUnit.MILLISECONDS.sleep(1000L);
        bgpId = new BgpId(IpAddress.valueOf((String)"127.0.0.80"));
        peer = (BgpPeerImpl)this.bgpControllerImpl.getPeer(bgpId);
        TimeUnit.MILLISECONDS.sleep(500L);
        adj = peer.adjRib();
        Assert.assertThat((Object)adj.nodeTree().containsKey(key), (Matcher)Is.is((Object)true));
        channel.disconnect();
        channel.close();
        obj = (BgpLocalRibImpl)this.bgpControllerImpl.bgpLocalRib();
        TimeUnit.MILLISECONDS.sleep(200L);
        Assert.assertThat((Object)obj.nodeTree().containsKey(key), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testBgpUpdateMessage7() throws InterruptedException, TestUtils.TestUtilsException {
        ((BgpPeerTest)this.peer1).peerChannelHandler.asNumber = (short)200;
        ((BgpPeerTest)this.peer1).peerChannelHandler.version = (byte)4;
        ((BgpPeerTest)this.peer1).peerChannelHandler.holdTime = (short)120;
        short afi = 16388;
        byte res = 0;
        byte safi = 71;
        this.bgpControllerImpl.getConfig().setLsCapability(true);
        MultiProtocolExtnCapabilityTlv tempTlv1 = new MultiProtocolExtnCapabilityTlv(afi, res, safi);
        ((BgpPeerTest)this.peer1).peerChannelHandler.capabilityTlv.add((BgpValueType)tempTlv1);
        Channel channel = this.peer1.connectFrom(this.connectToSocket, new InetSocketAddress("127.0.0.91", 0));
        TimeUnit.MILLISECONDS.sleep(1000L);
        BgpId bgpId = new BgpId(IpAddress.valueOf((String)"127.0.0.91"));
        BgpPeerImpl peer = (BgpPeerImpl)this.bgpControllerImpl.getPeer(bgpId);
        LinkedList<AutonomousSystemTlv> subTlvs = new LinkedList<AutonomousSystemTlv>();
        LinkedList<AutonomousSystemTlv> subTlvs1 = new LinkedList<AutonomousSystemTlv>();
        AutonomousSystemTlv tlv = null;
        tlv = AutonomousSystemTlv.of((int)2478);
        subTlvs.add(tlv);
        tlv = BgpLSIdentifierTlv.of((int)0x2020202);
        subTlvs.add(tlv);
        subTlvs1.add(tlv);
        NodeDescriptors nodeDes = new NodeDescriptors(subTlvs, 16, 256);
        BgpNodeLSIdentifier key = new BgpNodeLSIdentifier(nodeDes);
        AdjRibIn adj = peer.adjRib();
        Assert.assertThat((Object)adj.nodeTree().containsKey(key), (Matcher)Is.is((Object)true));
        BgpLocalRibImpl obj = (BgpLocalRibImpl)this.bgpControllerImpl.bgpLocalRib();
        Assert.assertThat((Object)obj.nodeTree().containsKey(key), (Matcher)Is.is((Object)true));
        ((BgpPeerTest)this.peer2).peerChannelHandler.asNumber = (short)200;
        ((BgpPeerTest)this.peer2).peerChannelHandler.version = (byte)4;
        ((BgpPeerTest)this.peer2).peerChannelHandler.holdTime = (short)120;
        this.bgpControllerImpl.getConfig().setLsCapability(true);
        tempTlv1 = new MultiProtocolExtnCapabilityTlv(afi, res, safi);
        ((BgpPeerTest)this.peer2).peerChannelHandler.capabilityTlv.add((BgpValueType)tempTlv1);
        this.peer2.connectFrom(this.connectToSocket, new InetSocketAddress("127.0.0.90", 0));
        TimeUnit.MILLISECONDS.sleep(1000L);
        bgpId = new BgpId(IpAddress.valueOf((String)"127.0.0.90"));
        peer = (BgpPeerImpl)this.bgpControllerImpl.getPeer(bgpId);
        tlv = AutonomousSystemTlv.of((int)2222);
        subTlvs1.add(tlv);
        byte[] isoNodeID = new byte[]{25, 0, -107, 1, -112, 88};
        tlv = IsIsNonPseudonode.of((byte[])isoNodeID);
        subTlvs1.add(tlv);
        nodeDes = new NodeDescriptors(subTlvs1, 26, 256);
        key = new BgpNodeLSIdentifier(nodeDes);
        adj = peer.adjRib();
        log.info("key " + key.toString());
        log.info("adj.nodeTree() " + adj.nodeTree().toString());
        Assert.assertThat((Object)adj.nodeTree().containsKey(key), (Matcher)Is.is((Object)true));
        channel.disconnect();
        channel.close();
        obj = (BgpLocalRibImpl)this.bgpControllerImpl.bgpLocalRib();
        TimeUnit.MILLISECONDS.sleep(200L);
        Assert.assertThat((Object)obj.nodeTree().containsKey(key), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testBgpUpdateMessage8() throws InterruptedException {
        ((BgpPeerTest)this.peer1).peerChannelHandler.asNumber = (short)200;
        ((BgpPeerTest)this.peer1).peerChannelHandler.version = (byte)4;
        ((BgpPeerTest)this.peer1).peerChannelHandler.holdTime = (short)150;
        short afi = 16388;
        byte res = 0;
        byte safi = 71;
        this.bgpControllerImpl.getConfig().setLsCapability(true);
        MultiProtocolExtnCapabilityTlv tempTlv1 = new MultiProtocolExtnCapabilityTlv(afi, res, safi);
        ((BgpPeerTest)this.peer1).peerChannelHandler.capabilityTlv.add((BgpValueType)tempTlv1);
        this.peer1.connectFrom(this.connectToSocket, new InetSocketAddress("127.0.0.20", 0));
        TimeUnit.MILLISECONDS.sleep(1000L);
        BgpId bgpId = new BgpId(IpAddress.valueOf((String)"127.0.0.20"));
        BgpPeerImpl peer = (BgpPeerImpl)this.bgpControllerImpl.getPeer(bgpId);
        LinkedList<AutonomousSystemTlv> subTlvs = new LinkedList<AutonomousSystemTlv>();
        AutonomousSystemTlv tlv = AutonomousSystemTlv.of((int)2222);
        subTlvs.add(tlv);
        tlv = BgpLSIdentifierTlv.of((int)0x2020202);
        subTlvs.add(tlv);
        byte[] isoNodeID = new byte[]{25, 33, 104, 7, 112, 1};
        tlv = IsIsNonPseudonode.of((byte[])isoNodeID);
        subTlvs.add(tlv);
        NodeDescriptors nodeDes = new NodeDescriptors(subTlvs, 26, 256);
        LinkedList<AutonomousSystemTlv> prefixDescriptor = new LinkedList<AutonomousSystemTlv>();
        byte[] prefix = new byte[]{32, -64, -88, 77, 1};
        ChannelBuffer tempCb = ChannelBuffers.dynamicBuffer();
        tempCb.writeBytes(prefix);
        tlv = IPReachabilityInformationTlv.read((ChannelBuffer)tempCb, (short)5);
        prefixDescriptor.add(tlv);
        BgpPrefixLSIdentifier key = new BgpPrefixLSIdentifier(nodeDes, prefixDescriptor);
        AdjRibIn adj = peer.adjRib();
        Assert.assertThat((Object)adj.prefixTree().containsKey(key), (Matcher)Is.is((Object)true));
        BgpLocalRibImpl obj = (BgpLocalRibImpl)this.bgpControllerImpl.bgpLocalRib();
        Assert.assertThat((Object)obj.prefixTree().containsKey(key), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testBgpUpdateMessage9() throws InterruptedException {
        ((BgpPeerTest)this.peer1).peerChannelHandler.asNumber = (short)200;
        ((BgpPeerTest)this.peer1).peerChannelHandler.version = (byte)4;
        ((BgpPeerTest)this.peer1).peerChannelHandler.holdTime = (short)120;
        short afi = 16388;
        byte res = 0;
        byte safi = -128;
        this.bgpControllerImpl.getConfig().setLsCapability(true);
        MultiProtocolExtnCapabilityTlv tempTlv1 = new MultiProtocolExtnCapabilityTlv(afi, res, safi);
        ((BgpPeerTest)this.peer1).peerChannelHandler.capabilityTlv.add((BgpValueType)tempTlv1);
        Channel channel = this.peer1.connectFrom(this.connectToSocket, new InetSocketAddress("127.0.0.30", 0));
        TimeUnit.MILLISECONDS.sleep(1000L);
        BgpId bgpId = new BgpId(IpAddress.valueOf((String)"127.0.0.30"));
        BgpPeerImpl peer = (BgpPeerImpl)this.bgpControllerImpl.getPeer(bgpId);
        LinkedList<AutonomousSystemTlv> subTlvs = new LinkedList<AutonomousSystemTlv>();
        AutonomousSystemTlv tlv = AutonomousSystemTlv.of((int)2478);
        subTlvs.add(tlv);
        tlv = BgpLSIdentifierTlv.of((int)0x2020202);
        subTlvs.add(tlv);
        NodeDescriptors nodeDes = new NodeDescriptors(subTlvs, 16, 256);
        BgpNodeLSIdentifier key = new BgpNodeLSIdentifier(nodeDes);
        RouteDistinguisher rd = new RouteDistinguisher(10L);
        VpnAdjRibIn vpnAdj = peer.vpnAdjRib();
        Assert.assertThat((Object)vpnAdj.vpnNodeTree().containsKey(rd), (Matcher)Is.is((Object)true));
        Map treeValue = (Map)vpnAdj.vpnNodeTree().get(rd);
        Assert.assertThat((Object)treeValue.containsKey(key), (Matcher)Is.is((Object)true));
        BgpLocalRibImpl obj = (BgpLocalRibImpl)this.bgpControllerImpl.bgpLocalRibVpn();
        Assert.assertThat((Object)obj.vpnNodeTree().containsKey(rd), (Matcher)Is.is((Object)true));
        Map value = (Map)obj.vpnNodeTree().get(rd);
        Assert.assertThat((Object)value.containsKey(key), (Matcher)Is.is((Object)true));
        ((BgpPeerTest)this.peer2).peerChannelHandler.asNumber = (short)200;
        ((BgpPeerTest)this.peer2).peerChannelHandler.version = (byte)4;
        ((BgpPeerTest)this.peer2).peerChannelHandler.holdTime = (short)120;
        this.bgpControllerImpl.getConfig().setLsCapability(true);
        tempTlv1 = new MultiProtocolExtnCapabilityTlv(afi, res, safi);
        ((BgpPeerTest)this.peer2).peerChannelHandler.capabilityTlv.add((BgpValueType)tempTlv1);
        this.peer2.connectFrom(this.connectToSocket, new InetSocketAddress("127.0.0.50", 0));
        TimeUnit.MILLISECONDS.sleep(1000L);
        bgpId = new BgpId(IpAddress.valueOf((String)"127.0.0.50"));
        peer = (BgpPeerImpl)this.bgpControllerImpl.getPeer(bgpId);
        key = new BgpNodeLSIdentifier(nodeDes);
        vpnAdj = peer.vpnAdjRib();
        Assert.assertThat((Object)vpnAdj.vpnNodeTree().isEmpty(), (Matcher)Is.is((Object)true));
        channel.disconnect();
        channel.close();
        obj = (BgpLocalRibImpl)this.bgpControllerImpl.bgpLocalRibVpn();
        TimeUnit.MILLISECONDS.sleep(200L);
        Assert.assertThat((Object)obj.vpnNodeTree().isEmpty(), (Matcher)Is.is((Object)true));
    }

    private final class BgpPeerTest {
        private ClientBootstrap peerBootstrap;
        private BgpPeerFrameDecoderTest peerFrameDecoder = new BgpPeerFrameDecoderTest();
        private BgpPeerChannelHandlerTest peerChannelHandler;

        private BgpPeerTest(byte version, short asNumber, short holdTime, int bgpId, boolean isLargeAsCapabilitySet, LinkedList<BgpValueType> capabilityTlv) {
            this.peerChannelHandler = new BgpPeerChannelHandlerTest(version, asNumber, holdTime, bgpId, isLargeAsCapabilitySet, capabilityTlv);
        }

        private void connect(InetSocketAddress connectToSocket) throws InterruptedException {
            NioClientSocketChannelFactory channelFactory = new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
            ChannelPipelineFactory pipelineFactory = () -> {
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast("BgpPeerFrameDecoderTest", (ChannelHandler)this.peerFrameDecoder);
                pipeline.addLast("BgpPeerChannelHandlerTest", (ChannelHandler)this.peerChannelHandler);
                return pipeline;
            };
            this.peerBootstrap = new ClientBootstrap((ChannelFactory)channelFactory);
            this.peerBootstrap.setOption("child.keepAlive", (Object)true);
            this.peerBootstrap.setOption("child.tcpNoDelay", (Object)true);
            this.peerBootstrap.setPipelineFactory(pipelineFactory);
            this.peerBootstrap.connect((SocketAddress)connectToSocket);
        }

        private Channel connectFrom(InetSocketAddress connectToSocket, SocketAddress localAddress) throws InterruptedException {
            NioClientSocketChannelFactory channelFactory = new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
            ChannelPipelineFactory pipelineFactory = () -> {
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast("BgpPeerFrameDecoderTest", (ChannelHandler)this.peerFrameDecoder);
                pipeline.addLast("BgpPeerChannelHandlerTest", (ChannelHandler)this.peerChannelHandler);
                return pipeline;
            };
            this.peerBootstrap = new ClientBootstrap((ChannelFactory)channelFactory);
            this.peerBootstrap.setOption("child.keepAlive", (Object)true);
            this.peerBootstrap.setOption("child.tcpNoDelay", (Object)true);
            this.peerBootstrap.setPipelineFactory(pipelineFactory);
            Channel channel = this.peerBootstrap.connect((SocketAddress)connectToSocket, localAddress).getChannel();
            return channel;
        }
    }
}

