/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgp;

import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.onosproject.bgpio.protocol.ver4.BgpKeepaliveMsgVer4;
import org.onosproject.bgpio.protocol.ver4.BgpOpenMsgVer4;
import org.onosproject.bgpio.types.BgpHeader;
import org.onosproject.bgpio.types.BgpValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpPeerChannelHandlerTest
extends SimpleChannelHandler {
    protected static final Logger log = LoggerFactory.getLogger(BgpPeerChannelHandlerTest.class);
    public static final int OPEN_MSG_MINIMUM_LENGTH = 29;
    public static final byte[] MARKER = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    public static final BgpHeader DEFAULT_OPEN_HEADER = new BgpHeader(MARKER, 29, 1);
    LinkedList<BgpValueType> capabilityTlv = new LinkedList();
    public byte version;
    public short asNumber;
    public short holdTime;
    public int bgpId;
    public boolean isLargeAsCapabilitySet;
    final BgpOpenMsgVer4 openMessage = new BgpOpenMsgVer4();
    ChannelHandlerContext savedCtx;

    public BgpPeerChannelHandlerTest(byte version, short asNumber, short holdTime, int bgpId, boolean isLargeAsCapabilitySet, LinkedList<BgpValueType> capabilityTlv) {
        this.version = version;
        this.asNumber = asNumber;
        this.holdTime = holdTime;
        this.bgpId = bgpId;
        this.isLargeAsCapabilitySet = isLargeAsCapabilitySet;
        this.capabilityTlv = capabilityTlv;
    }

    void closeChannel() {
        this.savedCtx.getChannel().close();
    }

    byte[] selectUpdateMessageVpn(int select) {
        switch (select) {
            case 5: {
                byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 94, 2, 0, 0, 0, 71, 4, 1, 1, 2, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 50, 64, 4, -128, 4, 4, 0, 0, 1, 0, 0, 1, 0, 37, 0, 0, 0, 0, 0, 0, 0, 10, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 16, 2, 0, 0, 4, 0, 0, 9, -82, 2, 1, 0, 4, 2, 2, 2, 2};
                return updateMsg;
            }
            case 6: {
                byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -115, 2, 0, 0, 0, 118, 4, 1, 1, 2, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 50, 64, 4, -128, 4, 4, 0, 0, 1, 0, 0, 1, 0, 37, 0, 0, 0, 0, 0, 0, 0, 10, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 16, 2, 0, 0, 4, 0, 0, 2, -82, 2, 1, 0, 4, 2, 2, 2, 2, -128, 15, 44, 64, 4, -128, 0, 1, 0, 37, 0, 0, 0, 0, 0, 0, 0, 10, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 16, 2, 0, 0, 4, 0, 0, 4, -82, 2, 1, 0, 4, 2, 2, 2, 2};
                return updateMsg;
            }
            case 7: {
                byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -115, 2, 0, 0, 0, 118, 4, 1, 1, 2, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 50, 64, 4, -128, 4, 4, 0, 0, 1, 0, 0, 1, 0, 37, 0, 0, 0, 0, 0, 0, 0, 10, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 16, 2, 0, 0, 4, 0, 0, 9, -82, 2, 1, 0, 4, 2, 2, 2, 2, -128, 15, 44, 64, 4, -128, 0, 1, 0, 37, 0, 0, 0, 0, 0, 0, 0, 10, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 16, 2, 0, 0, 4, 0, 0, 9, -82, 2, 1, 0, 4, 2, 2, 2, 2};
                return updateMsg;
            }
            case 17: {
                byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 94, 2, 0, 0, 0, 71, 4, 1, 1, 2, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 50, 64, 4, -128, 4, 4, 0, 0, 1, 0, 0, 1, 0, 37, 0, 0, 0, 0, 0, 0, 0, 10, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 16, 2, 0, 0, 4, 0, 0, 9, -82, 2, 1, 0, 4, 2, 2, 2, 2};
                return updateMsg;
            }
        }
        return null;
    }

    byte[] selectUpdateMsg(int select) {
        switch (select) {
            case 1: {
                byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 86, 2, 0, 0, 0, 63, 4, 1, 1, 2, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 42, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 1, 0, 29, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 16, 2, 0, 0, 4, 0, 0, 9, -82, 2, 1, 0, 4, 2, 2, 2, 2};
                return updateMsg;
            }
            case 2: {
                byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 125, 2, 0, 0, 0, 102, 4, 1, 1, 2, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 42, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 1, 0, 29, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 16, 2, 0, 0, 4, 0, 0, 9, -82, 2, 1, 0, 4, 2, 2, 2, 2, -128, 15, 36, 64, 4, 71, 0, 1, 0, 29, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 16, 2, 0, 0, 4, 0, 0, 9, -82, 2, 1, 0, 4, 2, 2, 2, 2};
                return updateMsg;
            }
            case 3: {
                byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -117, 2, 0, 4, 24, 10, 1, 1, 0, 112, 4, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 16, -128, 14, 91, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 2, 0, 78, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 27, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 7, 25, 0, -107, 2, 80, 33, 3, 1, 1, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 2, 80, 33, 1, 3, 0, 4, 2, 2, 2, 2};
                return updateMsg;
            }
            case 4: {
                byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -42, 2, 0, 4, 24, 10, 1, 1, 0, -69, 4, 1, 1, 0, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 18, -112, 14, 0, -91, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 3, 0, 48, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 33, 104, 7, 112, 1, 1, 9, 0, 5, 32, -64, -88, 77, 1, 0, 3, 0, 48, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 2, 80, 33, 1, 9, 0, 5, 32, 21, 21, 21, 21, 0, 3, 0, 48, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 2, 32, 34, 2, 32, 34, 1, 9, 0, 5, 32, 22, 22, 22, 22};
                return updateMsg;
            }
            case 8: {
                byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -111, 2, 0, 0, 0, 122, 4, 1, 1, 2, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 52, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 1, 0, 39, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 26, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -107, 1, -112, 88, -128, 15, 46, 64, 4, 71, 0, 1, 0, 39, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 26, 2, 0, 0, 4, 0, 0, 9, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -103, 1, -103, 88};
                return updateMsg;
            }
            case 9: {
                byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 125, 2, 0, 0, 0, 102, 4, 1, 1, 2, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 42, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 1, 0, 29, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 16, 2, 0, 0, 4, 0, 0, 9, -82, 2, 1, 0, 4, 2, 2, 2, 2, -128, 15, 36, 64, 4, 71, 0, 1, 0, 29, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 16, 2, 0, 0, 4, 0, 0, 9, -82, 2, 1, 0, 4, 2, 2, 2, 2};
                return updateMsg;
            }
            case 10: {
                byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 125, 2, 0, 0, 0, 102, 4, 1, 1, 2, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 42, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 1, 0, 29, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 16, 2, 0, 0, 4, 0, 0, 9, -82, 2, 1, 0, 4, 2, 2, 2, 2, -128, 15, 36, 64, 4, 71, 0, 1, 0, 29, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 16, 2, 0, 0, 4, 0, 0, 8, -82, 2, 1, 0, 4, 2, 2, 2, 2};
                return updateMsg;
            }
            case 12: {
                byte[] updateMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -111, 2, 0, 0, 0, 122, 4, 1, 1, 2, 64, 2, 4, 2, 1, -3, -23, -128, 4, 4, 0, 0, 0, 0, -128, 14, 52, 64, 4, 71, 4, 4, 0, 0, 1, 0, 0, 1, 0, 39, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 26, 2, 0, 0, 4, 0, 0, 9, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -103, 1, -103, 88, -128, 15, 46, 64, 4, 71, 0, 1, 0, 39, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 26, 2, 0, 0, 4, 0, 0, 9, -82, 2, 1, 0, 4, 2, 2, 2, 2, 2, 3, 0, 6, 25, 0, -103, 1, -103, 88};
                return updateMsg;
            }
        }
        return null;
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent channelEvent) throws InterruptedException {
        this.savedCtx = ctx;
        BgpOpenMsgVer4 openMsg = new BgpOpenMsgVer4(DEFAULT_OPEN_HEADER, this.version, this.asNumber, this.holdTime, this.bgpId, this.capabilityTlv);
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        openMsg.writeTo(buffer);
        ctx.getChannel().write((Object)buffer);
        TimeUnit.MILLISECONDS.sleep(100L);
        BgpKeepaliveMsgVer4 keepaliveMsg = new BgpKeepaliveMsgVer4();
        ChannelBuffer buffer1 = ChannelBuffers.dynamicBuffer();
        keepaliveMsg.writeTo(buffer1);
        ctx.getChannel().write((Object)buffer1);
        if (((InetSocketAddress)ctx.getChannel().getLocalAddress()).getAddress().equals(new InetSocketAddress("127.0.0.1", 0).getAddress())) {
            return;
        }
        if (((InetSocketAddress)ctx.getChannel().getLocalAddress()).getAddress().equals(new InetSocketAddress("127.0.0.9", 0).getAddress())) {
            ChannelBuffer bufferUp = ChannelBuffers.dynamicBuffer();
            bufferUp.writeBytes(this.selectUpdateMsg(1));
            ctx.getChannel().write((Object)bufferUp);
        } else if (((InetSocketAddress)ctx.getChannel().getLocalAddress()).getAddress().equals(new InetSocketAddress("127.0.0.33", 0).getAddress())) {
            ChannelBuffer bufferUp = ChannelBuffers.dynamicBuffer();
            bufferUp.writeBytes(this.selectUpdateMsg(2));
            ctx.getChannel().write((Object)bufferUp);
        } else if (((InetSocketAddress)ctx.getChannel().getLocalAddress()).getAddress().equals(new InetSocketAddress("127.0.0.10", 0).getAddress())) {
            ChannelBuffer bufferUp = ChannelBuffers.dynamicBuffer();
            bufferUp.writeBytes(this.selectUpdateMsg(3));
            ctx.getChannel().write((Object)bufferUp);
        } else if (((InetSocketAddress)ctx.getChannel().getLocalAddress()).getAddress().equals(new InetSocketAddress("127.0.0.20", 0).getAddress())) {
            ChannelBuffer bufferUp = ChannelBuffers.dynamicBuffer();
            bufferUp.writeBytes(this.selectUpdateMsg(4));
            ctx.getChannel().write((Object)bufferUp);
        } else if (((InetSocketAddress)ctx.getChannel().getLocalAddress()).getAddress().equals(new InetSocketAddress("127.0.0.30", 0).getAddress())) {
            ChannelBuffer bufferUp = ChannelBuffers.dynamicBuffer();
            bufferUp.writeBytes(this.selectUpdateMessageVpn(5));
            ctx.getChannel().write((Object)bufferUp);
        } else if (((InetSocketAddress)ctx.getChannel().getLocalAddress()).getAddress().equals(new InetSocketAddress("127.0.0.40", 0).getAddress())) {
            ChannelBuffer bufferUp = ChannelBuffers.dynamicBuffer();
            bufferUp.writeBytes(this.selectUpdateMessageVpn(6));
            ctx.getChannel().write((Object)bufferUp);
        } else if (((InetSocketAddress)ctx.getChannel().getLocalAddress()).getAddress().equals(new InetSocketAddress("127.0.0.50", 0).getAddress())) {
            ChannelBuffer bufferUp = ChannelBuffers.dynamicBuffer();
            bufferUp.writeBytes(this.selectUpdateMessageVpn(7));
            ctx.getChannel().write((Object)bufferUp);
        } else if (((InetSocketAddress)ctx.getChannel().getLocalAddress()).getAddress().equals(new InetSocketAddress("127.0.0.60", 0).getAddress())) {
            ChannelBuffer bufferUp = ChannelBuffers.dynamicBuffer();
            bufferUp.writeBytes(this.selectUpdateMsg(8));
            ctx.getChannel().write((Object)bufferUp);
        } else if (((InetSocketAddress)ctx.getChannel().getLocalAddress()).getAddress().equals(new InetSocketAddress("127.0.0.70", 0).getAddress())) {
            ChannelBuffer bufferUp = ChannelBuffers.dynamicBuffer();
            bufferUp.writeBytes(this.selectUpdateMsg(9));
            ctx.getChannel().write((Object)bufferUp);
        } else if (((InetSocketAddress)ctx.getChannel().getLocalAddress()).getAddress().equals(new InetSocketAddress("127.0.0.80", 0).getAddress())) {
            ChannelBuffer bufferUp = ChannelBuffers.dynamicBuffer();
            bufferUp.writeBytes(this.selectUpdateMsg(10));
            ctx.getChannel().write((Object)bufferUp);
        } else if (((InetSocketAddress)ctx.getChannel().getLocalAddress()).getAddress().equals(new InetSocketAddress("127.0.0.90", 0).getAddress())) {
            ChannelBuffer bufferUp = ChannelBuffers.dynamicBuffer();
            bufferUp.writeBytes(this.selectUpdateMsg(8));
            ctx.getChannel().write((Object)bufferUp);
        } else if (((InetSocketAddress)ctx.getChannel().getLocalAddress()).getAddress().equals(new InetSocketAddress("127.0.0.92", 0).getAddress())) {
            ChannelBuffer bufferUp = ChannelBuffers.dynamicBuffer();
            bufferUp.writeBytes(this.selectUpdateMsg(12));
            ctx.getChannel().write((Object)bufferUp);
        } else if (((InetSocketAddress)ctx.getChannel().getLocalAddress()).getAddress().equals(new InetSocketAddress("127.0.0.91", 0).getAddress())) {
            ChannelBuffer bufferUp = ChannelBuffers.dynamicBuffer();
            bufferUp.writeBytes(this.selectUpdateMsg(1));
            ctx.getChannel().write((Object)bufferUp);
        } else if (((InetSocketAddress)ctx.getChannel().getLocalAddress()).getAddress().equals(new InetSocketAddress("127.0.0.9", 0).getAddress())) {
            ChannelBuffer bufferUp = ChannelBuffers.dynamicBuffer();
            bufferUp.writeBytes(this.selectUpdateMsg(1));
            ctx.getChannel().write((Object)bufferUp);
        } else if (((InetSocketAddress)ctx.getChannel().getLocalAddress()).getAddress().equals(new InetSocketAddress("127.0.0.99", 0).getAddress())) {
            ChannelBuffer bufferUp = ChannelBuffers.dynamicBuffer();
            bufferUp.writeBytes(this.selectUpdateMsg(1));
            ctx.getChannel().write((Object)bufferUp);
        } else if (((InetSocketAddress)ctx.getChannel().getLocalAddress()).getAddress().equals(new InetSocketAddress("127.0.0.94", 0).getAddress())) {
            ChannelBuffer bufferUp = ChannelBuffers.dynamicBuffer();
            bufferUp.writeBytes(this.selectUpdateMsg(1));
            ctx.getChannel().write((Object)bufferUp);
        } else if (((InetSocketAddress)ctx.getChannel().getLocalAddress()).getAddress().equals(new InetSocketAddress("127.0.0.35", 0).getAddress())) {
            ChannelBuffer bufferUp = ChannelBuffers.dynamicBuffer();
            bufferUp.writeBytes(this.selectUpdateMessageVpn(17));
            ctx.getChannel().write((Object)bufferUp);
        } else if (((InetSocketAddress)ctx.getChannel().getLocalAddress()).getAddress().equals(new InetSocketAddress("127.0.0.95", 0).getAddress())) {
            ChannelBuffer bufferUp = ChannelBuffers.dynamicBuffer();
            bufferUp.writeBytes(this.selectUpdateMsg(1));
            ctx.getChannel().write((Object)bufferUp);
        }
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent channelEvent) {
    }
}

