/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.controller.impl;

import java.util.ArrayList;
import java.util.LinkedList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onosproject.bgp.controller.impl.BgpFlowSpecRib;
import org.onosproject.bgpio.protocol.flowspec.BgpFlowSpecDetails;
import org.onosproject.bgpio.protocol.flowspec.BgpFlowSpecPrefix;
import org.onosproject.bgpio.types.BgpFsOperatorValue;
import org.onosproject.bgpio.types.BgpFsPortNum;
import org.onosproject.bgpio.types.RouteDistinguisher;

public class BgpFlowSpecRibTest {
    @Test
    public void bgpFlowSpecRibTests1() {
        LinkedList<BgpFsPortNum> flowSpecComponents = new LinkedList<BgpFsPortNum>();
        ArrayList<BgpFsOperatorValue> operatorValue = new ArrayList<BgpFsOperatorValue>();
        BgpFlowSpecRib rib = new BgpFlowSpecRib();
        IpPrefix destinationPrefix = IpPrefix.valueOf((IpAddress)IpAddress.valueOf((String)"10.0.1.1"), (int)32);
        IpPrefix sourcePrefix = IpPrefix.valueOf((IpAddress)IpAddress.valueOf((String)"10.0.1.2"), (int)32);
        BgpFlowSpecPrefix prefix = new BgpFlowSpecPrefix(destinationPrefix, sourcePrefix);
        byte[] port = new byte[]{1};
        operatorValue.add(new BgpFsOperatorValue(-127, port));
        BgpFsPortNum portNum = new BgpFsPortNum(operatorValue);
        flowSpecComponents.add(portNum);
        BgpFlowSpecDetails flowSpec = new BgpFlowSpecDetails(flowSpecComponents);
        rib.add(prefix, flowSpec);
        boolean isPresent = rib.flowSpecTree().containsKey(prefix);
        MatcherAssert.assertThat((Object)isPresent, (Matcher)Is.is((Object)true));
    }

    @Test
    public void bgpFlowSpecRibTest2() {
        LinkedList<BgpFsPortNum> flowSpecComponents = new LinkedList<BgpFsPortNum>();
        ArrayList<BgpFsOperatorValue> operatorValue = new ArrayList<BgpFsOperatorValue>();
        BgpFlowSpecRib rib = new BgpFlowSpecRib();
        IpPrefix destinationPrefix = IpPrefix.valueOf((IpAddress)IpAddress.valueOf((String)"10.0.1.1"), (int)32);
        IpPrefix sourcePrefix = IpPrefix.valueOf((IpAddress)IpAddress.valueOf((String)"10.0.1.2"), (int)32);
        BgpFlowSpecPrefix prefix = new BgpFlowSpecPrefix(destinationPrefix, sourcePrefix);
        byte[] port = new byte[]{1};
        operatorValue.add(new BgpFsOperatorValue(-127, port));
        BgpFsPortNum portNum = new BgpFsPortNum(operatorValue);
        flowSpecComponents.add(portNum);
        BgpFlowSpecDetails flowSpec = new BgpFlowSpecDetails(flowSpecComponents);
        rib.add(prefix, flowSpec);
        boolean isPresent = rib.flowSpecTree().containsKey(prefix);
        MatcherAssert.assertThat((Object)isPresent, (Matcher)Is.is((Object)true));
        rib.delete(prefix);
        isPresent = rib.flowSpecTree().containsKey(prefix);
        MatcherAssert.assertThat((Object)isPresent, (Matcher)Is.is((Object)false));
    }

    @Test
    public void bgpFlowSpecRibTest3() {
        LinkedList<BgpFsPortNum> flowSpecComponents = new LinkedList<BgpFsPortNum>();
        ArrayList<BgpFsOperatorValue> operatorValue = new ArrayList<BgpFsOperatorValue>();
        RouteDistinguisher routeDistinguisher = new RouteDistinguisher(1L);
        BgpFlowSpecRib rib = new BgpFlowSpecRib();
        IpPrefix destinationPrefix = IpPrefix.valueOf((IpAddress)IpAddress.valueOf((String)"10.0.1.1"), (int)32);
        IpPrefix sourcePrefix = IpPrefix.valueOf((IpAddress)IpAddress.valueOf((String)"10.0.1.2"), (int)32);
        BgpFlowSpecPrefix prefix = new BgpFlowSpecPrefix(destinationPrefix, sourcePrefix);
        byte[] port = new byte[]{1};
        operatorValue.add(new BgpFsOperatorValue(-127, port));
        BgpFsPortNum portNum = new BgpFsPortNum(operatorValue);
        flowSpecComponents.add(portNum);
        BgpFlowSpecDetails flowSpec = new BgpFlowSpecDetails(flowSpecComponents);
        rib.add(routeDistinguisher, prefix, flowSpec);
        boolean isPresent = rib.vpnFlowSpecTree().containsKey(routeDistinguisher);
        MatcherAssert.assertThat((Object)isPresent, (Matcher)Is.is((Object)true));
        rib.delete(routeDistinguisher, prefix);
        isPresent = rib.vpnFlowSpecTree().containsKey(routeDistinguisher);
        MatcherAssert.assertThat((Object)isPresent, (Matcher)Is.is((Object)false));
    }
}

