/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.controller.impl;

import java.util.LinkedList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.bgp.controller.impl.BgpSelectionAlgo;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.protocol.linkstate.BgpNodeLSNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.PathAttrNlriDetails;
import org.onosproject.bgpio.protocol.linkstate.PathAttrNlriDetailsLocalRib;
import org.onosproject.bgpio.types.AsPath;
import org.onosproject.bgpio.types.LocalPref;
import org.onosproject.bgpio.types.Med;
import org.onosproject.bgpio.types.Origin;

public class BgpSelectionAlgoTest {
    @Test
    public void selectionAlgoTest1() throws BgpParseException {
        byte[] peerIp = new byte[]{10, 10, 10, 10};
        LinkedList<Origin> pathAttributes1 = new LinkedList<Origin>();
        byte[] origin = new byte[]{64, 1, 1, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(origin);
        Origin pathAttribute1 = Origin.read((ChannelBuffer)buffer);
        pathAttributes1.add(pathAttribute1);
        byte[] asPath = new byte[]{64, 2, 4, 2, 1, -3, -22};
        buffer.writeBytes(asPath);
        pathAttribute1 = AsPath.read((ChannelBuffer)buffer);
        pathAttributes1.add(pathAttribute1);
        IpAddress ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])peerIp);
        int bgpId = 0xA0A0101;
        int locRibAsNum = 100;
        boolean isIbgp = false;
        PathAttrNlriDetails attrList1 = new PathAttrNlriDetails();
        attrList1.setIdentifier(0L);
        attrList1.setPathAttribute(pathAttributes1);
        attrList1.setProtocolID(BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_ONE);
        PathAttrNlriDetailsLocalRib list1 = new PathAttrNlriDetailsLocalRib(ipAddress, bgpId, (long)locRibAsNum, isIbgp, attrList1);
        peerIp = new byte[]{11, 11, 11, 11};
        LinkedList<Origin> pathAttributes2 = new LinkedList<Origin>();
        origin = new byte[]{64, 1, 1, 2};
        buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(origin);
        Origin pathAttribute2 = Origin.read((ChannelBuffer)buffer);
        pathAttributes2.add(pathAttribute2);
        asPath = new byte[]{64, 2, 4, 2, 1, -3, -23};
        buffer.writeBytes(asPath);
        pathAttribute2 = AsPath.read((ChannelBuffer)buffer);
        pathAttributes2.add(pathAttribute2);
        ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])peerIp);
        bgpId = 0x20010000;
        locRibAsNum = 200;
        isIbgp = true;
        PathAttrNlriDetails attrList2 = new PathAttrNlriDetails();
        attrList2.setIdentifier(0L);
        attrList2.setPathAttribute(pathAttributes2);
        attrList2.setProtocolID(BgpNodeLSNlriVer4.ProtocolType.OSPF_V2);
        PathAttrNlriDetailsLocalRib list2 = new PathAttrNlriDetailsLocalRib(ipAddress, bgpId, (long)locRibAsNum, isIbgp, attrList2);
        BgpSelectionAlgo algo = new BgpSelectionAlgo();
        int result = algo.compare(list1, list2);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)1));
    }

    @Test
    public void selectionAlgoTest2() throws BgpParseException {
        byte[] peerIp = new byte[]{10, 10, 10, 10};
        LinkedList<Origin> pathAttributes1 = new LinkedList<Origin>();
        byte[] origin = new byte[]{64, 1, 1, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(origin);
        Origin pathAttribute1 = Origin.read((ChannelBuffer)buffer);
        pathAttributes1.add(pathAttribute1);
        byte[] asPath = new byte[]{64, 2, 4, 2, 1, -3, -23};
        buffer.writeBytes(asPath);
        pathAttribute1 = AsPath.read((ChannelBuffer)buffer);
        pathAttributes1.add(pathAttribute1);
        IpAddress ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])peerIp);
        int bgpId = 0xA0A0101;
        int locRibAsNum = 100;
        boolean isIbgp = false;
        PathAttrNlriDetails attrList1 = new PathAttrNlriDetails();
        attrList1.setIdentifier(0L);
        attrList1.setPathAttribute(pathAttributes1);
        attrList1.setProtocolID(BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_ONE);
        PathAttrNlriDetailsLocalRib list1 = new PathAttrNlriDetailsLocalRib(ipAddress, bgpId, (long)locRibAsNum, isIbgp, attrList1);
        peerIp = new byte[]{11, 11, 11, 11};
        LinkedList<Origin> pathAttributes2 = new LinkedList<Origin>();
        origin = new byte[]{64, 1, 1, 2};
        buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(origin);
        Origin pathAttribute2 = Origin.read((ChannelBuffer)buffer);
        pathAttributes2.add(pathAttribute2);
        asPath = new byte[]{64, 2, 8, 2, 1, -3, -22, 2, 1, -3, -22};
        buffer.writeBytes(asPath);
        pathAttribute2 = AsPath.read((ChannelBuffer)buffer);
        pathAttributes2.add(pathAttribute2);
        ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])peerIp);
        bgpId = 0x20010000;
        locRibAsNum = 200;
        isIbgp = true;
        PathAttrNlriDetails attrList2 = new PathAttrNlriDetails();
        attrList2.setIdentifier(0L);
        attrList2.setPathAttribute(pathAttributes2);
        attrList2.setProtocolID(BgpNodeLSNlriVer4.ProtocolType.OSPF_V2);
        PathAttrNlriDetailsLocalRib list2 = new PathAttrNlriDetailsLocalRib(ipAddress, bgpId, (long)locRibAsNum, isIbgp, attrList2);
        BgpSelectionAlgo algo = new BgpSelectionAlgo();
        int result = algo.compare(list1, list2);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)-1));
    }

    @Test
    public void selectionAlgoTest3() throws BgpParseException {
        byte[] peerIp = new byte[]{10, 10, 10, 10};
        LinkedList<Origin> pathAttributes1 = new LinkedList<Origin>();
        byte[] origin = new byte[]{64, 1, 1, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(origin);
        Origin pathAttribute1 = Origin.read((ChannelBuffer)buffer);
        pathAttributes1.add(pathAttribute1);
        byte[] asPath = new byte[]{64, 2, 4, 2, 1, -3, -23};
        buffer.writeBytes(asPath);
        pathAttribute1 = AsPath.read((ChannelBuffer)buffer);
        pathAttributes1.add(pathAttribute1);
        IpAddress ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])peerIp);
        int bgpId = 0xA0A0101;
        int locRibAsNum = 100;
        boolean isIbgp = false;
        PathAttrNlriDetails attrList1 = new PathAttrNlriDetails();
        attrList1.setIdentifier(0L);
        attrList1.setPathAttribute(pathAttributes1);
        attrList1.setProtocolID(BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_ONE);
        PathAttrNlriDetailsLocalRib list1 = new PathAttrNlriDetailsLocalRib(ipAddress, bgpId, (long)locRibAsNum, isIbgp, attrList1);
        peerIp = new byte[]{11, 11, 11, 11};
        LinkedList<Origin> pathAttributes2 = new LinkedList<Origin>();
        origin = new byte[]{64, 1, 1, 2};
        buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(origin);
        Origin pathAttribute2 = Origin.read((ChannelBuffer)buffer);
        pathAttributes2.add(pathAttribute2);
        asPath = new byte[]{64, 2, 4, 2, 1, -3, -23};
        buffer.writeBytes(asPath);
        pathAttribute2 = AsPath.read((ChannelBuffer)buffer);
        pathAttributes2.add(pathAttribute2);
        ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])peerIp);
        bgpId = 0x20010000;
        locRibAsNum = 200;
        isIbgp = true;
        PathAttrNlriDetails attrList2 = new PathAttrNlriDetails();
        attrList2.setIdentifier(0L);
        attrList2.setPathAttribute(pathAttributes2);
        attrList2.setProtocolID(BgpNodeLSNlriVer4.ProtocolType.OSPF_V2);
        PathAttrNlriDetailsLocalRib list2 = new PathAttrNlriDetailsLocalRib(ipAddress, bgpId, (long)locRibAsNum, isIbgp, attrList2);
        BgpSelectionAlgo algo = new BgpSelectionAlgo();
        int result = algo.compare(list1, list2);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)1));
    }

    @Test
    public void selectionAlgoTest4() throws BgpParseException {
        byte[] peerIp = new byte[]{10, 10, 10, 10};
        LinkedList<Origin> pathAttributes1 = new LinkedList<Origin>();
        byte[] origin = new byte[]{64, 1, 1, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(origin);
        Origin pathAttribute1 = Origin.read((ChannelBuffer)buffer);
        pathAttributes1.add(pathAttribute1);
        byte[] med = new byte[]{-128, 4, 4, 0, 0, 0, 0};
        buffer.writeBytes(med);
        pathAttribute1 = Med.read((ChannelBuffer)buffer);
        pathAttributes1.add(pathAttribute1);
        byte[] asPath = new byte[]{64, 2, 4, 2, 1, -3, -23};
        buffer.writeBytes(asPath);
        pathAttribute1 = AsPath.read((ChannelBuffer)buffer);
        pathAttributes1.add(pathAttribute1);
        IpAddress ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])peerIp);
        int bgpId = 0xA0A0101;
        int locRibAsNum = 100;
        boolean isIbgp = false;
        PathAttrNlriDetails attrList1 = new PathAttrNlriDetails();
        attrList1.setIdentifier(0L);
        attrList1.setPathAttribute(pathAttributes1);
        attrList1.setProtocolID(BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_ONE);
        PathAttrNlriDetailsLocalRib list1 = new PathAttrNlriDetailsLocalRib(ipAddress, bgpId, (long)locRibAsNum, isIbgp, attrList1);
        peerIp = new byte[]{11, 11, 11, 11};
        LinkedList<Origin> pathAttributes2 = new LinkedList<Origin>();
        origin = new byte[]{64, 1, 1, 2};
        buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(origin);
        Origin pathAttribute2 = Origin.read((ChannelBuffer)buffer);
        pathAttributes2.add(pathAttribute2);
        med = new byte[]{-128, 4, 4, 0, 0, 0, 1};
        buffer.writeBytes(med);
        pathAttribute2 = Med.read((ChannelBuffer)buffer);
        pathAttributes2.add(pathAttribute2);
        asPath = new byte[]{64, 2, 4, 2, 1, -3, -23};
        buffer.writeBytes(asPath);
        pathAttribute2 = AsPath.read((ChannelBuffer)buffer);
        pathAttributes2.add(pathAttribute2);
        ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])peerIp);
        bgpId = 0x20010000;
        locRibAsNum = 200;
        isIbgp = true;
        PathAttrNlriDetails attrList2 = new PathAttrNlriDetails();
        attrList2.setIdentifier(0L);
        attrList2.setPathAttribute(pathAttributes2);
        attrList2.setProtocolID(BgpNodeLSNlriVer4.ProtocolType.OSPF_V2);
        PathAttrNlriDetailsLocalRib list2 = new PathAttrNlriDetailsLocalRib(ipAddress, bgpId, (long)locRibAsNum, isIbgp, attrList2);
        BgpSelectionAlgo algo = new BgpSelectionAlgo();
        int result = algo.compare(list1, list2);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)1));
    }

    @Test
    public void selectionAlgoTest5() throws BgpParseException {
        byte[] peerIp = new byte[]{10, 10, 10, 10};
        LinkedList<LocalPref> pathAttributes1 = new LinkedList<LocalPref>();
        byte[] locPref = new byte[]{0, 5, 4, 0, 0, 0, 1};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(locPref);
        LocalPref pathAttribute1 = LocalPref.read((ChannelBuffer)buffer);
        pathAttributes1.add(pathAttribute1);
        IpAddress ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])peerIp);
        int bgpId = 0xA0A0101;
        int locRibAsNum = 100;
        boolean isIbgp = false;
        PathAttrNlriDetails attrList1 = new PathAttrNlriDetails();
        attrList1.setIdentifier(0L);
        attrList1.setPathAttribute(pathAttributes1);
        attrList1.setProtocolID(BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_ONE);
        PathAttrNlriDetailsLocalRib list1 = new PathAttrNlriDetailsLocalRib(ipAddress, bgpId, (long)locRibAsNum, isIbgp, attrList1);
        peerIp = new byte[]{11, 11, 11, 11};
        LinkedList<LocalPref> pathAttributes2 = new LinkedList<LocalPref>();
        locPref = new byte[]{0, 5, 4, 0, 0, 0, 10};
        buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(locPref);
        LocalPref pathAttribute2 = LocalPref.read((ChannelBuffer)buffer);
        pathAttributes2.add(pathAttribute2);
        ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])peerIp);
        bgpId = 0x20010000;
        locRibAsNum = 200;
        isIbgp = true;
        PathAttrNlriDetails attrList2 = new PathAttrNlriDetails();
        attrList2.setIdentifier(0L);
        attrList2.setPathAttribute(pathAttributes2);
        attrList2.setProtocolID(BgpNodeLSNlriVer4.ProtocolType.OSPF_V2);
        PathAttrNlriDetailsLocalRib list2 = new PathAttrNlriDetailsLocalRib(ipAddress, bgpId, (long)locRibAsNum, isIbgp, attrList2);
        BgpSelectionAlgo algo = new BgpSelectionAlgo();
        int result = algo.compare(list1, list2);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)-1));
    }

    @Test
    public void selectionAlgoTest6() throws BgpParseException {
        byte[] peerIp = new byte[]{10, 10, 10, 10};
        LinkedList<Origin> pathAttributes1 = new LinkedList<Origin>();
        byte[] origin = new byte[]{64, 1, 1, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(origin);
        Origin pathAttribute1 = Origin.read((ChannelBuffer)buffer);
        pathAttributes1.add(pathAttribute1);
        byte[] asPath = new byte[]{64, 2, 4, 2, 1, -3, -23};
        buffer.writeBytes(asPath);
        pathAttribute1 = AsPath.read((ChannelBuffer)buffer);
        pathAttributes1.add(pathAttribute1);
        IpAddress ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])peerIp);
        int bgpId = 0xA0A0101;
        int locRibAsNum = 100;
        boolean isIbgp = true;
        PathAttrNlriDetails attrList1 = new PathAttrNlriDetails();
        attrList1.setIdentifier(0L);
        attrList1.setPathAttribute(pathAttributes1);
        attrList1.setProtocolID(BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_ONE);
        PathAttrNlriDetailsLocalRib list1 = new PathAttrNlriDetailsLocalRib(ipAddress, bgpId, (long)locRibAsNum, isIbgp, attrList1);
        peerIp = new byte[]{11, 11, 11, 11};
        LinkedList<Origin> pathAttributes2 = new LinkedList<Origin>();
        origin = new byte[]{64, 1, 1, 0};
        buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(origin);
        Origin pathAttribute2 = Origin.read((ChannelBuffer)buffer);
        pathAttributes2.add(pathAttribute2);
        asPath = new byte[]{64, 2, 4, 2, 1, -3, -23};
        buffer.writeBytes(asPath);
        pathAttribute2 = AsPath.read((ChannelBuffer)buffer);
        pathAttributes2.add(pathAttribute2);
        ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])peerIp);
        bgpId = 0x20010000;
        locRibAsNum = 200;
        isIbgp = false;
        PathAttrNlriDetails attrList2 = new PathAttrNlriDetails();
        attrList2.setIdentifier(0L);
        attrList2.setPathAttribute(pathAttributes2);
        attrList2.setProtocolID(BgpNodeLSNlriVer4.ProtocolType.OSPF_V2);
        PathAttrNlriDetailsLocalRib list2 = new PathAttrNlriDetailsLocalRib(ipAddress, bgpId, (long)locRibAsNum, false, attrList2);
        BgpSelectionAlgo algo = new BgpSelectionAlgo();
        int result = algo.compare(list1, list2);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)-1));
    }

    @Test
    public void selectionAlgoTest7() throws BgpParseException {
        byte[] peerIp = new byte[]{10, 10, 10, 10};
        LinkedList<Origin> pathAttributes1 = new LinkedList<Origin>();
        byte[] origin = new byte[]{64, 1, 1, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(origin);
        Origin pathAttribute1 = Origin.read((ChannelBuffer)buffer);
        pathAttributes1.add(pathAttribute1);
        byte[] asPath = new byte[]{64, 2, 4, 2, 1, -3, -23};
        buffer.writeBytes(asPath);
        pathAttribute1 = AsPath.read((ChannelBuffer)buffer);
        pathAttributes1.add(pathAttribute1);
        IpAddress ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])peerIp);
        Integer bgpId = 0xA0A0A00;
        int locRibAsNum = 100;
        boolean isIbgp = false;
        PathAttrNlriDetails attrList1 = new PathAttrNlriDetails();
        attrList1.setIdentifier(0L);
        attrList1.setPathAttribute(pathAttributes1);
        attrList1.setProtocolID(BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_ONE);
        PathAttrNlriDetailsLocalRib list1 = new PathAttrNlriDetailsLocalRib(ipAddress, bgpId.intValue(), (long)locRibAsNum, isIbgp, attrList1);
        peerIp = new byte[]{11, 11, 11, 11};
        LinkedList<Origin> pathAttributes2 = new LinkedList<Origin>();
        origin = new byte[]{64, 1, 1, 0};
        buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(origin);
        Origin pathAttribute2 = Origin.read((ChannelBuffer)buffer);
        pathAttributes2.add(pathAttribute2);
        asPath = new byte[]{64, 2, 4, 2, 1, -3, -23};
        buffer.writeBytes(asPath);
        pathAttribute2 = AsPath.read((ChannelBuffer)buffer);
        pathAttributes2.add(pathAttribute2);
        ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])peerIp);
        bgpId = 0xB0A0A00;
        locRibAsNum = 200;
        isIbgp = false;
        PathAttrNlriDetails attrList2 = new PathAttrNlriDetails();
        attrList2.setIdentifier(0L);
        attrList2.setPathAttribute(pathAttributes2);
        attrList2.setProtocolID(BgpNodeLSNlriVer4.ProtocolType.OSPF_V2);
        PathAttrNlriDetailsLocalRib list2 = new PathAttrNlriDetailsLocalRib(ipAddress, bgpId.intValue(), (long)locRibAsNum, isIbgp, attrList2);
        BgpSelectionAlgo algo = new BgpSelectionAlgo();
        int result = algo.compare(list1, list2);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)1));
    }

    @Test
    public void selectionAlgoTest8() throws BgpParseException {
        byte[] peerIp = new byte[]{11, 11, 11, 11};
        LinkedList<Origin> pathAttributes1 = new LinkedList<Origin>();
        byte[] origin = new byte[]{64, 1, 1, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(origin);
        Origin pathAttribute1 = Origin.read((ChannelBuffer)buffer);
        pathAttributes1.add(pathAttribute1);
        byte[] asPath = new byte[]{64, 2, 4, 2, 1, -3, -23};
        buffer.writeBytes(asPath);
        pathAttribute1 = AsPath.read((ChannelBuffer)buffer);
        pathAttributes1.add(pathAttribute1);
        IpAddress ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])peerIp);
        Integer bgpId = 0xA0A0A00;
        int locRibAsNum = 100;
        boolean isIbgp = false;
        PathAttrNlriDetails attrList1 = new PathAttrNlriDetails();
        attrList1.setIdentifier(0L);
        attrList1.setPathAttribute(pathAttributes1);
        attrList1.setProtocolID(BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_ONE);
        PathAttrNlriDetailsLocalRib list1 = new PathAttrNlriDetailsLocalRib(ipAddress, bgpId.intValue(), (long)locRibAsNum, isIbgp, attrList1);
        peerIp = new byte[]{10, 10, 10, 10};
        LinkedList<Origin> pathAttributes2 = new LinkedList<Origin>();
        origin = new byte[]{64, 1, 1, 0};
        buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(origin);
        Origin pathAttribute2 = Origin.read((ChannelBuffer)buffer);
        pathAttributes2.add(pathAttribute2);
        asPath = new byte[]{64, 2, 4, 2, 1, -3, -23};
        buffer.writeBytes(asPath);
        pathAttribute2 = AsPath.read((ChannelBuffer)buffer);
        pathAttributes2.add(pathAttribute2);
        ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])peerIp);
        bgpId = 0xA0A0A00;
        locRibAsNum = 200;
        isIbgp = false;
        PathAttrNlriDetails attrList2 = new PathAttrNlriDetails();
        attrList2.setIdentifier(0L);
        attrList2.setPathAttribute(pathAttributes2);
        attrList2.setProtocolID(BgpNodeLSNlriVer4.ProtocolType.OSPF_V2);
        PathAttrNlriDetailsLocalRib list2 = new PathAttrNlriDetailsLocalRib(ipAddress, bgpId.intValue(), (long)locRibAsNum, isIbgp, attrList2);
        BgpSelectionAlgo algo = new BgpSelectionAlgo();
        int result = algo.compare(list1, list2);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)-1));
    }

    @Test
    public void selectionAlgoTest9() throws BgpParseException {
        byte[] peerIp = new byte[]{10, 10, 10, 10};
        LinkedList<Origin> pathAttributes1 = new LinkedList<Origin>();
        byte[] origin = new byte[]{64, 1, 1, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(origin);
        Origin pathAttribute1 = Origin.read((ChannelBuffer)buffer);
        pathAttributes1.add(pathAttribute1);
        byte[] asPath = new byte[]{64, 2, 4, 2, 1, -3, -23};
        buffer.writeBytes(asPath);
        pathAttribute1 = AsPath.read((ChannelBuffer)buffer);
        pathAttributes1.add(pathAttribute1);
        IpAddress ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])peerIp);
        Integer bgpId = 0xA0A0A00;
        int locRibAsNum = 100;
        boolean isIbgp = false;
        PathAttrNlriDetails attrList1 = new PathAttrNlriDetails();
        attrList1.setIdentifier(0L);
        attrList1.setPathAttribute(pathAttributes1);
        attrList1.setProtocolID(BgpNodeLSNlriVer4.ProtocolType.ISIS_LEVEL_ONE);
        PathAttrNlriDetailsLocalRib list1 = new PathAttrNlriDetailsLocalRib(ipAddress, bgpId.intValue(), (long)locRibAsNum, isIbgp, attrList1);
        peerIp = new byte[]{10, 10, 10, 10};
        LinkedList<Origin> pathAttributes2 = new LinkedList<Origin>();
        origin = new byte[]{64, 1, 1, 0};
        buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(origin);
        Origin pathAttribute2 = Origin.read((ChannelBuffer)buffer);
        pathAttributes2.add(pathAttribute2);
        asPath = new byte[]{64, 2, 4, 2, 1, -3, -23};
        buffer.writeBytes(asPath);
        pathAttribute2 = AsPath.read((ChannelBuffer)buffer);
        pathAttributes2.add(pathAttribute2);
        ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])peerIp);
        bgpId = 0xA0A0A00;
        locRibAsNum = 200;
        isIbgp = false;
        PathAttrNlriDetails attrList2 = new PathAttrNlriDetails();
        attrList2.setIdentifier(0L);
        attrList2.setPathAttribute(pathAttributes2);
        attrList2.setProtocolID(BgpNodeLSNlriVer4.ProtocolType.OSPF_V2);
        PathAttrNlriDetailsLocalRib list2 = new PathAttrNlriDetailsLocalRib(ipAddress, bgpId.intValue(), (long)locRibAsNum, isIbgp, attrList2);
        BgpSelectionAlgo algo = new BgpSelectionAlgo();
        int result = algo.compare(list1, list2);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)0));
    }
}

