/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgp.controller.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.bgp.controller.BgpCfg;
import org.onosproject.bgp.controller.BgpController;
import org.onosproject.bgp.controller.BgpId;
import org.onosproject.bgp.controller.BgpLocalRib;
import org.onosproject.bgp.controller.BgpNodeListener;
import org.onosproject.bgp.controller.BgpPeer;
import org.onosproject.bgp.controller.BgpPeerManager;
import org.onosproject.bgp.controller.impl.BgpConfig;
import org.onosproject.bgp.controller.impl.BgpLocalRibImpl;
import org.onosproject.bgp.controller.impl.BgpPacketStatsImpl;
import org.onosproject.bgp.controller.impl.BgpPeerImpl;
import org.onosproject.bgp.controller.impl.BgpSessionInfoImpl;
import org.onosproject.bgp.controller.impl.Controller;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.protocol.BgpMessage;
import org.onosproject.bgpio.protocol.BgpUpdateMsg;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.types.MpReachNlri;
import org.onosproject.bgpio.types.MpUnReachNlri;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class BgpControllerImpl
implements BgpController {
    private static final Logger log = LoggerFactory.getLogger(BgpControllerImpl.class);
    protected ConcurrentHashMap<BgpId, BgpPeer> connectedPeers = new ConcurrentHashMap();
    protected BgpPeerManagerImpl peerManager = new BgpPeerManagerImpl();
    private BgpLocalRib bgplocalRib = new BgpLocalRibImpl(this);
    private BgpLocalRib bgplocalRibVpn = new BgpLocalRibImpl(this);
    protected Set<BgpNodeListener> bgpNodeListener = new CopyOnWriteArraySet<BgpNodeListener>();
    final Controller ctrl = new Controller(this);
    private BgpConfig bgpconfig = new BgpConfig(this);

    @Activate
    public void activate() {
        this.ctrl.start();
        log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.closeConnectedPeers();
        this.ctrl.stop();
        log.info("Stopped");
    }

    public Iterable<BgpPeer> getPeers() {
        return this.connectedPeers.values();
    }

    public BgpPeer getPeer(BgpId bgpId) {
        return this.connectedPeers.get(bgpId);
    }

    public void addListener(BgpNodeListener listener) {
        this.bgpNodeListener.add(listener);
    }

    public void removeListener(BgpNodeListener listener) {
        this.bgpNodeListener.remove(listener);
    }

    public Set<BgpNodeListener> listener() {
        return this.bgpNodeListener;
    }

    public void writeMsg(BgpId bgpId, BgpMessage msg) {
        this.getPeer(bgpId).sendMessage(msg);
    }

    public void processBgpPacket(BgpId bgpId, BgpMessage msg) throws BgpParseException {
        BgpPeer peer = this.getPeer(bgpId);
        switch (msg.getType()) {
            case OPEN: {
                break;
            }
            case KEEP_ALIVE: {
                break;
            }
            case NOTIFICATION: {
                break;
            }
            case UPDATE: {
                BgpUpdateMsg updateMsg = (BgpUpdateMsg)msg;
                List pathAttr = updateMsg.bgpPathAttributes().pathAttributes();
                if (pathAttr == null) {
                    log.debug("llPathAttr is null, cannot process update message");
                    break;
                }
                Iterator listIterator = pathAttr.iterator();
                boolean isLinkstate = false;
                boolean isFlowSpec = false;
                while (listIterator.hasNext()) {
                    BgpValueType attr = (BgpValueType)listIterator.next();
                    if (attr instanceof MpReachNlri) {
                        MpReachNlri mpReach = (MpReachNlri)attr;
                        if (mpReach.bgpFlowSpecInfo() == null) {
                            isLinkstate = true;
                            continue;
                        }
                        isFlowSpec = true;
                        continue;
                    }
                    if (!(attr instanceof MpUnReachNlri)) continue;
                    MpUnReachNlri mpUnReach = (MpUnReachNlri)attr;
                    if (mpUnReach.bgpFlowSpecInfo() == null) {
                        isLinkstate = true;
                        continue;
                    }
                    isFlowSpec = true;
                }
                if (isLinkstate) {
                    peer.buildAdjRibIn(pathAttr);
                    break;
                }
                if (!isFlowSpec) break;
                peer.buildFlowSpecRib(pathAttr);
                break;
            }
        }
    }

    public void closeConnectedPeers() {
        for (BgpId id : this.connectedPeers.keySet()) {
            BgpPeer bgpPeer = this.getPeer(id);
            bgpPeer.disconnectPeer();
        }
    }

    public Controller controller() {
        return this.ctrl;
    }

    public ConcurrentHashMap<BgpId, BgpPeer> connectedPeers() {
        return this.connectedPeers;
    }

    public BgpPeerManagerImpl peerManager() {
        return this.peerManager;
    }

    public BgpCfg getConfig() {
        return this.bgpconfig;
    }

    public int connectedPeerCount() {
        return this.connectedPeers.size();
    }

    public BgpLocalRib bgpLocalRib() {
        return this.bgplocalRib;
    }

    public BgpLocalRib bgpLocalRibVpn() {
        return this.bgplocalRibVpn;
    }

    public class BgpPeerManagerImpl
    implements BgpPeerManager {
        private final Logger log = LoggerFactory.getLogger(BgpPeerManagerImpl.class);
        private final Lock peerLock = new ReentrantLock();

        public boolean addConnectedPeer(BgpId bgpId, BgpPeer bgpPeer) {
            if (BgpControllerImpl.this.connectedPeers.get(bgpId) != null) {
                this.log.error("Trying to add connectedPeer but found previous value for bgp ip: {}", (Object)bgpId.toString());
                return false;
            }
            this.log.debug("Added Peer {}", (Object)bgpId.toString());
            BgpControllerImpl.this.connectedPeers.put(bgpId, bgpPeer);
            return true;
        }

        public boolean isPeerConnected(BgpId bgpId) {
            if (BgpControllerImpl.this.connectedPeers.get(bgpId) == null) {
                this.log.error("Is peer connected: bgpIp {}.", (Object)bgpId.toString());
                return false;
            }
            return true;
        }

        public void removeConnectedPeer(BgpId bgpId) {
            BgpControllerImpl.this.connectedPeers.remove(bgpId);
        }

        public BgpPeer getPeer(BgpId bgpId) {
            return BgpControllerImpl.this.connectedPeers.get(bgpId);
        }

        public BgpPeer getBgpPeerInstance(BgpController bgpController, BgpSessionInfoImpl sessionInfo, BgpPacketStatsImpl pktStats) {
            BgpPeerImpl bgpPeer = new BgpPeerImpl(bgpController, sessionInfo, pktStats);
            return bgpPeer;
        }
    }
}

