/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgp.controller.impl;

import com.google.common.base.MoreObjects;
import java.util.Map;
import java.util.TreeMap;
import org.onosproject.bgpio.protocol.flowspec.BgpFlowSpecDetails;
import org.onosproject.bgpio.protocol.flowspec.BgpFlowSpecPrefix;
import org.onosproject.bgpio.types.RouteDistinguisher;

public class BgpFlowSpecRib {
    private Map<BgpFlowSpecPrefix, BgpFlowSpecDetails> flowSpecTree = new TreeMap<BgpFlowSpecPrefix, BgpFlowSpecDetails>();
    private Map<RouteDistinguisher, Map<BgpFlowSpecPrefix, BgpFlowSpecDetails>> vpnFlowSpecTree = new TreeMap<RouteDistinguisher, Map<BgpFlowSpecPrefix, BgpFlowSpecDetails>>();

    public Map<BgpFlowSpecPrefix, BgpFlowSpecDetails> flowSpecTree() {
        return this.flowSpecTree;
    }

    public Map<RouteDistinguisher, Map<BgpFlowSpecPrefix, BgpFlowSpecDetails>> vpnFlowSpecTree() {
        return this.vpnFlowSpecTree;
    }

    public void add(BgpFlowSpecPrefix prefix, BgpFlowSpecDetails flowSpec) {
        if (this.flowSpecTree.containsKey(prefix)) {
            this.flowSpecTree.replace(prefix, flowSpec);
        } else {
            this.flowSpecTree.put(prefix, flowSpec);
        }
    }

    public void delete(BgpFlowSpecPrefix flowSpec) {
        if (this.flowSpecTree.containsKey(flowSpec)) {
            this.flowSpecTree.remove(flowSpec);
        }
    }

    public void add(RouteDistinguisher routeDistinguisher, BgpFlowSpecPrefix prefix, BgpFlowSpecDetails flowSpec) {
        Map<Object, Object> fsTree;
        if (!this.vpnFlowSpecTree.containsKey(routeDistinguisher)) {
            fsTree = new TreeMap();
            this.vpnFlowSpecTree.put(routeDistinguisher, fsTree);
        } else {
            fsTree = this.vpnFlowSpecTree().get(routeDistinguisher);
        }
        if (fsTree.containsKey(prefix)) {
            fsTree.replace(prefix, flowSpec);
        } else {
            fsTree.put(prefix, flowSpec);
        }
    }

    public void delete(RouteDistinguisher routeDistinguisher, BgpFlowSpecPrefix flowSpecPrefix) {
        if (this.vpnFlowSpecTree.containsKey(routeDistinguisher)) {
            Map<BgpFlowSpecPrefix, BgpFlowSpecDetails> fsTree = this.vpnFlowSpecTree().get(routeDistinguisher);
            fsTree.remove(flowSpecPrefix);
            if (fsTree.size() == 0) {
                this.vpnFlowSpecTree.remove(routeDistinguisher);
            }
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("flowSpecTree", this.flowSpecTree).add("vpnFlowSpecTree", this.vpnFlowSpecTree).toString();
    }
}

