/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgp.controller.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import org.jboss.netty.channel.Channel;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onosproject.bgp.controller.BgpController;
import org.onosproject.bgp.controller.BgpLocalRib;
import org.onosproject.bgp.controller.BgpPeer;
import org.onosproject.bgp.controller.BgpSessionInfo;
import org.onosproject.bgp.controller.impl.AdjRibIn;
import org.onosproject.bgp.controller.impl.BgpFlowSpecRib;
import org.onosproject.bgp.controller.impl.BgpLocalRibImpl;
import org.onosproject.bgp.controller.impl.BgpPacketStatsImpl;
import org.onosproject.bgp.controller.impl.Controller;
import org.onosproject.bgp.controller.impl.VpnAdjRibIn;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.protocol.BgpFactories;
import org.onosproject.bgpio.protocol.BgpFactory;
import org.onosproject.bgpio.protocol.BgpLSNlri;
import org.onosproject.bgpio.protocol.BgpMessage;
import org.onosproject.bgpio.protocol.BgpUpdateMsg;
import org.onosproject.bgpio.protocol.BgpVersion;
import org.onosproject.bgpio.protocol.flowspec.BgpFlowSpecDetails;
import org.onosproject.bgpio.protocol.flowspec.BgpFlowSpecPrefix;
import org.onosproject.bgpio.protocol.linkstate.BgpLinkLsNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.BgpNodeLSNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.BgpPrefixIPv4LSNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.PathAttrNlriDetails;
import org.onosproject.bgpio.types.As4Path;
import org.onosproject.bgpio.types.AsPath;
import org.onosproject.bgpio.types.BgpExtendedCommunity;
import org.onosproject.bgpio.types.BgpFsDestinationPrefix;
import org.onosproject.bgpio.types.BgpFsSourcePrefix;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.types.LocalPref;
import org.onosproject.bgpio.types.Med;
import org.onosproject.bgpio.types.MpReachNlri;
import org.onosproject.bgpio.types.MpUnReachNlri;
import org.onosproject.bgpio.types.MultiProtocolExtnCapabilityTlv;
import org.onosproject.bgpio.types.Origin;
import org.onosproject.bgpio.types.RouteDistinguisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpPeerImpl
implements BgpPeer {
    protected final Logger log = LoggerFactory.getLogger(BgpPeerImpl.class);
    private static final String SHUTDOWN_MSG = "Worker has already been shutdown";
    private BgpController bgpController;
    private Channel channel;
    protected String channelId;
    private boolean connected;
    protected boolean isHandShakeComplete = false;
    private BgpSessionInfo sessionInfo;
    private BgpPacketStatsImpl pktStats;
    private BgpLocalRib bgplocalRib;
    private BgpLocalRib bgplocalRibVpn;
    private AdjRibIn adjRib;
    private VpnAdjRibIn vpnAdjRib;
    private BgpFlowSpecRib flowSpecRibOut;
    private BgpFlowSpecRib flowSpecRibIn;

    public BgpFlowSpecRib flowSpecRibOut() {
        return this.flowSpecRibOut;
    }

    public BgpFlowSpecRib flowSpecRibIn() {
        return this.flowSpecRibIn;
    }

    public AdjRibIn adjacencyRib() {
        return this.adjRib;
    }

    public VpnAdjRibIn vpnAdjacencyRib() {
        return this.vpnAdjRib;
    }

    public BgpSessionInfo sessionInfo() {
        return this.sessionInfo;
    }

    public BgpPeerImpl(BgpController bgpController, BgpSessionInfo sessionInfo, BgpPacketStatsImpl pktStats) {
        this.bgpController = bgpController;
        this.sessionInfo = sessionInfo;
        this.pktStats = pktStats;
        this.bgplocalRib = bgpController.bgpLocalRib();
        this.bgplocalRibVpn = bgpController.bgpLocalRibVpn();
        this.adjRib = new AdjRibIn();
        this.vpnAdjRib = new VpnAdjRibIn();
        this.flowSpecRibOut = new BgpFlowSpecRib();
        this.flowSpecRibIn = new BgpFlowSpecRib();
    }

    public final boolean isCapabilitySupported(short type, short afi, byte sAfi) {
        List capability = this.sessionInfo.remoteBgpCapability();
        ListIterator listIterator = capability.listIterator();
        while (listIterator.hasNext()) {
            MultiProtocolExtnCapabilityTlv temp;
            BgpValueType tlv = (BgpValueType)listIterator.next();
            if (tlv.getType() != type || tlv.getType() != 1 || (temp = (MultiProtocolExtnCapabilityTlv)tlv).getAfi() != afi || temp.getSafi() != sAfi) continue;
            return true;
        }
        return false;
    }

    public final void sendFlowSpecUpdateMessageToPeer(BgpPeer.FlowSpecOperation operType, BgpFlowSpecDetails flowSpec) {
        LinkedList<Object> attributesList = new LinkedList<Object>();
        byte sessionType = this.sessionInfo.isIbgpSession() ? (byte)0 : 1;
        byte sAfi = -123;
        boolean isFsCapabilitySet = this.isCapabilitySupported((short)1, (short)1, (byte)-123);
        boolean isVpnFsCapabilitySet = this.isCapabilitySupported((short)1, (short)1, (byte)-122);
        if (!isFsCapabilitySet && !isVpnFsCapabilitySet) {
            this.log.debug("Peer do not support BGP flow spec capability", (Object)this.channel.getRemoteAddress());
            return;
        }
        if (isVpnFsCapabilitySet) {
            sAfi = -122;
        }
        attributesList.add(new Origin(sessionType));
        if (sessionType != 0) {
            ArrayList aspathSet;
            if (!this.bgpController.getConfig().getLargeASCapability()) {
                aspathSet = new ArrayList();
                ArrayList<Short> aspathSeq = new ArrayList<Short>();
                aspathSeq.add((short)this.bgpController.getConfig().getAsNumber());
                AsPath asPath = new AsPath(aspathSet, aspathSeq);
                attributesList.add(asPath);
            } else {
                aspathSet = new ArrayList();
                ArrayList<Integer> aspathSeq = new ArrayList<Integer>();
                aspathSeq.add(this.bgpController.getConfig().getAsNumber());
                As4Path as4Path = new As4Path(aspathSet, aspathSeq);
                attributesList.add(as4Path);
            }
            attributesList.add(new Med(0));
        } else {
            attributesList.add(new AsPath());
            attributesList.add(new Med(0));
            attributesList.add(new LocalPref(100));
        }
        attributesList.add(new BgpExtendedCommunity(flowSpec.fsActionTlv()));
        if (operType == BgpPeer.FlowSpecOperation.ADD) {
            attributesList.add(new MpReachNlri(flowSpec, 1, sAfi));
        } else if (operType == BgpPeer.FlowSpecOperation.DELETE) {
            attributesList.add(new MpUnReachNlri(flowSpec, 1, sAfi));
        }
        BgpUpdateMsg msg = Controller.getBgpMessageFactory4().updateMessageBuilder().setBgpPathAttributes(attributesList).build();
        this.log.debug("Sending Flow spec Update message to {}", (Object)this.channel.getRemoteAddress());
        this.channel.write(Collections.singletonList(msg));
    }

    public void updateFlowSpec(BgpPeer.FlowSpecOperation operType, BgpFlowSpecPrefix prefix, BgpFlowSpecDetails flowSpec) {
        Preconditions.checkNotNull((Object)operType, (Object)"flow specification operation type cannot be null");
        Preconditions.checkNotNull((Object)prefix, (Object)"flow specification prefix cannot be null");
        Preconditions.checkNotNull((Object)flowSpec, (Object)"flow specification details cannot be null");
        Preconditions.checkNotNull((Object)flowSpec.fsActionTlv(), (Object)"flow specification action cannot be null");
        if (operType == BgpPeer.FlowSpecOperation.ADD) {
            if (flowSpec.routeDistinguisher() == null) {
                if (this.flowSpecRibOut.flowSpecTree().containsKey(prefix)) {
                    this.sendFlowSpecUpdateMessageToPeer(BgpPeer.FlowSpecOperation.DELETE, this.flowSpecRibOut.flowSpecTree().get(prefix));
                }
                this.flowSpecRibOut.add(prefix, flowSpec);
            } else {
                Map<BgpFlowSpecPrefix, BgpFlowSpecDetails> fsTree;
                if (this.flowSpecRibOut.vpnFlowSpecTree().containsKey(flowSpec.routeDistinguisher()) && (fsTree = this.flowSpecRibOut.vpnFlowSpecTree().get(flowSpec.routeDistinguisher())).containsKey(prefix)) {
                    this.sendFlowSpecUpdateMessageToPeer(BgpPeer.FlowSpecOperation.DELETE, fsTree.get(prefix));
                }
                this.flowSpecRibOut.add(flowSpec.routeDistinguisher(), prefix, flowSpec);
            }
        } else if (operType == BgpPeer.FlowSpecOperation.DELETE) {
            if (flowSpec.routeDistinguisher() == null) {
                this.flowSpecRibOut.delete(prefix);
            } else {
                this.flowSpecRibOut.delete(flowSpec.routeDistinguisher(), prefix);
            }
        }
        this.sendFlowSpecUpdateMessageToPeer(operType, flowSpec);
    }

    public void buildAdjRibIn(List<BgpValueType> pathAttr) throws BgpParseException {
        ListIterator<BgpValueType> iterator = pathAttr.listIterator();
        while (iterator.hasNext()) {
            List nlri;
            BgpValueType attr = iterator.next();
            if (attr instanceof MpReachNlri) {
                nlri = ((MpReachNlri)attr).mpReachNlri();
                this.callAdd(this, nlri, pathAttr);
            }
            if (!(attr instanceof MpUnReachNlri)) continue;
            nlri = ((MpUnReachNlri)attr).mpUnReachNlri();
            this.callRemove(this, nlri);
        }
    }

    public void buildFlowSpecRib(List<BgpValueType> pathAttr) throws BgpParseException {
        ListIterator<Object> iterator = pathAttr.listIterator();
        BgpFlowSpecDetails bgpFlowSpecDetails = new BgpFlowSpecDetails();
        BgpPeer.FlowSpecOperation operType = BgpPeer.FlowSpecOperation.UPDATE;
        while (iterator.hasNext()) {
            BgpValueType attr = iterator.next();
            if (attr instanceof MpReachNlri) {
                MpReachNlri mpReach = (MpReachNlri)attr;
                bgpFlowSpecDetails.setFlowSpecComponents(mpReach.bgpFlowSpecInfo().flowSpecComponents());
                bgpFlowSpecDetails.setRouteDistinguiher(mpReach.bgpFlowSpecInfo().routeDistinguisher());
                operType = BgpPeer.FlowSpecOperation.ADD;
            }
            if (attr instanceof BgpExtendedCommunity) {
                BgpExtendedCommunity extCommunity = (BgpExtendedCommunity)attr;
                bgpFlowSpecDetails.setFsActionTlv(extCommunity.fsActionTlv());
            }
            if (!(attr instanceof MpUnReachNlri)) continue;
            MpUnReachNlri mpUnReach = (MpUnReachNlri)attr;
            bgpFlowSpecDetails.setFlowSpecComponents(mpUnReach.bgpFlowSpecInfo().flowSpecComponents());
            bgpFlowSpecDetails.setRouteDistinguiher(mpUnReach.bgpFlowSpecInfo().routeDistinguisher());
            operType = BgpPeer.FlowSpecOperation.DELETE;
        }
        iterator = bgpFlowSpecDetails.flowSpecComponents().listIterator();
        IpPrefix destIpPrefix = null;
        IpPrefix srcIpPrefix = null;
        while (iterator.hasNext()) {
            BgpValueType fsAttr = (BgpValueType)iterator.next();
            if (fsAttr instanceof BgpFsDestinationPrefix) {
                BgpFsDestinationPrefix destinationPrefix = (BgpFsDestinationPrefix)fsAttr;
                destIpPrefix = destinationPrefix.ipPrefix();
            }
            if (!(fsAttr instanceof BgpFsSourcePrefix)) continue;
            BgpFsSourcePrefix sourcePrefix = (BgpFsSourcePrefix)fsAttr;
            srcIpPrefix = sourcePrefix.ipPrefix();
        }
        BgpFlowSpecPrefix prefix = new BgpFlowSpecPrefix(destIpPrefix, srcIpPrefix);
        if (operType == BgpPeer.FlowSpecOperation.ADD) {
            if (bgpFlowSpecDetails.routeDistinguisher() == null) {
                this.flowSpecRibIn.add(prefix, bgpFlowSpecDetails);
            } else {
                this.flowSpecRibIn.add(bgpFlowSpecDetails.routeDistinguisher(), prefix, bgpFlowSpecDetails);
            }
        } else if (operType == BgpPeer.FlowSpecOperation.DELETE) {
            if (bgpFlowSpecDetails.routeDistinguisher() == null) {
                this.flowSpecRibIn.delete(prefix);
            } else {
                this.flowSpecRibIn.delete(bgpFlowSpecDetails.routeDistinguisher(), prefix);
            }
        }
    }

    public void callAdd(BgpPeerImpl peerImpl, List<BgpLSNlri> nlri, List<BgpValueType> pathAttr) throws BgpParseException {
        ListIterator<BgpLSNlri> listIterator = nlri.listIterator();
        while (listIterator.hasNext()) {
            PathAttrNlriDetails details;
            BgpLSNlri nlriInfo = listIterator.next();
            if (nlriInfo instanceof BgpNodeLSNlriVer4) {
                details = this.setPathAttrDetails(nlriInfo, pathAttr);
                if (!((BgpNodeLSNlriVer4)nlriInfo).isVpnPresent()) {
                    this.adjRib.add(nlriInfo, details);
                    this.bgplocalRib.add(this.sessionInfo(), nlriInfo, details);
                    continue;
                }
                this.vpnAdjRib.addVpn(nlriInfo, details, ((BgpNodeLSNlriVer4)nlriInfo).getRouteDistinguisher());
                this.bgplocalRibVpn.add(this.sessionInfo(), nlriInfo, details, ((BgpNodeLSNlriVer4)nlriInfo).getRouteDistinguisher());
                continue;
            }
            if (nlriInfo instanceof BgpLinkLsNlriVer4) {
                details = this.setPathAttrDetails(nlriInfo, pathAttr);
                if (!((BgpLinkLsNlriVer4)nlriInfo).isVpnPresent()) {
                    this.adjRib.add(nlriInfo, details);
                    this.bgplocalRib.add(this.sessionInfo(), nlriInfo, details);
                    continue;
                }
                this.vpnAdjRib.addVpn(nlriInfo, details, ((BgpLinkLsNlriVer4)nlriInfo).getRouteDistinguisher());
                this.bgplocalRibVpn.add(this.sessionInfo(), nlriInfo, details, ((BgpLinkLsNlriVer4)nlriInfo).getRouteDistinguisher());
                continue;
            }
            if (!(nlriInfo instanceof BgpPrefixIPv4LSNlriVer4)) continue;
            details = this.setPathAttrDetails(nlriInfo, pathAttr);
            if (!((BgpPrefixIPv4LSNlriVer4)nlriInfo).isVpnPresent()) {
                this.adjRib.add(nlriInfo, details);
                this.bgplocalRib.add(this.sessionInfo(), nlriInfo, details);
                continue;
            }
            this.vpnAdjRib.addVpn(nlriInfo, details, ((BgpPrefixIPv4LSNlriVer4)nlriInfo).getRouteDistinguisher());
            this.bgplocalRibVpn.add(this.sessionInfo(), nlriInfo, details, ((BgpPrefixIPv4LSNlriVer4)nlriInfo).getRouteDistinguisher());
        }
    }

    public PathAttrNlriDetails setPathAttrDetails(BgpLSNlri nlriInfo, List<BgpValueType> pathAttr) throws BgpParseException {
        PathAttrNlriDetails details = new PathAttrNlriDetails();
        details.setProtocolID(nlriInfo.getProtocolId());
        details.setIdentifier(nlriInfo.getIdentifier());
        details.setPathAttribute(pathAttr);
        return details;
    }

    public void callRemove(BgpPeerImpl peerImpl, List<BgpLSNlri> nlri) {
        ListIterator<BgpLSNlri> listIterator = nlri.listIterator();
        while (listIterator.hasNext()) {
            BgpLSNlri nlriInfo = listIterator.next();
            if (nlriInfo instanceof BgpNodeLSNlriVer4) {
                if (!((BgpNodeLSNlriVer4)nlriInfo).isVpnPresent()) {
                    this.adjRib.remove(nlriInfo);
                    this.bgplocalRib.delete(nlriInfo);
                    continue;
                }
                this.vpnAdjRib.removeVpn(nlriInfo, ((BgpNodeLSNlriVer4)nlriInfo).getRouteDistinguisher());
                this.bgplocalRibVpn.delete(nlriInfo, ((BgpNodeLSNlriVer4)nlriInfo).getRouteDistinguisher());
                continue;
            }
            if (nlriInfo instanceof BgpLinkLsNlriVer4) {
                if (!((BgpLinkLsNlriVer4)nlriInfo).isVpnPresent()) {
                    this.adjRib.remove(nlriInfo);
                    this.bgplocalRib.delete(nlriInfo);
                    continue;
                }
                this.vpnAdjRib.removeVpn(nlriInfo, ((BgpLinkLsNlriVer4)nlriInfo).getRouteDistinguisher());
                this.bgplocalRibVpn.delete(nlriInfo, ((BgpLinkLsNlriVer4)nlriInfo).getRouteDistinguisher());
                continue;
            }
            if (!(nlriInfo instanceof BgpPrefixIPv4LSNlriVer4)) continue;
            if (!((BgpPrefixIPv4LSNlriVer4)nlriInfo).isVpnPresent()) {
                this.adjRib.remove(nlriInfo);
                this.bgplocalRib.delete(nlriInfo);
                continue;
            }
            this.vpnAdjRib.removeVpn(nlriInfo, ((BgpPrefixIPv4LSNlriVer4)nlriInfo).getRouteDistinguisher());
            this.bgplocalRibVpn.delete(nlriInfo, ((BgpPrefixIPv4LSNlriVer4)nlriInfo).getRouteDistinguisher());
        }
    }

    public AdjRibIn adjRib() {
        return this.adjRib;
    }

    public VpnAdjRibIn vpnAdjRib() {
        return this.vpnAdjRib;
    }

    public void updateLocalRibOnPeerDisconnect() {
        BgpLocalRibImpl localRib = (BgpLocalRibImpl)this.bgplocalRib;
        BgpLocalRibImpl localRibVpn = (BgpLocalRibImpl)this.bgplocalRibVpn;
        localRib.localRibUpdate(this.adjacencyRib());
        localRibVpn.localRibUpdate(this.vpnAdjacencyRib());
    }

    public void updateFlowSpecOnPeerDisconnect() {
        boolean isVpnCapabilitySet;
        boolean isCapabilitySet = this.isCapabilitySupported((short)1, (short)1, (byte)-123);
        if (isCapabilitySet) {
            Set<BgpFlowSpecPrefix> flowSpecKeys = this.flowSpecRibOut.flowSpecTree().keySet();
            for (BgpFlowSpecPrefix key : flowSpecKeys) {
                BgpFlowSpecDetails flowSpecDetails = this.flowSpecRibOut.flowSpecTree().get(key);
                this.sendFlowSpecUpdateMessageToPeer(BgpPeer.FlowSpecOperation.DELETE, flowSpecDetails);
            }
        }
        if (isVpnCapabilitySet = this.isCapabilitySupported((short)1, (short)1, (byte)-122)) {
            Set<RouteDistinguisher> flowSpecKeys = this.flowSpecRibOut.vpnFlowSpecTree().keySet();
            for (RouteDistinguisher key : flowSpecKeys) {
                Map<BgpFlowSpecPrefix, BgpFlowSpecDetails> fsTree = this.flowSpecRibOut.vpnFlowSpecTree().get(key);
                Set<BgpFlowSpecPrefix> fsKeys = fsTree.keySet();
                for (BgpFlowSpecPrefix fsKey : fsKeys) {
                    BgpFlowSpecDetails flowSpecDetails = this.flowSpecRibOut.flowSpecTree().get(fsKey);
                    this.sendFlowSpecUpdateMessageToPeer(BgpPeer.FlowSpecOperation.DELETE, flowSpecDetails);
                }
            }
        }
    }

    public final void disconnectPeer() {
        this.updateFlowSpecOnPeerDisconnect();
        this.channel.close();
    }

    public final void sendMessage(BgpMessage m) {
        block2: {
            this.log.debug("Sending message to {}", (Object)this.channel.getRemoteAddress());
            try {
                this.channel.write(Collections.singletonList(m));
                this.pktStats.addOutPacket();
            }
            catch (RejectedExecutionException e) {
                this.log.warn(e.getMessage());
                if (e.getMessage().contains(SHUTDOWN_MSG)) break block2;
                throw e;
            }
        }
    }

    public final void sendMessage(List<BgpMessage> msgs) {
        block2: {
            try {
                this.channel.write(msgs);
                this.pktStats.addOutPacket(msgs.size());
            }
            catch (RejectedExecutionException e) {
                this.log.warn(e.getMessage());
                if (e.getMessage().contains(SHUTDOWN_MSG)) break block2;
                throw e;
            }
        }
    }

    public final boolean isConnected() {
        return this.connected;
    }

    public final void setConnected(boolean connected) {
        this.connected = connected;
    }

    public final void setChannel(Channel channel) {
        this.channel = channel;
        SocketAddress address = channel.getRemoteAddress();
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetAddress = (InetSocketAddress)address;
            IpAddress ipAddress = IpAddress.valueOf((InetAddress)inetAddress.getAddress());
            this.channelId = ipAddress.isIp4() ? ipAddress.toString() + ':' + inetAddress.getPort() : '[' + ipAddress.toString() + "]:" + inetAddress.getPort();
        }
    }

    public final Channel getChannel() {
        return this.channel;
    }

    public String channelId() {
        return this.channelId;
    }

    public BgpFactory factory() {
        return BgpFactories.getFactory((BgpVersion)this.sessionInfo.remoteBgpVersion());
    }

    public boolean isHandshakeComplete() {
        return this.isHandShakeComplete;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("channel", (Object)this.channelId()).add("BgpId", (Object)this.sessionInfo().remoteBgpId()).toString();
    }
}

