/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgp.controller.impl;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.onlab.util.Tools;
import org.onosproject.bgp.controller.BgpController;
import org.onosproject.bgp.controller.impl.BgpPipelineFactory;
import org.onosproject.bgpio.protocol.BgpFactories;
import org.onosproject.bgpio.protocol.BgpFactory;
import org.onosproject.bgpio.protocol.BgpVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Controller {
    private static final Logger log = LoggerFactory.getLogger(Controller.class);
    private static final BgpFactory FACTORY4 = BgpFactories.getFactory((BgpVersion)BgpVersion.BGP_4);
    private ChannelGroup cg;
    public Channel serverChannel;
    private static final short BGP_PORT_NUM = 179;
    private static final short PORT_NUM_ZERO = 0;
    private static boolean isPortNumSet = false;
    private final int workerThreads = 16;
    private final int peerWorkerThreads = 16;
    private long systemStartTime;
    private NioServerSocketChannelFactory serverExecFactory;
    private NioClientSocketChannelFactory peerExecFactory;
    private static ClientBootstrap peerBootstrap;
    private BgpController bgpController;
    private static final int SEND_BUFFER_SIZE = 0x400000;

    public Controller(BgpController bgpController) {
        this.bgpController = bgpController;
    }

    static BgpFactory getBgpMessageFactory4() {
        return FACTORY4;
    }

    public long getSystemStartTime() {
        return this.systemStartTime;
    }

    public void run() {
        try {
            peerBootstrap = this.createPeerBootStrap();
            peerBootstrap.setOption("reuseAddr", (Object)true);
            peerBootstrap.setOption("child.keepAlive", (Object)true);
            peerBootstrap.setOption("child.tcpNoDelay", (Object)true);
            peerBootstrap.setOption("child.sendBufferSize", (Object)0x400000);
            ServerBootstrap bootstrap = this.createServerBootStrap();
            bootstrap.setOption("reuseAddr", (Object)true);
            bootstrap.setOption("child.keepAlive", (Object)true);
            bootstrap.setOption("child.tcpNoDelay", (Object)true);
            bootstrap.setOption("child.sendBufferSize", (Object)0x400000);
            BgpPipelineFactory pfact = new BgpPipelineFactory(this.bgpController, true);
            bootstrap.setPipelineFactory((ChannelPipelineFactory)pfact);
            InetSocketAddress sa = new InetSocketAddress(Controller.getBgpPortNum());
            this.cg = new DefaultChannelGroup();
            this.serverChannel = bootstrap.bind((SocketAddress)sa);
            this.cg.add((Object)this.serverChannel);
            log.info("Listening for Peer connection on {}", (Object)sa);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ServerBootstrap createServerBootStrap() {
        this.serverExecFactory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(Tools.groupedThreads((String)"onos/bgp", (String)"boss-%d")), (Executor)Executors.newCachedThreadPool(Tools.groupedThreads((String)"onos/bgp", (String)"worker-%d")), 16);
        return new ServerBootstrap((ChannelFactory)this.serverExecFactory);
    }

    private ClientBootstrap createPeerBootStrap() {
        this.peerExecFactory = new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(Tools.groupedThreads((String)"onos/bgp", (String)"boss-%d")), (Executor)Executors.newCachedThreadPool(Tools.groupedThreads((String)"onos/bgp", (String)"worker-%d")), 16);
        return new ClientBootstrap((ChannelFactory)this.peerExecFactory);
    }

    public static ClientBootstrap peerBootstrap() {
        return peerBootstrap;
    }

    public void init() {
        this.systemStartTime = System.currentTimeMillis();
    }

    public Map<String, Long> getMemory() {
        HashMap<String, Long> m = new HashMap<String, Long>();
        Runtime runtime = Runtime.getRuntime();
        m.put("total", runtime.totalMemory());
        m.put("free", runtime.freeMemory());
        return m;
    }

    public Long getUptime() {
        RuntimeMXBean rb = ManagementFactory.getRuntimeMXBean();
        return rb.getUptime();
    }

    public void start() {
        log.info("Started");
        this.init();
        this.run();
    }

    public void stop() {
        log.info("Stopped");
        this.serverExecFactory.shutdown();
        this.peerExecFactory.shutdown();
        this.cg.close();
    }

    public static short getBgpPortNum() {
        if (isPortNumSet) {
            return 0;
        }
        return 179;
    }

    public void setBgpPortNum() {
        isPortNumSet = true;
    }
}

