/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.bgp.cfg.impl;

import java.util.List;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.bgp.controller.BgpCfg;
import org.onosproject.bgp.controller.BgpController;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.basics.SubjectFactories;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.provider.bgp.cfg.impl.BgpAppConfig;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class BgpCfgProvider
extends AbstractProvider {
    private static final Logger log = LoggerFactory.getLogger(BgpCfgProvider.class);
    static final String PROVIDER_ID = "org.onosproject.provider.bgp.cfg";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected BgpController bgpController;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigRegistry configRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigService configService;
    private final ConfigFactory configFactory = new ConfigFactory(SubjectFactories.APP_SUBJECT_FACTORY, BgpAppConfig.class, "bgpapp"){

        public BgpAppConfig createConfig() {
            return new BgpAppConfig();
        }
    };
    private final NetworkConfigListener configListener = new InternalConfigListener();
    private ApplicationId appId;

    public BgpCfgProvider() {
        super(new ProviderId("bgp", PROVIDER_ID));
    }

    @Activate
    public void activate(ComponentContext context) {
        this.appId = this.coreService.registerApplication(PROVIDER_ID);
        this.configService.addListener((EventListener)this.configListener);
        this.configRegistry.registerConfigFactory(this.configFactory);
        log.info("BGP cfg provider started");
    }

    @Deactivate
    public void deactivate(ComponentContext context) {
        this.configRegistry.unregisterConfigFactory(this.configFactory);
        this.configService.removeListener((EventListener)this.configListener);
    }

    void setBgpController(BgpController bgpController) {
        this.bgpController = bgpController;
    }

    private void readConfiguration() {
        BgpCfg bgpConfig = null;
        bgpConfig = this.bgpController.getConfig();
        BgpAppConfig config = (BgpAppConfig)this.configRegistry.getConfig((Object)this.appId, BgpAppConfig.class);
        if (config == null) {
            log.warn("No configuration found");
            return;
        }
        bgpConfig.setRouterId(config.routerId());
        bgpConfig.setAsNumber(config.localAs());
        bgpConfig.setLsCapability(config.lsCapability());
        bgpConfig.setHoldTime(config.holdTime());
        bgpConfig.setMaxSession(config.maxSession());
        bgpConfig.setLargeASCapability(config.largeAsCapability());
        List<BgpAppConfig.BgpPeerConfig> nodes = config.bgpPeer();
        for (int i = 0; i < nodes.size(); ++i) {
            String connectMode = nodes.get(i).connectMode();
            bgpConfig.addPeer(nodes.get(i).hostname(), nodes.get(i).asNumber(), nodes.get(i).holdTime());
            if (!connectMode.equals("active")) continue;
            bgpConfig.connectPeer(nodes.get(i).hostname());
        }
    }

    protected void bindBgpController(BgpController bgpController) {
        this.bgpController = bgpController;
    }

    protected void unbindBgpController(BgpController bgpController) {
        if (this.bgpController == bgpController) {
            this.bgpController = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindConfigRegistry(NetworkConfigRegistry networkConfigRegistry) {
        this.configRegistry = networkConfigRegistry;
    }

    protected void unbindConfigRegistry(NetworkConfigRegistry networkConfigRegistry) {
        if (this.configRegistry == networkConfigRegistry) {
            this.configRegistry = null;
        }
    }

    protected void bindConfigService(NetworkConfigService networkConfigService) {
        this.configService = networkConfigService;
    }

    protected void unbindConfigService(NetworkConfigService networkConfigService) {
        if (this.configService == networkConfigService) {
            this.configService = null;
        }
    }

    private class InternalConfigListener
    implements NetworkConfigListener {
        private InternalConfigListener() {
        }

        public void event(NetworkConfigEvent event) {
            if (!event.configClass().equals(BgpAppConfig.class)) {
                return;
            }
            switch ((NetworkConfigEvent.Type)event.type()) {
                case CONFIG_ADDED: {
                    BgpCfgProvider.this.readConfiguration();
                    break;
                }
                case CONFIG_UPDATED: {
                    BgpCfgProvider.this.readConfiguration();
                    break;
                }
            }
        }
    }
}

