/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.bgp.topology.impl;

import java.net.URI;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.ChassisId;
import org.onosproject.bgp.controller.BgpController;
import org.onosproject.bgp.controller.BgpDpid;
import org.onosproject.bgp.controller.BgpNodeListener;
import org.onosproject.bgpio.protocol.linkstate.BgpNodeLSNlriVer4;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultDeviceDescription;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceProvider;
import org.onosproject.net.device.DeviceProviderRegistry;
import org.onosproject.net.device.DeviceProviderService;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class BgpTopologyProvider
extends AbstractProvider
implements DeviceProvider {
    private static final Logger log = LoggerFactory.getLogger(BgpTopologyProvider.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceProviderRegistry deviceProviderRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected BgpController controller;
    private DeviceProviderService deviceProviderService;
    private InternalBgpProvider listener = new InternalBgpProvider();
    private static final String UNKNOWN = "unknown";

    public BgpTopologyProvider() {
        super(new ProviderId("bgp", "org.onosproject.provider.bgp"));
    }

    @Activate
    public void activate() {
        this.deviceProviderService = (DeviceProviderService)this.deviceProviderRegistry.register((Provider)this);
        this.controller.addListener((BgpNodeListener)this.listener);
    }

    @Deactivate
    public void deactivate() {
        this.controller.removeListener((BgpNodeListener)this.listener);
    }

    public void triggerProbe(DeviceId deviceId) {
    }

    public void roleChanged(DeviceId deviceId, MastershipRole newRole) {
    }

    public boolean isReachable(DeviceId deviceId) {
        return true;
    }

    protected void bindDeviceProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        this.deviceProviderRegistry = deviceProviderRegistry;
    }

    protected void unbindDeviceProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        if (this.deviceProviderRegistry == deviceProviderRegistry) {
            this.deviceProviderRegistry = null;
        }
    }

    protected void bindController(BgpController bgpController) {
        this.controller = bgpController;
    }

    protected void unbindController(BgpController bgpController) {
        if (this.controller == bgpController) {
            this.controller = null;
        }
    }

    private class InternalBgpProvider
    implements BgpNodeListener {
        private InternalBgpProvider() {
        }

        public void addNode(BgpNodeLSNlriVer4 nodeNlri) {
            log.debug("Add node {}", (Object)nodeNlri.toString());
            if (BgpTopologyProvider.this.deviceProviderService == null) {
                return;
            }
            BgpDpid nodeUri = new BgpDpid(nodeNlri);
            DeviceId deviceId = DeviceId.deviceId((URI)BgpDpid.uri((String)nodeUri.toString()));
            ChassisId cId = new ChassisId();
            DefaultDeviceDescription description = new DefaultDeviceDescription(BgpDpid.uri((String)nodeUri.toString()), Device.Type.ROUTER, BgpTopologyProvider.UNKNOWN, BgpTopologyProvider.UNKNOWN, BgpTopologyProvider.UNKNOWN, BgpTopologyProvider.UNKNOWN, cId, new SparseAnnotations[0]);
            BgpTopologyProvider.this.deviceProviderService.deviceConnected(deviceId, (DeviceDescription)description);
        }

        public void deleteNode(BgpNodeLSNlriVer4 nodeNlri) {
            log.debug("Delete node {}", (Object)nodeNlri.toString());
            if (BgpTopologyProvider.this.deviceProviderService == null) {
                return;
            }
            BgpDpid nodeUri = new BgpDpid(nodeNlri);
            BgpTopologyProvider.this.deviceProviderService.deviceDisconnected(DeviceId.deviceId((URI)BgpDpid.uri((String)nodeUri.toString())));
        }
    }
}

