/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.bgp.topology.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.bgp.controller.BgpCfg;
import org.onosproject.bgp.controller.BgpController;
import org.onosproject.bgp.controller.BgpId;
import org.onosproject.bgp.controller.BgpLocalRib;
import org.onosproject.bgp.controller.BgpNodeListener;
import org.onosproject.bgp.controller.BgpPeer;
import org.onosproject.bgp.controller.BgpPeerManager;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.protocol.BgpMessage;
import org.onosproject.bgpio.protocol.linkstate.BgpNodeLSIdentifier;
import org.onosproject.bgpio.protocol.linkstate.BgpNodeLSNlriVer4;
import org.onosproject.bgpio.protocol.linkstate.NodeDescriptors;
import org.onosproject.bgpio.types.AutonomousSystemTlv;
import org.onosproject.bgpio.types.RouteDistinguisher;
import org.onosproject.net.DeviceId;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceProvider;
import org.onosproject.net.device.DeviceProviderRegistry;
import org.onosproject.net.device.DeviceProviderService;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.device.PortStatistics;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.provider.bgp.topology.impl.BgpTopologyProvider;

public class BgpTopologyProviderTest {
    private static final DeviceId DID1 = DeviceId.deviceId((String)"bgp:rd=0:proto=direct:id=0:as=100");
    private static final DeviceId DID2 = DeviceId.deviceId((String)"bgp:rd=0:proto=direct:id=0:as=10");
    private static final DeviceId DID3 = DeviceId.deviceId((String)"bgp:rd=0:proto=direct:id=0:as=100");
    private final BgpTopologyProvider provider = new BgpTopologyProvider();
    private final TestDeviceRegistry nodeRegistry = new TestDeviceRegistry();
    private final TestController controller = new TestController();

    @Before
    public void startUp() {
        this.provider.deviceProviderRegistry = this.nodeRegistry;
        this.provider.controller = this.controller;
        this.provider.activate();
        Assert.assertNotNull((String)"provider should be registered", (Object)this.nodeRegistry.provider);
        Assert.assertNotNull((String)"listener should be registered", this.controller.nodeListener);
    }

    @After
    public void tearDown() {
        this.provider.deactivate();
        Assert.assertNull((String)"listener should be removed", this.controller.nodeListener);
        this.provider.controller = null;
        this.provider.deviceProviderRegistry = null;
    }

    @Test
    public void bgpTopologyProviderTestAddDevice1() {
        int deviceAddCount = 0;
        LinkedList<AutonomousSystemTlv> subTlvs = new LinkedList<AutonomousSystemTlv>();
        AutonomousSystemTlv tlv = new AutonomousSystemTlv(100);
        short deslength = 4;
        short desType = 512;
        subTlvs.add(tlv);
        BgpNodeLSIdentifier localNodeDescriptors = new BgpNodeLSIdentifier(new NodeDescriptors(subTlvs, deslength, desType));
        BgpNodeLSNlriVer4 nodeNlri = new BgpNodeLSNlriVer4(0L, 4, localNodeDescriptors, false, new RouteDistinguisher());
        nodeNlri.setNodeLSIdentifier(localNodeDescriptors);
        for (BgpNodeListener l : this.controller.nodeListener) {
            l.addNode(nodeNlri);
            deviceAddCount = this.nodeRegistry.connected.size();
            Assert.assertTrue((deviceAddCount == 1 ? 1 : 0) != 0);
            l.deleteNode(nodeNlri);
            deviceAddCount = this.nodeRegistry.connected.size();
            Assert.assertTrue((deviceAddCount == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void bgpTopologyProviderTestAddDevice2() {
        AutonomousSystemTlv tlv = new AutonomousSystemTlv(10);
        short deslength = 4;
        short desType = 512;
        LinkedList<AutonomousSystemTlv> subTlvs = new LinkedList<AutonomousSystemTlv>();
        subTlvs.add(tlv);
        BgpNodeLSIdentifier localNodeDescriptors = new BgpNodeLSIdentifier(new NodeDescriptors(subTlvs, deslength, desType));
        BgpNodeLSNlriVer4 nodeNlri = new BgpNodeLSNlriVer4(0L, 4, localNodeDescriptors, false, new RouteDistinguisher());
        nodeNlri.setNodeLSIdentifier(localNodeDescriptors);
        for (BgpNodeListener l : this.controller.nodeListener) {
            l.addNode(nodeNlri);
            Assert.assertTrue((String)"Failed to add device", (this.nodeRegistry.connected.size() == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void bgpTopologyProviderTestAddDevice3() {
        AutonomousSystemTlv tlv = new AutonomousSystemTlv(10);
        short deslength = 4;
        short desType = 512;
        LinkedList<AutonomousSystemTlv> subTlvs = new LinkedList<AutonomousSystemTlv>();
        subTlvs.add(tlv);
        BgpNodeLSIdentifier localNodeDescriptors = new BgpNodeLSIdentifier(new NodeDescriptors(subTlvs, deslength, desType));
        BgpNodeLSNlriVer4 nodeNlri = new BgpNodeLSNlriVer4(0L, 4, localNodeDescriptors, false, new RouteDistinguisher());
        nodeNlri.setNodeLSIdentifier(localNodeDescriptors);
        for (BgpNodeListener l : this.controller.nodeListener) {
            l.deleteNode(nodeNlri);
            Assert.assertTrue((String)"Failed to add device", (this.nodeRegistry.connected.size() == 0 ? 1 : 0) != 0);
        }
    }

    private class TestController
    implements BgpController {
        protected Set<BgpNodeListener> nodeListener = new CopyOnWriteArraySet<BgpNodeListener>();

        private TestController() {
        }

        public void addListener(BgpNodeListener nodeListener) {
            this.nodeListener.add(nodeListener);
        }

        public void removeListener(BgpNodeListener nodeListener) {
            this.nodeListener = null;
        }

        public Iterable<BgpPeer> getPeers() {
            return null;
        }

        public BgpPeer getPeer(BgpId bgpId) {
            return null;
        }

        public void writeMsg(BgpId bgpId, BgpMessage msg) {
        }

        public void processBgpPacket(BgpId bgpId, BgpMessage msg) throws BgpParseException {
        }

        public void closeConnectedPeers() {
        }

        public BgpCfg getConfig() {
            return null;
        }

        public int connectedPeerCount() {
            return 0;
        }

        public BgpLocalRib bgpLocalRibVpn() {
            return null;
        }

        public BgpLocalRib bgpLocalRib() {
            return null;
        }

        public BgpPeerManager peerManager() {
            return null;
        }

        public Map<BgpId, BgpPeer> connectedPeers() {
            return null;
        }

        public Set<BgpNodeListener> listener() {
            return null;
        }
    }

    private class TestDeviceRegistry
    implements DeviceProviderRegistry {
        DeviceProvider provider;
        Set<DeviceId> connected = new HashSet<DeviceId>();

        private TestDeviceRegistry() {
        }

        public DeviceProviderService register(DeviceProvider provider) {
            this.provider = provider;
            return new TestProviderService();
        }

        public void unregister(DeviceProvider provider) {
        }

        public Set<ProviderId> getProviders() {
            return null;
        }

        private class TestProviderService
        implements DeviceProviderService {
            private TestProviderService() {
            }

            public DeviceProvider provider() {
                return null;
            }

            public void deviceConnected(DeviceId deviceId, DeviceDescription deviceDescription) {
                if (deviceId.equals((Object)DID1)) {
                    TestDeviceRegistry.this.connected.add(deviceId);
                }
            }

            public void deviceDisconnected(DeviceId deviceId) {
                if (deviceId.equals((Object)DID1)) {
                    TestDeviceRegistry.this.connected.remove(deviceId);
                }
            }

            public void updatePorts(DeviceId deviceId, List<PortDescription> portDescriptions) {
            }

            public void portStatusChanged(DeviceId deviceId, PortDescription portDescription) {
            }

            public void receivedRoleReply(DeviceId deviceId, MastershipRole requested, MastershipRole response) {
            }

            public void updatePortStatistics(DeviceId deviceId, Collection<PortStatistics> portStatistics) {
            }
        }
    }
}

