/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.protocol;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Test;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.protocol.BgpFactories;
import org.onosproject.bgpio.protocol.BgpMessage;
import org.onosproject.bgpio.protocol.BgpMessageReader;
import org.onosproject.bgpio.protocol.BgpNotificationMsg;
import org.onosproject.bgpio.types.BgpHeader;

public class BgpNotificationMsgTest {
    @Test
    public void bgpNotificationMessageTest1() throws BgpParseException {
        byte[] notificationMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 23, 3, 2, 2, -2, -80};
        byte[] testNotificationMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(notificationMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpMessage message = null;
        BgpHeader bgpHeader = new BgpHeader();
        message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpNotificationMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testNotificationMsg = buf.array();
        int iReadLen = buf.writerIndex() - 0;
        testNotificationMsg = new byte[iReadLen];
        buf.readBytes(testNotificationMsg, 0, iReadLen);
        MatcherAssert.assertThat((Object)testNotificationMsg, (Matcher)Is.is((Object)notificationMsg));
    }

    @Test
    public void bgpNotificationMessageTest2() throws BgpParseException {
        byte[] notificationMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 21, 3, 2, 0};
        byte[] testNotificationMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(notificationMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpMessage message = null;
        BgpHeader bgpHeader = new BgpHeader();
        message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpNotificationMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testNotificationMsg = buf.array();
        int iReadLen = buf.writerIndex() - 0;
        testNotificationMsg = new byte[iReadLen];
        buf.readBytes(testNotificationMsg, 0, iReadLen);
        MatcherAssert.assertThat((Object)testNotificationMsg, (Matcher)Is.is((Object)notificationMsg));
    }

    @Test(expected=BgpParseException.class)
    public void bgpNotificationMessageTest3() throws BgpParseException {
        byte[] notificationMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, -1, -1, -1, -1, -1, 0, 21, 3, 2, 0};
        byte[] testNotificationMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(notificationMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpMessage message = null;
        BgpHeader bgpHeader = new BgpHeader();
        message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpNotificationMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testNotificationMsg = buf.array();
        int iReadLen = buf.writerIndex() - 0;
        testNotificationMsg = new byte[iReadLen];
        buf.readBytes(testNotificationMsg, 0, iReadLen);
        MatcherAssert.assertThat((Object)testNotificationMsg, (Matcher)Is.is((Object)notificationMsg));
    }

    @Test(expected=BgpParseException.class)
    public void bgpNotificationMessageTest4() throws BgpParseException {
        byte[] notificationMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 20, 3, 2};
        byte[] testNotificationMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(notificationMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpMessage message = null;
        BgpHeader bgpHeader = new BgpHeader();
        message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpNotificationMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testNotificationMsg = buf.array();
        int iReadLen = buf.writerIndex() - 0;
        testNotificationMsg = new byte[iReadLen];
        buf.readBytes(testNotificationMsg, 0, iReadLen);
        MatcherAssert.assertThat((Object)testNotificationMsg, (Matcher)Is.is((Object)notificationMsg));
    }

    @Test(expected=BgpParseException.class)
    public void bgpNotificationMessageTest5() throws BgpParseException {
        byte[] notificationMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 20, 3, 2, 2};
        byte[] testNotificationMsg = new byte[]{0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(notificationMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpMessage message = null;
        BgpHeader bgpHeader = new BgpHeader();
        message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpNotificationMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        testNotificationMsg = buf.array();
        int iReadLen = buf.writerIndex() - 0;
        testNotificationMsg = new byte[iReadLen];
        buf.readBytes(testNotificationMsg, 0, iReadLen);
        MatcherAssert.assertThat((Object)testNotificationMsg, (Matcher)Is.is((Object)notificationMsg));
    }
}

