/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.protocol;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Test;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.protocol.BgpFactories;
import org.onosproject.bgpio.protocol.BgpMessage;
import org.onosproject.bgpio.protocol.BgpMessageReader;
import org.onosproject.bgpio.protocol.BgpOpenMsg;
import org.onosproject.bgpio.types.BgpHeader;

public class BgpOpenMsgTest {
    @Test
    public void openMessageTest1() throws BgpParseException {
        byte[] openMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 29, 1, 4, -2, 9, 0, -76, -64, -88, 0, 15, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(openMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpOpenMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        byte[] testOpenMsg = new byte[readLen];
        buf.readBytes(testOpenMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testOpenMsg, (Matcher)Is.is((Object)openMsg));
    }

    @Test
    public void openMessageTest2() throws BgpParseException {
        byte[] openMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 37, 1, 4, 0, -56, 0, -76, -74, 2, 93, -56, 8, 2, 6, 1, 4, 0, 0, 0, -56};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(openMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpOpenMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        byte[] testOpenMsg = new byte[readLen];
        buf.readBytes(testOpenMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testOpenMsg, (Matcher)Is.is((Object)openMsg));
    }

    @Test
    public void openMessageTest3() throws BgpParseException {
        byte[] openMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 37, 1, 4, 0, -56, 0, -76, -74, 2, 93, -56, 8, 2, 6, 65, 4, 0, 1, 0, 1};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(openMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpOpenMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        byte[] testOpenMsg = new byte[readLen];
        buf.readBytes(testOpenMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testOpenMsg, (Matcher)Is.is((Object)openMsg));
    }

    @Test
    public void openMessageTest4() throws BgpParseException {
        byte[] openMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 43, 1, 4, 0, -56, 0, -76, -74, 2, 93, -56, 14, 2, 12, 1, 4, 0, 0, 0, -56, 65, 4, 0, 1, 0, 1};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(openMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpOpenMsg.class));
        ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
        message.writeTo(buf);
        int readLen = buf.writerIndex();
        byte[] testOpenMsg = new byte[readLen];
        buf.readBytes(testOpenMsg, 0, readLen);
        MatcherAssert.assertThat((Object)testOpenMsg, (Matcher)Is.is((Object)openMsg));
    }

    @Test(expected=BgpParseException.class)
    public void openMessageTest5() throws BgpParseException {
        byte[] openMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 29, 1, 5, -2, 9, 0, -76, -64, -88, 0, 15, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(openMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpOpenMsg.class));
    }

    @Test(expected=BgpParseException.class)
    public void openMessageTest6() throws BgpParseException {
        byte[] openMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, 0, 0, 29, 1, 4, -2, 9, 0, -76, -64, -88, 0, 15, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(openMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpOpenMsg.class));
    }

    @Test(expected=BgpParseException.class)
    public void openMessageTest7() throws BgpParseException {
        byte[] openMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 30, 1, 4, -2, 9, 0, -76, -64, -88, 0, 15, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(openMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpOpenMsg.class));
    }

    @Test(expected=BgpParseException.class)
    public void openMessageTest8() throws BgpParseException {
        byte[] openMsg = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 29, 5, 4, -2, 9, 0, -76, -64, -88, 0, 15, 0};
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        buffer.writeBytes(openMsg);
        BgpMessageReader reader = BgpFactories.getGenericReader();
        BgpHeader bgpHeader = new BgpHeader();
        BgpMessage message = (BgpMessage)reader.readFrom(buffer, bgpHeader);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.instanceOf(BgpOpenMsg.class));
    }
}

