/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.protocol.linkstate;

import com.google.common.base.MoreObjects;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.protocol.linkstate.NodeDescriptors;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.types.IPReachabilityInformationTlv;
import org.onosproject.bgpio.types.OSPFRouteTypeTlv;
import org.onosproject.bgpio.types.attr.BgpAttrNodeMultiTopologyId;
import org.onosproject.bgpio.util.UnSupportedAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpPrefixLSIdentifier
implements Comparable<Object> {
    protected static final Logger log = LoggerFactory.getLogger(BgpPrefixLSIdentifier.class);
    public static final int TYPE_AND_LEN = 4;
    private NodeDescriptors localNodeDescriptors;
    private List<BgpValueType> prefixDescriptor;

    public BgpPrefixLSIdentifier() {
        this.localNodeDescriptors = null;
        this.prefixDescriptor = null;
    }

    public BgpPrefixLSIdentifier(NodeDescriptors localNodeDescriptors, List<BgpValueType> prefixDescriptor) {
        this.localNodeDescriptors = localNodeDescriptors;
        this.prefixDescriptor = prefixDescriptor;
    }

    public static BgpPrefixLSIdentifier parsePrefixIdendifier(ChannelBuffer cb, byte protocolId) throws BgpParseException {
        NodeDescriptors localNodeDescriptors = new NodeDescriptors();
        localNodeDescriptors = BgpPrefixLSIdentifier.parseLocalNodeDescriptors(cb, protocolId);
        LinkedList<BgpValueType> prefixDescriptor = new LinkedList();
        prefixDescriptor = BgpPrefixLSIdentifier.parsePrefixDescriptors(cb);
        return new BgpPrefixLSIdentifier(localNodeDescriptors, prefixDescriptor);
    }

    public static NodeDescriptors parseLocalNodeDescriptors(ChannelBuffer cb, byte protocolId) throws BgpParseException {
        ChannelBuffer tempBuf = cb.copy();
        short type = cb.readShort();
        short length = cb.readShort();
        if (cb.readableBytes() < length) {
            throw new BgpParseException(3, 9, tempBuf.readBytes(cb.readableBytes() + 4));
        }
        NodeDescriptors localNodeDescriptors = new NodeDescriptors();
        ChannelBuffer tempCb = cb.readBytes((int)length);
        if (type != 256) {
            throw new BgpParseException(3, 1, null);
        }
        localNodeDescriptors = NodeDescriptors.read(tempCb, length, type, protocolId);
        return localNodeDescriptors;
    }

    public static List<BgpValueType> parsePrefixDescriptors(ChannelBuffer cb) throws BgpParseException {
        LinkedList<BgpValueType> prefixDescriptor = new LinkedList<BgpValueType>();
        BgpValueType tlv = null;
        boolean isIpReachInfo = false;
        int count = 0;
        while (cb.readableBytes() > 0) {
            ChannelBuffer tempBuf = cb.copy();
            short type = cb.readShort();
            short length = cb.readShort();
            if (cb.readableBytes() < length) {
                throw new BgpParseException(3, 9, tempBuf.readBytes(cb.readableBytes() + 4));
            }
            ChannelBuffer tempCb = cb.readBytes((int)length);
            switch (type) {
                case 264: {
                    tlv = OSPFRouteTypeTlv.read(tempCb);
                    break;
                }
                case 265: {
                    tlv = IPReachabilityInformationTlv.read(tempCb, length);
                    isIpReachInfo = true;
                    break;
                }
                case 263: {
                    tlv = BgpAttrNodeMultiTopologyId.read(tempCb);
                    if (++count <= 1) break;
                    throw new BgpParseException(3, 9, tempBuf.readBytes(length + 4));
                }
                default: {
                    UnSupportedAttribute.skipBytes(tempCb, length);
                }
            }
            prefixDescriptor.add(tlv);
        }
        if (!isIpReachInfo) {
            throw new BgpParseException(3, 9, null);
        }
        return prefixDescriptor;
    }

    public NodeDescriptors getLocalNodeDescriptors() {
        return this.localNodeDescriptors;
    }

    public List<BgpValueType> getPrefixdescriptor() {
        return this.prefixDescriptor;
    }

    public int hashCode() {
        return Objects.hash(this.prefixDescriptor.hashCode(), this.localNodeDescriptors);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BgpPrefixLSIdentifier) {
            int countObjSubTlv = 0;
            int countOtherSubTlv = 0;
            boolean isCommonSubTlv = true;
            BgpPrefixLSIdentifier other = (BgpPrefixLSIdentifier)obj;
            Iterator<BgpValueType> objListIterator = other.prefixDescriptor.iterator();
            countOtherSubTlv = other.prefixDescriptor.size();
            countObjSubTlv = this.prefixDescriptor.size();
            if (countObjSubTlv != countOtherSubTlv) {
                return false;
            }
            while (objListIterator.hasNext() && isCommonSubTlv) {
                BgpValueType subTlv = objListIterator.next();
                if (this.prefixDescriptor.contains(subTlv) && other.prefixDescriptor.contains(subTlv)) {
                    isCommonSubTlv = Objects.equals(this.prefixDescriptor.get(this.prefixDescriptor.indexOf(subTlv)), other.prefixDescriptor.get(other.prefixDescriptor.indexOf(subTlv)));
                    continue;
                }
                isCommonSubTlv = false;
            }
            return isCommonSubTlv && Objects.equals(this.localNodeDescriptors, other.localNodeDescriptors);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("localNodeDescriptors", (Object)this.localNodeDescriptors).add("prefixDescriptor", this.prefixDescriptor).toString();
    }

    @Override
    public int compareTo(Object o) {
        int countObjSubTlv;
        if (this.equals(o)) {
            return 0;
        }
        int result = this.localNodeDescriptors.compareTo(((BgpPrefixLSIdentifier)o).localNodeDescriptors);
        if (result != 0) {
            return result;
        }
        int countOtherSubTlv = ((BgpPrefixLSIdentifier)o).prefixDescriptor.size();
        if (countOtherSubTlv != (countObjSubTlv = this.prefixDescriptor.size())) {
            if (countOtherSubTlv > countObjSubTlv) {
                return 1;
            }
            return -1;
        }
        ListIterator<BgpValueType> listIterator = this.prefixDescriptor.listIterator();
        ListIterator<BgpValueType> listIteratorOther = ((BgpPrefixLSIdentifier)o).prefixDescriptor.listIterator();
        while (listIterator.hasNext()) {
            BgpValueType tlv = listIterator.next();
            if (this.prefixDescriptor.contains(tlv) && ((BgpPrefixLSIdentifier)o).prefixDescriptor.contains(tlv)) {
                int res = this.prefixDescriptor.get(this.prefixDescriptor.indexOf(tlv)).compareTo(((BgpPrefixLSIdentifier)o).prefixDescriptor.get(((BgpPrefixLSIdentifier)o).prefixDescriptor.indexOf(tlv)));
                if (res == 0) continue;
                return res;
            }
            return 1;
        }
        return 0;
    }
}

