/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.bgpio.protocol.ver4;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.onosproject.bgpio.exceptions.BgpParseException;
import org.onosproject.bgpio.types.As4Path;
import org.onosproject.bgpio.types.AsPath;
import org.onosproject.bgpio.types.BgpValueType;
import org.onosproject.bgpio.types.LinkStateAttributes;
import org.onosproject.bgpio.types.LocalPref;
import org.onosproject.bgpio.types.Med;
import org.onosproject.bgpio.types.MpReachNlri;
import org.onosproject.bgpio.types.MpUnReachNlri;
import org.onosproject.bgpio.types.NextHop;
import org.onosproject.bgpio.types.Origin;
import org.onosproject.bgpio.util.UnSupportedAttribute;
import org.onosproject.bgpio.util.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BgpPathAttributes {
    protected static final Logger log = LoggerFactory.getLogger(BgpPathAttributes.class);
    public static final int LINK_STATE_ATTRIBUTE_TYPE = 29;
    public static final int MPREACHNLRI_TYPE = 14;
    public static final int MPUNREACHNLRI_TYPE = 15;
    private final List<BgpValueType> pathAttribute;

    public BgpPathAttributes() {
        this.pathAttribute = null;
    }

    public BgpPathAttributes(List<BgpValueType> pathAttribute) {
        this.pathAttribute = pathAttribute;
    }

    public List<BgpValueType> pathAttributes() {
        return this.pathAttribute;
    }

    public static BgpPathAttributes read(ChannelBuffer cb) throws BgpParseException {
        BgpValueType pathAttribute = null;
        LinkedList<BgpValueType> pathAttributeList = new LinkedList<BgpValueType>();
        boolean isOrigin = false;
        boolean isAsPath = false;
        boolean isNextHop = false;
        boolean isMpReach = false;
        boolean isMpUnReach = false;
        while (cb.readableBytes() > 0) {
            cb.markReaderIndex();
            byte flags = cb.readByte();
            byte typeCode = cb.readByte();
            cb.resetReaderIndex();
            switch (typeCode) {
                case 1: {
                    pathAttribute = Origin.read(cb);
                    isOrigin = ((Origin)pathAttribute).isOriginSet();
                    break;
                }
                case 2: {
                    pathAttribute = AsPath.read(cb);
                    isAsPath = ((AsPath)pathAttribute).isaspathSet();
                    break;
                }
                case 17: {
                    pathAttribute = As4Path.read(cb);
                    break;
                }
                case 3: {
                    pathAttribute = NextHop.read(cb);
                    isNextHop = ((NextHop)pathAttribute).isNextHopSet();
                    break;
                }
                case 4: {
                    pathAttribute = Med.read(cb);
                    break;
                }
                case 5: {
                    pathAttribute = LocalPref.read(cb);
                    break;
                }
                case 14: {
                    pathAttribute = MpReachNlri.read(cb);
                    isMpReach = ((MpReachNlri)pathAttribute).isMpReachNlriSet();
                    break;
                }
                case 15: {
                    pathAttribute = MpUnReachNlri.read(cb);
                    isMpUnReach = ((MpUnReachNlri)pathAttribute).isMpUnReachNlriSet();
                    break;
                }
                case 29: {
                    pathAttribute = LinkStateAttributes.read(cb);
                    break;
                }
                default: {
                    UnSupportedAttribute.read(cb);
                }
            }
            pathAttributeList.add(pathAttribute);
        }
        BgpPathAttributes.checkMandatoryAttr(isOrigin, isAsPath, isNextHop, isMpReach, isMpUnReach);
        return new BgpPathAttributes(pathAttributeList);
    }

    public static void checkMandatoryAttr(boolean isOrigin, boolean isAsPath, boolean isNextHop, boolean isMpReach, boolean isMpUnReach) throws BgpParseException {
        if (isMpUnReach) {
            return;
        }
        if (!isOrigin) {
            log.debug("Mandatory Attributes not Present");
            Validation.validateType((byte)3, (byte)3, 1);
        }
        if (!isAsPath) {
            log.debug("Mandatory Attributes not Present");
            Validation.validateType((byte)3, (byte)3, 2);
        }
        if (!(isMpUnReach || isMpReach || isNextHop)) {
            log.debug("Mandatory Attributes not Present");
            Validation.validateType((byte)3, (byte)3, 3);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("pathAttribute", this.pathAttribute).toString();
    }
}

